/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority;

import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IPseudoAtom;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.priority.AbstractPriorityRule;
import uk.ac.ebi.centres.priority.access.MassNumberAccessor;

public class MassNumberRule<A>
extends AbstractPriorityRule<A> {
    private final MassNumberAccessor<A> accessor;

    public MassNumberRule(MassNumberAccessor<A> accessor) {
        super(PriorityRule.Type.CONSTITUTIONAL);
        this.accessor = accessor;
    }

    @Override
    public int compare(Ligand<A> o1, Ligand<A> o2) {
        if (this.accessor == null || o1.getAtom() == null) {
            System.out.println(this.accessor + " 1 NULL");
        }
        if (this.accessor == null || o2.getAtom() == null) {
            System.out.println(this.accessor + " 2 NULL");
        }
        IAtom a = (IAtom)o1.getAtom();
        IAtom b = (IAtom)o2.getAtom();
        return this.getMassNumber(a) - this.getMassNumber(b);
    }

    public int getMassNumber(IAtom o) {
        if (o != null && !(o instanceof IPseudoAtom) && o.getMassNumber() == null) {
            try {
                int massNumber = Isotopes.getInstance().getMajorIsotope(o.getAtomicNumber()).getMassNumber();
                return massNumber;
            }
            catch (Exception e) {
                return 11;
            }
        }
        if (o instanceof IPseudoAtom) {
            return 11;
        }
        return 0;
    }
}

