/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority.descriptor;

import com.google.common.collect.Maps;
import java.util.Map;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.priority.AbstractPriorityRule;
import uk.ac.ebi.centres.priority.access.DescriptorAccessor;

public class DescriptorRule<A>
extends AbstractPriorityRule<A> {
    private DescriptorAccessor<A> accessor;
    private Map<Descriptor, Integer> ranking;

    public DescriptorRule(DescriptorAccessor<A> accessor, PriorityRule.Type ordering, Descriptor ... descriptors) {
        this(Descriptor.Type.ASYMMETRIC, ordering, accessor, descriptors);
    }

    public DescriptorRule(Descriptor.Type type, PriorityRule.Type ordering, DescriptorAccessor<A> accessor, Descriptor ... descriptors) {
        super(type, ordering);
        this.accessor = accessor;
        this.ranking = Maps.newHashMapWithExpectedSize(descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            this.ranking.put(descriptors[i], i + 1);
        }
    }

    private int getRank(Ligand<A> ligand) {
        Descriptor descriptor = this.accessor.getDescriptor(ligand);
        Integer rank = this.ranking.get(descriptor);
        return rank == null ? 0 : rank;
    }

    @Override
    public int compare(Ligand<A> o1, Ligand<A> o2) {
        return this.getRank(o1) - this.getRank(o2);
    }
}

