/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.containers;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.fingerprints.tools.Similarity;
import uk.ac.ebi.reactionblast.interfaces.IFingerPrintContainer;

public class FingerPrintContainer
implements IFingerPrintContainer {
    private static FingerPrintContainer _instance = null;
    private static Map<String, BitSet> FingerPrintMap = null;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(FingerPrintContainer.class);

    public static synchronized FingerPrintContainer getInstance() {
        if (_instance == null) {
            _instance = new FingerPrintContainer();
        }
        return _instance;
    }

    private FingerPrintContainer() {
        FingerPrintMap = Collections.synchronizedSortedMap(new TreeMap());
    }

    @Override
    public synchronized void Clear() throws IOException {
        FingerPrintMap.clear();
        FingerPrintMap = Collections.synchronizedSortedMap(new TreeMap());
    }

    @Override
    public synchronized void Erase(String Key2) throws IOException {
        FingerPrintMap.remove(Key2);
    }

    public synchronized Integer getCount() {
        return FingerPrintMap.size();
    }

    @Override
    public synchronized void put(String Key2, BitSet Value2) throws IOException {
        try {
            FingerPrintMap.put(Key2, Value2);
        }
        catch (Exception e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
    }

    @Override
    public synchronized BitSet getFingerPrint(String Key2) throws IOException {
        BitSet value = FingerPrintMap.get(Key2);
        return value;
    }

    @Override
    public synchronized String getMoleculeID(BitSet bitset) throws IOException {
        String Key2 = null;
        for (Map.Entry<String, BitSet> map : FingerPrintMap.entrySet()) {
            String key = map.getKey();
            try {
                if ((double)Similarity.getTanimotoSimilarity(map.getValue(), bitset) != 1.0) continue;
                Key2 = key;
                break;
            }
            catch (Exception ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        return Key2;
    }

    @Override
    public synchronized Map<String, BitSet> getFingerPrintMap() throws IOException {
        return Collections.unmodifiableMap(FingerPrintMap);
    }

    @Override
    public synchronized boolean isKeyPresent(String Key2) throws IOException {
        return FingerPrintMap.containsKey(Key2);
    }

    @Override
    public synchronized void setValue(String Key2, BitSet Value2) throws IOException {
        FingerPrintMap.put(Key2, Value2);
    }

    public synchronized Set<String> getCompoundIDSet() {
        return FingerPrintMap.keySet();
    }

    @Override
    public synchronized boolean isValuePresent(BitSet value) throws IOException {
        for (BitSet bitset : FingerPrintMap.values()) {
            try {
                if ((double)Similarity.getTanimotoSimilarity(value, bitset) != 1.0) continue;
                return true;
            }
            catch (Exception ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isEmpty() throws IOException {
        return FingerPrintMap.isEmpty();
    }

    @Override
    public void write() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

