/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.containers;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.Substructure;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.interfaces.IMolContainer;

public class MolContainer
implements IMolContainer {
    private static MolContainer _instance = null;
    private static Map<String, IAtomContainer> molContainer = null;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MolContainer.class);

    public static synchronized MolContainer getInstance() {
        if (_instance == null) {
            _instance = new MolContainer();
        }
        return _instance;
    }

    private MolContainer() {
        molContainer = Collections.synchronizedSortedMap(new TreeMap());
    }

    @Override
    public synchronized void Clear() throws IOException {
        molContainer.clear();
        molContainer = Collections.synchronizedSortedMap(new TreeMap());
    }

    @Override
    public synchronized void Erase(String key) throws IOException {
        molContainer.remove(key);
    }

    @Override
    public synchronized void put(String key, IAtomContainer Value2) throws IOException {
        try {
            molContainer.put(key, Value2);
        }
        catch (Exception e) {
            LOGGER.debug(e);
        }
    }

    @Override
    public synchronized IAtomContainer getAtomContainer(String key) throws IOException {
        return molContainer.get(key);
    }

    @Override
    public synchronized Map<String, IAtomContainer> getAtomContainerMap() throws IOException {
        return Collections.unmodifiableMap(molContainer);
    }

    @Override
    public synchronized boolean isKeyPresent(String key) throws IOException {
        return molContainer.containsKey(key);
    }

    @Override
    public synchronized void add(String key, IAtomContainer value) throws IOException {
        molContainer.put(key, value);
    }

    public synchronized boolean isIdentical(IAtomContainer _queryMol, IAtomContainer _targetMol, boolean removeHydrogen) throws Exception {
        _targetMol = ExtAtomContainerManipulator.cloneWithIDs(_targetMol);
        if (_queryMol.getAtomCount() == 1 && _targetMol.getAtomCount() == 1) {
            IAtom a = _queryMol.atoms().iterator().next();
            IAtom b = _targetMol.atoms().iterator().next();
            return a.getSymbol().equalsIgnoreCase(b.getSymbol()) && Objects.equals(a.getFormalCharge(), b.getFormalCharge());
        }
        return this.isSubgraphIdentical(_queryMol, _targetMol, removeHydrogen);
    }

    private synchronized boolean isSubgraphIdentical(IAtomContainer _mol, IAtomContainer _rMol, boolean removeHydrogen) throws CDKException, IOException {
        IAtomContainer mol1 = _mol;
        IAtomContainer mol2 = _rMol;
        AtomMatcher atomMatcher = AtomBondMatcher.atomMatcher(true, true);
        BondMatcher bondMatcher = AtomBondMatcher.bondMatcher(true, true);
        Substructure mcs = new Substructure(mol1, mol2, atomMatcher, bondMatcher, false);
        mcs.setChemFilters(false, false, false);
        return mcs.isSubgraph() && !mcs.isStereoMisMatch() && mol1.getAtomCount() == mol2.getAtomCount();
    }

    @Override
    public synchronized boolean compareAtomContainer(String key, IAtomContainer mol) throws Exception {
        mol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
        try {
            boolean flag = molContainer.containsKey(key);
            if (flag && mol.getAtomCount() > 0) {
                IAtomContainer molFromContainer = molContainer.get(key);
                return this.isIdentical(mol, molFromContainer, true);
            }
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public synchronized String getMoleculeID(IAtomContainer mol) throws Exception {
        IAtomContainer queryMol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(queryMol);
        CDKHydrogenAdder instance = CDKHydrogenAdder.getInstance(queryMol.getBuilder());
        for (IAtom iAtom : queryMol.atoms()) {
            try {
                instance.addImplicitHydrogens(queryMol, iAtom);
            }
            catch (CDKException e) {
                LOGGER.error("WARNING: Error in adding H to the molecule");
            }
        }
        ExtAtomContainerManipulator.aromatizeMolecule(queryMol);
        for (Map.Entry entry : molContainer.entrySet()) {
            String key = (String)entry.getKey();
            IAtomContainer tMol = (IAtomContainer)entry.getValue();
            if (!this.isIdentical(queryMol, tMol, true)) continue;
            return key;
        }
        return null;
    }

    @Override
    public synchronized boolean isValuePresent(IAtomContainer Value2) throws IOException {
        return molContainer.containsValue(Value2);
    }

    public synchronized boolean isEmpty() {
        return molContainer.isEmpty();
    }

    @Override
    public void write() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

