/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.fingerprints;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Comparator;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IFeature;

public class Feature
implements IFeature,
Comparable<IFeature>,
Comparator<IFeature>,
Serializable {
    private static final long serialVersionUID = 15858544734838L;
    private final String pattern;
    private double weight;

    public Feature(String feature, double weight) {
        this.pattern = feature;
        this.weight = weight;
    }

    public Feature(String feature) {
        this(feature, 1.0);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return !(this.pattern != null ? !this.pattern.equals(other.pattern) : other.pattern != null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        return hash;
    }

    @Override
    public synchronized String toString() {
        DecimalFormat df = new DecimalFormat("##.0");
        StringBuilder result = new StringBuilder();
        result.append(this.pattern).append(":").append(df.format(this.weight));
        return result.toString();
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(IFeature feature) {
        return this.pattern.compareTo(feature.getPattern());
    }

    @Override
    public int compare(IFeature o1, IFeature o2) {
        return o1.getPattern().compareTo(o2.getPattern());
    }

    @Override
    public void setValue(double weight) {
        this.weight = weight;
    }
}

