/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.fingerprints;

import java.util.Comparator;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;

class PatternComparators {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(PatternComparators.class);

    public static Comparator<IPatternFingerprinter> overallComparator() {
        return (o1, o2) -> {
            int len1 = o1.getFeatureCount();
            int len2 = o2.getFeatureCount();
            if (!o1.getFingerprintID().equals(o2.getFingerprintID())) {
                return o1.getFingerprintID().compareTo(o2.getFingerprintID());
            }
            int n = Math.min(len1, len2);
            if (len1 == len2) {
                int pos = 0;
                while (n-- != 0) {
                    try {
                        double v2;
                        double v1;
                        if (!o1.getFeature(pos).equals(o2.getFeature(pos))) {
                            return o1.getFeature(pos).compareTo(o2.getFeature(pos));
                        }
                        if (!o1.getFeature(pos).equals(o2.getFeature(pos)) && (v1 = o1.getWeight(pos).doubleValue()) != (v2 = o2.getWeight(pos).doubleValue())) {
                            return (int)(Math.max(v1, v2) - Math.min(v1, v2));
                        }
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                    ++pos;
                }
            }
            return Math.max(len1, len2) - n;
        };
    }

    public static Comparator<IPatternFingerprinter> dataComparator() {
        return (o1, o2) -> {
            int len1 = o1.getFeatureCount();
            int len2 = o2.getFeatureCount();
            if (!o1.getFingerprintID().equals(o2.getFingerprintID())) {
                return o1.getFingerprintID().compareTo(o2.getFingerprintID());
            }
            int n = Math.min(len1, len2);
            if (len1 == len2) {
                int pos = 0;
                while (n-- != 0) {
                    double v2;
                    double v1 = o1.getWeight(pos);
                    if (v1 != (v2 = o2.getWeight(pos).doubleValue())) {
                        return (int)(Math.max(v1, v2) - Math.min(v1, v2));
                    }
                    ++pos;
                }
            }
            return Math.max(len1, len2) - n;
        };
    }

    private PatternComparators() {
    }
}

