/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.fingerprints;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.fingerprints.Feature;
import uk.ac.ebi.reactionblast.fingerprints.FingerprintGenerator;
import uk.ac.ebi.reactionblast.fingerprints.PatternComparators;
import uk.ac.ebi.reactionblast.fingerprints.RandomNumber;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IFeature;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;

public class PatternFingerprinter
implements Cloneable,
IPatternFingerprinter,
Comparable<IPatternFingerprinter>,
Comparator<IPatternFingerprinter>,
Serializable {
    private static final long serialVersionUID = 1988575747348383727L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(PatternFingerprinter.class);
    private final Set<IFeature> featureSet;
    private String fingerprintID = "?";
    private int fingerprintSize;

    public static IPatternFingerprinter makePatternFingerprint(Map<String, Double> map) {
        return PatternFingerprinter.makePatternFingerprint(map.keySet(), map.values());
    }

    public static IPatternFingerprinter makePatternFingerprint(Collection<String> keyCollection, Collection<Double> valueCollection) {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        ArrayList<String> keyList = new ArrayList<String>(keyCollection);
        ArrayList<Double> valueList = new ArrayList<Double>(valueCollection);
        for (int index = 0; index < keyList.size(); ++index) {
            String key = (String)keyList.get(index);
            Double value = (Double)valueList.get(index);
            features.add(new Feature(key, value));
        }
        return new PatternFingerprinter(features);
    }

    public PatternFingerprinter() {
        this(FingerprintGenerator.getFingerprinterSize());
    }

    public PatternFingerprinter(Collection<IFeature> features) {
        this(features, FingerprintGenerator.getFingerprinterSize());
    }

    public PatternFingerprinter(int fingerprintSize) {
        this.fingerprintSize = fingerprintSize;
        this.featureSet = Collections.synchronizedSortedSet(new TreeSet());
    }

    public PatternFingerprinter(Collection<IFeature> features, int fingerprintSize) {
        this(fingerprintSize);
        block0: for (IFeature feature : features) {
            if (!this.featureSet.contains(feature)) {
                this.featureSet.add(new Feature(feature.getPattern()));
                continue;
            }
            for (IFeature localFeature : this.featureSet) {
                if (!localFeature.getPattern().equals(feature.getPattern())) continue;
                double newWeight = localFeature.getWeight() + feature.getWeight();
                localFeature.setValue(newWeight);
                continue block0;
            }
        }
    }

    @Override
    public synchronized void addBinary(BitSet fingerprint) throws CDKException {
        if (this.featureSet == null) {
            throw new CDKException("Cannot perform PatternFingerprint.add() as Fingerprint not initialized");
        }
        for (int i = 0; i < fingerprint.size(); ++i) {
            if (!fingerprint.get(i)) continue;
            this.add(new Feature(String.valueOf(i), 1.0));
        }
    }

    @Override
    public synchronized void add(IFeature feature) throws CDKException {
        if (this.featureSet == null) {
            throw new CDKException("Cannot perform PatternFingerprint.add() as Fingerprint not initialized");
        }
        if (!this.featureSet.contains(feature)) {
            this.featureSet.add(new Feature(feature.getPattern(), feature.getWeight()));
        } else {
            for (IFeature localFeature : this.featureSet) {
                if (!localFeature.getPattern().equals(feature.getPattern())) continue;
                double newWeight = localFeature.getWeight() + feature.getWeight();
                localFeature.setValue(newWeight);
                break;
            }
        }
    }

    @Override
    public synchronized void add(IPatternFingerprinter fngp) throws CDKException {
        if (this.featureSet == null || fngp == null) {
            throw new CDKException("Cannot perform PatternFingerprint.add() as Fingerprint not initialized");
        }
        if (fngp.getFingerprintSize() != this.fingerprintSize) {
            throw new CDKException("Cannot perform PatternFingerprint.add() as Fingerprint size not equal");
        }
        block0: for (IFeature feature : fngp.getFeatures()) {
            if (!this.featureSet.contains(feature)) {
                this.featureSet.add(new Feature(feature.getPattern(), feature.getWeight()));
                continue;
            }
            for (IFeature localFeature : this.featureSet) {
                if (!localFeature.getPattern().equals(feature.getPattern())) continue;
                double newWeight = localFeature.getWeight() + feature.getWeight();
                localFeature.setValue(newWeight);
                continue block0;
            }
        }
    }

    @Override
    public double[] getValuesAsArray() {
        int pos = 0;
        double[] res = new double[this.featureSet.size()];
        for (IFeature feature : this.featureSet) {
            res[pos] = feature.getWeight();
            ++pos;
        }
        return res;
    }

    @Override
    public Collection<IFeature> getFeatures() {
        return Collections.unmodifiableCollection(this.featureSet);
    }

    @Override
    public Collection<Double> getValues() {
        ArrayList<Double> collection = new ArrayList<Double>(this.featureSet.size());
        int i = 0;
        for (IFeature feature : this.featureSet) {
            collection.add(i, feature.getWeight());
            ++i;
        }
        return collection;
    }

    @Override
    public int getFeatureCount() {
        return this.featureSet.size();
    }

    @Override
    public BitSet getHashedFingerPrint() {
        double[] weightedHashedFingerPrint = this.getWeightedHashedFingerPrint();
        BitSet binary = new BitSet(this.fingerprintSize);
        for (int i = 0; i < weightedHashedFingerPrint.length; ++i) {
            if (weightedHashedFingerPrint[i] > 0.0) {
                binary.set(i, true);
                continue;
            }
            binary.set(i, false);
        }
        return binary;
    }

    @Override
    public double[] getWeightedHashedFingerPrint() {
        RandomNumber randomNumberGen = new RandomNumber();
        double[] hashedFingerPrint = new double[this.fingerprintSize];
        for (int i = 0; i < hashedFingerPrint.length; ++i) {
            hashedFingerPrint[i] = 0.0;
        }
        Collection<IFeature> features = this.getFeatures();
        features.stream().forEach(feature -> {
            int randomNumber;
            long hashCode = feature.hashCode();
            int n = randomNumber = randomNumberGen.generateMersenneTwisterRandomNumber(this.fingerprintSize, hashCode);
            hashedFingerPrint[n] = hashedFingerPrint[n] + feature.getWeight();
        });
        return hashedFingerPrint;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat();
        result.append(NEW_LINE);
        result.append("ID=").append(this.fingerprintID);
        result.append(" (").append(this.featureSet.size()).append(")");
        result.append(NEW_LINE);
        result.append(this.getFeatures());
        result.append(NEW_LINE);
        return result.toString();
    }

    @Override
    public IFeature getFeature(int index) throws CDKException {
        if (this.featureSet.size() >= index) {
            int i = 0;
            for (IFeature key : this.featureSet) {
                if (i == index) {
                    return key;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Double getWeight(String pattern) {
        if (!this.featureSet.isEmpty()) {
            int i = 0;
            for (IFeature key : this.featureSet) {
                if (key.getPattern().equals(pattern)) {
                    return key.getWeight();
                }
                ++i;
            }
        }
        return -1.0;
    }

    @Override
    public Double getWeight(int index) {
        if (this.featureSet.size() >= index) {
            int i = 0;
            for (IFeature value : this.featureSet) {
                if (i == index) {
                    return value.getWeight();
                }
                ++i;
            }
        }
        return -1.0;
    }

    @Override
    public String getFingerprintID() {
        return this.fingerprintID;
    }

    @Override
    public void setFingerprintID(String fingerprintID) {
        this.fingerprintID = fingerprintID;
    }

    @Override
    public synchronized int compare(IPatternFingerprinter o1, IPatternFingerprinter o2) {
        Comparator<IPatternFingerprinter> comparator = PatternComparators.overallComparator();
        return comparator.compare(o1, o2);
    }

    @Override
    public synchronized int compareTo(IPatternFingerprinter t) {
        return this.compare(this, t);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PatternFingerprinter other = (PatternFingerprinter)object;
        if (!(this.featureSet == other.featureSet || this.featureSet != null && this.featureSet.equals(other.featureSet))) {
            return false;
        }
        if (this.fingerprintID == null ? other.fingerprintID != null : !this.fingerprintID.equals(other.fingerprintID)) {
            return false;
        }
        return this.fingerprintSize == other.fingerprintSize;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.featureSet != null ? this.featureSet.hashCode() : 0);
        hash = 83 * hash + (this.fingerprintID != null ? this.fingerprintID.hashCode() : 0);
        hash = 83 * hash + this.fingerprintSize;
        return hash;
    }

    @Override
    public int getFingerprintSize() {
        return this.fingerprintSize;
    }

    @Override
    public boolean hasFeature(IFeature key) {
        return this.featureSet.contains(key);
    }

    @Override
    public IPatternFingerprinter clone() throws CloneNotSupportedException {
        PatternFingerprinter p = new PatternFingerprinter(this.fingerprintSize);
        try {
            p.add(this);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return p;
    }
}

