/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.fingerprints;

import java.io.Serializable;
import java.util.BitSet;
import java.util.logging.Level;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.fingerprints.Feature;
import uk.ac.ebi.reactionblast.fingerprints.FingerprintGenerator;
import uk.ac.ebi.reactionblast.fingerprints.PatternFingerprinter;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.graphics.direct.DirectReactionDrawer;

public class ReactionFingerprinter
implements Serializable {
    private static final long serialVersionUID = 7867867834118778L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(DirectReactionDrawer.class);
    private final IPatternFingerprinter reactionFingerprint;

    private static IPatternFingerprinter getSumOfFingerprints(IAtomContainerSet molSet) throws CDKException, Exception {
        FingerprintGenerator molFingerprint = new FingerprintGenerator();
        PatternFingerprinter fp = new PatternFingerprinter(FingerprintGenerator.getFingerprinterSize());
        for (IAtomContainer mol : molSet.atomContainers()) {
            BitSet booleanArray = molFingerprint.getFingerprint(mol);
            for (int i = 0; i < booleanArray.size(); ++i) {
                if (!booleanArray.get(i)) continue;
                fp.add(new Feature(String.valueOf(i), 1.0));
            }
        }
        return fp;
    }

    private static IPatternFingerprinter summationPatterns(IPatternFingerprinter pattern1, IPatternFingerprinter pattern2) throws CDKException {
        PatternFingerprinter patternFingerprinter = null;
        if (pattern1 == null || pattern2 == null || pattern1.getFingerprintSize() != pattern2.getFingerprintSize()) {
            throw new CDKException("Index < 0: ");
        }
        patternFingerprinter = new PatternFingerprinter(pattern1.getFingerprintSize());
        patternFingerprinter.add(pattern1);
        patternFingerprinter.add(pattern2);
        return patternFingerprinter;
    }

    public static IReaction expandReactionAndRemoveHydrogens(IReaction reaction) {
        int i;
        String id;
        IAtomContainer ac1;
        Reaction r = new Reaction();
        String rid = reaction.getID() == null ? Long.toHexString(System.currentTimeMillis()).toUpperCase() : reaction.getID();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            ac1 = ac.getBuilder().newInstance(IAtomContainer.class, ac);
            id = ac.getID() == null ? Long.toHexString(System.currentTimeMillis()).toUpperCase() : ac.getID();
            Double reactantCoefficient = reaction.getReactantCoefficient(ac);
            try {
                try {
                    ac1 = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(ac1);
                }
                catch (Exception ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
                MoleculeInitializer.initializeMolecule(ac1);
            }
            catch (CDKException ex) {
                LOGGER.debug("ERROR: while configuring the reaction");
            }
            ac1.setID(id);
            i = 0;
            while ((double)i < reactantCoefficient) {
                r.addReactant(ac1, 1.0);
                ++i;
            }
        }
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            ac1 = ac.getBuilder().newInstance(IAtomContainer.class, ac);
            id = ac.getID() == null ? Long.toHexString(System.currentTimeMillis()).toUpperCase() : ac.getID();
            Double productCoefficient = reaction.getProductCoefficient(ac);
            try {
                try {
                    ac1 = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(ac1);
                }
                catch (Exception ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
                MoleculeInitializer.initializeMolecule(ac1);
            }
            catch (CDKException ex) {
                LOGGER.debug("ERROR: while configuring the reaction");
            }
            ac1.setID(id);
            i = 0;
            while ((double)i < productCoefficient) {
                r.addProduct(ac1, 1.0);
                ++i;
            }
        }
        r.setID(rid);
        return r;
    }

    public ReactionFingerprinter(IReaction reaction) throws CDKException {
        IReaction r = ReactionFingerprinter.expandReactionAndRemoveHydrogens(reaction);
        IPatternFingerprinter fpr = null;
        try {
            fpr = ReactionFingerprinter.getSumOfFingerprints(r.getReactants());
        }
        catch (Exception ex) {
            LOGGER.debug("ERROR: while get SumOfFingerprints for Reactants");
        }
        IPatternFingerprinter fpp = null;
        try {
            fpp = ReactionFingerprinter.getSumOfFingerprints(r.getProducts());
        }
        catch (Exception ex) {
            LOGGER.debug("ERROR: while get SumOfFingerprints for Products");
        }
        this.reactionFingerprint = ReactionFingerprinter.summationPatterns(fpr, fpp);
        this.reactionFingerprint.setFingerprintID(r.getID());
    }

    public synchronized IPatternFingerprinter getReactionStruturalFingerprint() {
        return this.reactionFingerprint;
    }
}

