/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.fingerprints.tools;

import java.util.BitSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class Similarity {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Similarity.class);

    public static synchronized float getTanimotoSimilarity(BitSet Molecule1, BitSet Molecule2) throws Exception {
        BitSet bitset1 = (BitSet)Molecule1.clone();
        BitSet bitset2 = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = bitset1.cardinality();
        float _bitset2_cardinality = bitset2.cardinality();
        if (bitset1.size() != bitset2.size()) {
            throw new Exception("BitSets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)bitset1.clone();
        one_and_two.and(bitset2);
        float _common_bit_count = one_and_two.cardinality();
        return _common_bit_count / (_bitset1_cardinality + _bitset2_cardinality - _common_bit_count);
    }

    public static synchronized double getCosineSimilarity(BitSet Molecule1, BitSet Molecule2) throws Exception {
        BitSet bitset1 = (BitSet)Molecule1.clone();
        BitSet bitset2 = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = bitset1.cardinality();
        float _bitset2_cardinality = bitset2.cardinality();
        if (bitset1.size() != bitset2.size()) {
            throw new Exception("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)bitset1.clone();
        one_and_two.and(bitset2);
        float _common_bit_count = one_and_two.cardinality();
        return (double)_common_bit_count / Math.sqrt(_bitset1_cardinality * _bitset2_cardinality);
    }

    public static synchronized double getDiceSimilarity(BitSet Molecule1, BitSet Molecule2) throws Exception {
        BitSet bitset1 = (BitSet)Molecule1.clone();
        BitSet bitset2 = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = bitset1.cardinality();
        float _bitset2_cardinality = bitset2.cardinality();
        if (bitset1.size() != bitset2.size()) {
            throw new Exception("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)bitset1.clone();
        one_and_two.and(bitset2);
        float _common_bit_count = one_and_two.cardinality();
        return 2.0f * _common_bit_count / (_bitset1_cardinality + _bitset2_cardinality);
    }

    private Similarity() {
    }
}

