/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.ebi.reactionblast.graphics.direct.AbstractDirectDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Params;

public class AbstractHighlightDrawer
extends AbstractDirectDrawer {
    private static final Logger LOG = Logger.getLogger(AbstractHighlightDrawer.class.getName());
    protected Color opaqueHighlightColor;
    protected Color translucentHighlightColor;
    private final Map<Color, Color> opaqueToTranslucentColorMap;

    public AbstractHighlightDrawer(Params params) {
        this.setParams(params);
        this.opaqueToTranslucentColorMap = new HashMap<Color, Color>();
        this.opaqueHighlightColor = params.highlightColor;
        this.translucentHighlightColor = this.getTranslucentColor(this.opaqueHighlightColor);
    }

    public void registerColor(Color color) {
        if (!this.opaqueToTranslucentColorMap.containsKey(color)) {
            this.opaqueToTranslucentColorMap.put(color, this.makeTranslucentColor(color));
        }
    }

    protected final Color getTranslucentColor(Color color) {
        if (this.opaqueToTranslucentColorMap.containsKey(color)) {
            return this.opaqueToTranslucentColorMap.get(color);
        }
        Color translucentColor = this.makeTranslucentColor(color);
        this.opaqueToTranslucentColorMap.put(color, translucentColor);
        return translucentColor;
    }

    private Color makeTranslucentColor(Color color) {
        float[] c = color.getColorComponents(null);
        return new Color(c[0], c[1], c[2], this.params.highlightAlpha);
    }
}

