/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.reactionblast.graphics.direct.RootSystem;
import uk.ac.ebi.reactionblast.mapping.helper.RBlastReaction;
import uk.ac.ebi.reactionblast.signature.SignatureMatcher;

public class SignatureRootFinder {
    private static final Logger LOG = Logger.getLogger(SignatureRootFinder.class.getName());

    public static Map<IAtomContainer, List<RootSystem>> findRootSystems(RBlastReaction rblReaction) {
        ArrayList<IBond> allBondChanges = new ArrayList<IBond>();
        allBondChanges.addAll(rblReaction.getBondsCleavedInReactant());
        allBondChanges.addAll(rblReaction.getBondsFormedInProduct());
        allBondChanges.addAll(rblReaction.getBondsOrderChangedInReactant());
        allBondChanges.addAll(rblReaction.getBondsOrderChangedInProduct());
        ArrayList<IAtom> atomChanges = new ArrayList<IAtom>();
        atomChanges.addAll(rblReaction.getAtomStereoProductMap().keySet());
        atomChanges.addAll(rblReaction.getAtomStereoReactantMap().keySet());
        return SignatureRootFinder.findRootSystems(rblReaction.getReaction(), allBondChanges, atomChanges);
    }

    public static Map<IAtomContainer, List<RootSystem>> findRootSystems(IReaction reaction, List<IBond> bondChanges, List<IAtom> atomChanges) {
        HashMap<IAtomContainer, List<RootSystem>> rootSystems = new HashMap<IAtomContainer, List<RootSystem>>();
        ReactionManipulator.getAllAtomContainers(reaction).forEach(atomContainer -> {
            ArrayList<IBond> bonds = new ArrayList<IBond>();
            bondChanges.stream().filter(bond -> atomContainer.contains((IBond)bond)).forEachOrdered(bond -> bonds.add((IBond)bond));
            ArrayList<IAtom> atoms = new ArrayList<IAtom>();
            atomChanges.stream().filter(atom -> atomContainer.contains((IAtom)atom)).forEachOrdered(atom -> atoms.add((IAtom)atom));
            rootSystems.put((IAtomContainer)atomContainer, SignatureRootFinder.findRootSystems(atomContainer, bonds, atoms));
        });
        return rootSystems;
    }

    public static List<RootSystem> findRootSystems(IAtomContainer atomContainer, List<IBond> bondChanges, List<IAtom> atomChanges) {
        int bSize = bondChanges.size();
        int[] bondSystemLabels = new int[bSize];
        int maxSystemLabel = 1;
        Stack<RootSystem> rootSystems = new Stack<RootSystem>();
        for (int bondIndex = 0; bondIndex < bondChanges.size(); ++bondIndex) {
            IBond bond = bondChanges.get(bondIndex);
            if (bondSystemLabels[bondIndex] != 0) continue;
            int currentSystemLabel = maxSystemLabel;
            for (int rLabel = 1; rLabel <= rootSystems.size(); ++rLabel) {
                RootSystem rootSystem = (RootSystem)rootSystems.get(rLabel - 1);
                if (!SignatureRootFinder.adjacent(bond, rootSystem, atomContainer)) continue;
                currentSystemLabel = rLabel;
                rootSystem.addRootsFromBond(bond);
                break;
            }
            bondSystemLabels[bondIndex] = currentSystemLabel;
            if (currentSystemLabel != maxSystemLabel) continue;
            RootSystem system = new RootSystem();
            system.addRootsFromBond(bond);
            rootSystems.add(system);
            ++maxSystemLabel;
        }
        int aSize = atomChanges.size();
        int[] atomSystemLabels = new int[aSize];
        for (int atomIndex = 0; atomIndex < atomChanges.size(); ++atomIndex) {
            IAtom atom = atomChanges.get(atomIndex);
            if (atomSystemLabels[atomIndex] != 0) continue;
            int currentSystemLabel = maxSystemLabel;
            for (int rLabel = 1; rLabel <= rootSystems.size(); ++rLabel) {
                RootSystem rootSystem = (RootSystem)rootSystems.get(rLabel - 1);
                if (!SignatureRootFinder.adjacent(atom, rootSystem, atomContainer)) continue;
                currentSystemLabel = rLabel;
                rootSystem.addRoot(atom);
                break;
            }
            atomSystemLabels[atomIndex] = currentSystemLabel;
            if (currentSystemLabel != maxSystemLabel) continue;
            RootSystem system = new RootSystem();
            system.addRoot(atom);
            rootSystems.add(system);
            ++maxSystemLabel;
        }
        boolean merging = true;
        while (merging) {
            Stack<RootSystem> mergedRootSystems = new Stack<RootSystem>();
            if (rootSystems.isEmpty()) {
                merging = false;
                break;
            }
            RootSystem rootSystem = rootSystems.pop();
            boolean hasMerged = false;
            for (RootSystem otherRootSystem : rootSystems) {
                if (SignatureRootFinder.adjacent(rootSystem, otherRootSystem, atomContainer)) {
                    mergedRootSystems.add(rootSystem.merge(otherRootSystem));
                    hasMerged = true;
                    continue;
                }
                mergedRootSystems.add(otherRootSystem);
            }
            if (hasMerged) {
                merging = true;
            } else {
                mergedRootSystems.add(rootSystem);
                merging = false;
            }
            rootSystems = mergedRootSystems;
        }
        for (RootSystem rs : rootSystems) {
            List<IAtom> roots = rs.getRoots();
            roots.forEach(root -> atomContainer.getConnectedAtomsList((IAtom)root).stream().filter(leaf -> !roots.contains(leaf)).forEachOrdered(leaf -> rs.addLeaf((IAtom)leaf)));
        }
        return rootSystems;
    }

    private static boolean adjacent(RootSystem rsI, RootSystem rsJ, IAtomContainer atomContainer) {
        for (int idxI = 0; idxI < rsI.getRoots().size(); ++idxI) {
            IAtom atomI = rsI.getRoots().get(idxI);
            for (int idxJ = 0; idxJ < rsJ.getRoots().size(); ++idxJ) {
                IAtom atomJ = rsJ.getRoots().get(idxJ);
                for (IBond bond : atomContainer.bonds()) {
                    if (!bond.contains(atomI) || !bond.contains(atomJ)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean adjacent(IBond bond, RootSystem rootSystem, IAtomContainer atomContainer) {
        return rootSystem.getRoots().stream().anyMatch(root -> atomContainer.getConnectedBondsList((IAtom)root).stream().anyMatch(connectedBond -> bond == connectedBond));
    }

    private static boolean adjacent(IAtom atom, RootSystem rootSystem, IAtomContainer atomContainer) {
        return false;
    }

    public static List<RootSystem> findRootSystems(IReaction reaction, List<String> signatureStrings) {
        ArrayList<RootSystem> rootSystems = new ArrayList<RootSystem>();
        SignatureMatcher matcher = new SignatureMatcher();
        ReactionManipulator.getAllAtomContainers(reaction).forEach(atomContainer -> {
            List<IAtom> roots = matcher.getMatchingRootAtoms(signatureStrings, (IAtomContainer)atomContainer);
            rootSystems.addAll(SignatureRootFinder.find(atomContainer, roots));
        });
        return rootSystems;
    }

    private static List<RootSystem> find(IAtomContainer atomContainer, List<IAtom> roots) {
        ArrayList<RootSystem> rootSystems = new ArrayList<RootSystem>();
        int currentLabel = 1;
        int[] labels = new int[atomContainer.getAtomCount()];
        for (IAtom root : roots) {
            ArrayList<IAtom> component = new ArrayList<IAtom>();
            SignatureRootFinder.dfs(null, root, currentLabel, labels, atomContainer, roots, component);
            if (component.size() <= 0) continue;
            RootSystem rootSystem = new RootSystem();
            component.stream().map(rootAtom -> {
                rootSystem.addRoot((IAtom)rootAtom);
                return rootAtom;
            }).forEachOrdered(rootAtom -> atomContainer.getConnectedAtomsList((IAtom)rootAtom).stream().filter(possibleLeaf -> !component.contains(possibleLeaf)).forEachOrdered(possibleLeaf -> rootSystem.addLeaf((IAtom)possibleLeaf)));
            rootSystems.add(rootSystem);
            ++currentLabel;
        }
        return rootSystems;
    }

    private static void dfs(IAtom atomV, IAtom atomU, int cLabel, int[] labels, IAtomContainer atomContainer, List<IAtom> roots, List<IAtom> component) {
        int uIndex = atomContainer.indexOf(atomU);
        if (atomV == null || roots.contains(atomU) && labels[uIndex] == 0) {
            labels[uIndex] = cLabel;
            component.add(atomU);
            atomContainer.getConnectedAtomsList(atomU).stream().filter(atomW -> atomW != atomV).forEachOrdered(atomW -> SignatureRootFinder.dfs(atomU, atomW, cLabel, labels, atomContainer, roots, component));
        }
    }

    private SignatureRootFinder() {
    }
}

