/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import uk.ac.ebi.reactionblast.graphics.direct.AbstractHighlightDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Highlighter;
import uk.ac.ebi.reactionblast.graphics.direct.Params;

public class SimpleHighlighter
extends AbstractHighlightDrawer
implements Highlighter {
    private static final Logger LOG = Logger.getLogger(SimpleHighlighter.class.getName());
    private Map<IAtom, Color> atomColorMap = new HashMap<IAtom, Color>();
    private final Map<IBond, Color> bondColorMap = new HashMap<IBond, Color>();

    public SimpleHighlighter(Params params) {
        super(params);
    }

    @Override
    public void drawHighlights(IAtomContainer molecule, Graphics2D g) {
        this.atomColorMap.keySet().stream().filter(atom -> molecule.contains((IAtom)atom)).forEachOrdered(atom -> {
            Color color = this.atomColorMap.get(atom);
            this.drawHighlight((IAtom)atom, color, g);
        });
        this.bondColorMap.keySet().stream().filter(bond -> molecule.contains((IBond)bond)).forEachOrdered(bond -> {
            Color color = this.bondColorMap.get(bond);
            this.drawHighlight((IBond)bond, color, g);
        });
    }

    @Override
    public void addHighlights(IAtomContainer highlightContainer, Color color) {
        this.registerColor(color);
        for (IAtom atom : highlightContainer.atoms()) {
            this.atomColorMap.put(atom, color);
        }
        for (IBond bond : highlightContainer.bonds()) {
            this.bondColorMap.put(bond, color);
        }
    }

    @Override
    public void addHighlights(List<IAtom> atoms, List<IBond> bonds) {
        atoms.forEach(atom -> this.atomColorMap.put((IAtom)atom, this.params.highlightColor));
        bonds.forEach(bond -> this.bondColorMap.put((IBond)bond, this.params.highlightColor));
    }

    @Override
    public void addToHighlights(Map<IAtom, Color> atomColorMap) {
        this.atomColorMap.putAll(atomColorMap);
    }

    public void setHighlights(Map<IAtom, Color> atomColorMap) {
        this.atomColorMap = atomColorMap;
    }

    public void drawHighlight(IAtom atom, Graphics2D g) {
        if (this.params.highlightsAbove) {
            this.drawHighlight(atom, this.translucentHighlightColor, g);
        } else {
            this.drawHighlight(atom, this.opaqueHighlightColor, g);
        }
    }

    public void drawHighlight(IAtom atom, Color color, Graphics2D g) {
        Color actualColor = this.params.highlightsAbove ? this.getTranslucentColor(color) : color;
        g.setColor(actualColor);
        double r = this.params.highlightRadius;
        double d = r * 2.0;
        Point2d p = atom.getPoint2d();
        g.fill(new Ellipse2D.Double(p.x - r, p.y - r, d, d));
    }

    public void drawHighlight(IBond bond, Color color, Graphics2D g) {
        Stroke stroke = g.getStroke();
        g.setStroke(new BasicStroke(this.params.highlightBondStroke));
        Point2d p0 = bond.getAtom(0).getPoint2d();
        Point2d p1 = bond.getAtom(1).getPoint2d();
        this.drawLine(p0, p1, g);
        g.setStroke(stroke);
    }

    public void drawHighlightContainer(IAtomContainer highlightContainer, Graphics2D g) {
        if (this.params.highlightsAbove) {
            this.drawHighlightContainer(highlightContainer, this.translucentHighlightColor, g);
        } else {
            this.drawHighlightContainer(highlightContainer, this.opaqueHighlightColor, g);
        }
    }

    public void drawHighlightContainer(IAtomContainer highlightContainer, Color color, Graphics2D g) {
        Color actualColor = this.params.highlightsAbove ? this.getTranslucentColor(color) : color;
        g.setColor(actualColor);
        double r = this.params.highlightRadius;
        double d = r * 2.0;
        for (IAtom atom : highlightContainer.atoms()) {
            Point2d p = atom.getPoint2d();
            g.fill(new Ellipse2D.Double(p.x - r, p.y - r, d, d));
        }
        Stroke stroke = g.getStroke();
        g.setStroke(new BasicStroke(this.params.highlightBondStroke));
        for (IBond bond : highlightContainer.bonds()) {
            Point2d p0 = bond.getAtom(0).getPoint2d();
            Point2d p1 = bond.getAtom(1).getPoint2d();
            this.drawLine(p0, p1, g);
        }
        g.setStroke(stroke);
    }

    @Override
    public void clearHighlights() {
        this.atomColorMap.clear();
        this.bondColorMap.clear();
    }
}

