/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.GeometryTools;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.layout.CanvasGenerator;
import uk.ac.ebi.reactionblast.graphics.direct.layout.GridCanvasGenerator;

public class ZoomToFitDrawer {
    private static final Logger LOG = Logger.getLogger(ZoomToFitDrawer.class.getName());
    private DirectMoleculeDrawer moleculeDrawer;
    private CanvasGenerator canvasGenerator;
    private Params params;

    public ZoomToFitDrawer() {
        this(new DirectMoleculeDrawer(), new GridCanvasGenerator());
    }

    public ZoomToFitDrawer(DirectMoleculeDrawer moleculeDrawer, CanvasGenerator canvasGenerator) {
        this.moleculeDrawer = moleculeDrawer;
        this.params = moleculeDrawer.getParams();
        this.canvasGenerator = canvasGenerator;
    }

    public void draw(List<IAtomContainer> mols, Dimension cellCanvas, Graphics2D g) {
        this.canvasGenerator.layout(mols, cellCanvas);
        AffineTransform originalTransform = g.getTransform();
        mols.stream().map(mol -> {
            Rectangle2D canvas = this.canvasGenerator.getCanvasForAtomContainer((IAtomContainer)mol);
            g.translate(canvas.getCenterX(), canvas.getCenterY());
            double zoom = this.calculateZoom((IAtomContainer)mol, canvas);
            g.scale(zoom, zoom);
            this.moleculeDrawer.drawMolecule((IAtomContainer)mol, g);
            return mol;
        }).forEachOrdered(_item -> g.setTransform(originalTransform));
    }

    private double calculateZoom(IAtomContainer ac, Rectangle2D canvas) {
        double scaleFactor = GeometryTools.getScaleFactor(ac, this.params.bondLength);
        GeometryTools.translate2DCenterTo(ac, new Point2d(0.0, 0.0));
        GeometryTools.scaleMolecule(ac, scaleFactor);
        Rectangle2D r2D = GeometryTools.getRectangle2D(ac);
        double canvasWidth = canvas.getWidth();
        double canvasHeight = canvas.getHeight();
        double objectWidth = r2D.getWidth() + (double)(this.params.borderX * 2);
        double objectHeight = r2D.getHeight() + (double)(this.params.borderY * 2);
        return Math.min(canvasWidth / objectWidth, canvasHeight / objectHeight);
    }
}

