/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.awtlayout;

import java.awt.geom.Rectangle2D;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.graphics.direct.Axis;
import uk.ac.ebi.reactionblast.graphics.direct.GeometryTools;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AbstractAWTLayout;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.LinearAtomContainerSetLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public abstract class AbstractAWTReactionLayout
extends AbstractAWTLayout<IReaction> {
    protected BoundsTree reactantBoundsTree;
    protected BoundsTree productBoundsTree;
    protected Vector2d axis;
    protected Axis arrowAxis;
    protected double arrowPos;
    protected LinearAtomContainerSetLayout reactantLayout;
    protected LinearAtomContainerSetLayout productLayout;

    public void shiftMoleculeSet(IAtomContainerSet molSet, BoundsTree molSetBoundsTree, double dx, double dy) {
        int counter = 0;
        for (IAtomContainer molecule : molSet.atomContainers()) {
            String molLabel = molSet.getID() + "_" + molecule.getID() + ":" + counter;
            Rectangle2D bounds = molSetBoundsTree.get(molLabel);
            bounds.setFrame(bounds.getMinX() + dx, bounds.getMinY() + dy, bounds.getWidth(), bounds.getHeight());
            GeometryTools.translate2D(molecule, dx, dy);
            ++counter;
        }
    }

    public Axis getArrowAxis() {
        return this.arrowAxis;
    }

    public void setArrowPos(double pos) {
        this.arrowPos = pos;
    }

    public Point2d getArrowCenter() {
        Rectangle2D bounds = this.getBoundsTree().getRoot();
        if (this.arrowAxis == Axis.X) {
            return new Point2d(this.arrowPos, bounds.getCenterY());
        }
        return new Point2d(bounds.getCenterX(), this.arrowPos);
    }

    public abstract Vector2d getAxis();
}

