/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.awtlayout;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AbstractAWTLayout;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.MoleculeLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class LinearAtomContainerSetLayout
extends AbstractAWTLayout<IAtomContainerSet> {
    private static final Logger LOG = Logger.getLogger(LinearAtomContainerSetLayout.class.getName());
    private Vector2d moleculeSetAxis;
    private MoleculeLayout moleculeLayout;

    public LinearAtomContainerSetLayout(Vector2d moleculeSetAxis) {
        this(moleculeSetAxis, new Params());
    }

    public LinearAtomContainerSetLayout(Vector2d moleculeSetAxis, Params params) {
        this.params = params;
        this.moleculeLayout = new MoleculeLayout(params);
        this.moleculeSetAxis = moleculeSetAxis;
    }

    @Override
    public BoundsTree layout(IAtomContainerSet atomContainerSet, Graphics2D graphics) {
        double molGap = 2 * this.params.plusGap;
        Font plusFont = new Font("ROMAN", 0, this.params.plusFontSize);
        graphics.setFont(plusFont);
        if (atomContainerSet.getAtomContainerCount() > 1) {
            Rectangle2D plusBounds = super.getTextBounds(graphics, "+");
            molGap += plusBounds.getWidth();
        }
        String atomContainerSetID = atomContainerSet.getID();
        this.boundsTree = new BoundsTree(atomContainerSetID);
        Point2d curr = new Point2d(0.0, 0.0);
        int moleculeCounter = 0;
        for (IAtomContainer molecule : atomContainerSet.atomContainers()) {
            Object label = molecule.getID();
            label = label == null || ((String)label).isEmpty() ? "mol" + String.valueOf(moleculeCounter) : (String)label + ":" + String.valueOf(moleculeCounter);
            BoundsTree molBounds = this.moleculeLayout.layout(molecule, (String)label, graphics);
            double boundsWidth = molBounds.getWidth();
            double halfBoundsWidth = boundsWidth / 2.0;
            curr.scaleAdd(halfBoundsWidth, this.moleculeSetAxis, curr);
            this.translateTo(molecule, curr.x, curr.y, molBounds);
            curr.scaleAdd(halfBoundsWidth, this.moleculeSetAxis, curr);
            curr.scaleAdd(molGap, this.moleculeSetAxis, curr);
            this.boundsTree.add(atomContainerSetID, molBounds);
            ++moleculeCounter;
        }
        return this.boundsTree;
    }

    @Override
    public BoundsTree layout(IAtomContainerSet obj, String rootLabel, Graphics2D graphics) {
        return null;
    }
}

