/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.graphics.direct.DirectArrowDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.layout.CanvasGenerator;

public class ArrowWheel {
    private static final Logger LOG = Logger.getLogger(ArrowWheel.class.getName());
    private DirectArrowDrawer arrowDrawer;
    private List<Arrow> arrows;
    private IAtomContainer hub;
    private List<String> arrowLabels;

    public ArrowWheel(DirectArrowDrawer arrowDrawer, IAtomContainer hubMolecule, List<IAtomContainer> rimMolecules) {
        this(arrowDrawer, hubMolecule, rimMolecules, new ArrayList<String>());
    }

    public ArrowWheel(DirectArrowDrawer arrowDrawer, IAtomContainer hubMolecule, List<IAtomContainer> rimMolecules, List<String> arrowLabels) {
        this.arrowDrawer = arrowDrawer;
        this.arrows = new ArrayList<Arrow>();
        this.hub = hubMolecule;
        rimMolecules.forEach(molecule -> this.arrows.add(new Arrow(this.hub, (IAtomContainer)molecule)));
        this.arrowLabels = arrowLabels;
    }

    public void draw(CanvasGenerator canvasGenerator, Graphics2D g) {
        this.arrows.stream().map(arrow -> {
            Rectangle2D tailCanvas = canvasGenerator.getCanvasForAtomContainer(arrow.tail);
            Rectangle2D headCanvas = canvasGenerator.getCanvasForAtomContainer(arrow.head);
            Point2d tailCenter = new Point2d(tailCanvas.getCenterX(), tailCanvas.getCenterY());
            Point2d headCenter = new Point2d(headCanvas.getCenterX(), headCanvas.getCenterY());
            arrow.center = new Point2d(tailCenter);
            arrow.center.interpolate(headCenter, 0.5);
            arrow.vector = new Vector2d(headCenter);
            arrow.vector.sub(tailCenter);
            return arrow;
        }).forEachOrdered(arrow -> arrow.vector.normalize());
        int i = 0;
        for (Arrow arrow2 : this.arrows) {
            this.arrowDrawer.drawThinArrow(g, arrow2.center, arrow2.vector, this.arrowLabels.get(i));
            ++i;
        }
    }

    private class Arrow {
        public IAtomContainer tail;
        public IAtomContainer head;
        public Point2d center;
        public Vector2d vector;

        Arrow(IAtomContainer tail, IAtomContainer head) {
            this.tail = tail;
            this.head = head;
        }
    }
}

