/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import uk.ac.ebi.reactionblast.graphics.direct.GeometryTools;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class LinearMoleculeSetLayout
extends AbstractDirectLayout<IAtomContainerSet> {
    private static final Logger LOG = Logger.getLogger(LinearMoleculeSetLayout.class.getName());
    private Vector2d moleculeAxis;

    public LinearMoleculeSetLayout(Params params) {
        this(params, true);
    }

    public LinearMoleculeSetLayout(Params params, boolean shouldInvert) {
        this(params, shouldInvert, new Vector2d(1.0, 0.0));
    }

    public LinearMoleculeSetLayout(Params params, boolean shouldInvert, Vector2d moleculeAxis) {
        super(shouldInvert);
        this.moleculeAxis = moleculeAxis;
        this.setParams(params);
    }

    @Override
    public BoundsTree layout(IAtomContainerSet atomContainerSet, Vector2d moleculeSetAxis) {
        int bondLength = this.params.bondLength;
        int molGap = 2 * this.params.plusGap;
        int molLabel = 0;
        String rootLabel = atomContainerSet.getID();
        this.boundsTree = new BoundsTree(rootLabel);
        Point2d curr = new Point2d(0.0, 0.0);
        int i = 0;
        for (IAtomContainer molecule : atomContainerSet.atomContainers()) {
            if (!GeometryTools.has2DCoordinates(molecule)) {
                StructureDiagramGenerator sdg = new StructureDiagramGenerator(new AtomContainer(molecule));
                try {
                    sdg.generateCoordinates();
                }
                catch (CDKException ex) {
                    Logger.getLogger(LinearMoleculeSetLayout.class.getName()).log(Level.SEVERE, null, ex);
                }
                molecule = sdg.getMolecule();
            }
            this.invert(molecule);
            if (this.params.alignMolecules && this.moleculeAxis != null) {
                this.align(molecule, this.moleculeAxis);
            }
            GeometryTools.scaleMolecule(molecule, GeometryTools.getScaleFactor(molecule, bondLength));
            Rectangle2D bounds = GeometryTools.getRectangle2D(molecule);
            double boundsWidth = bounds.getWidth();
            double halfBoundsWidth = boundsWidth / 2.0;
            curr.scaleAdd(halfBoundsWidth, moleculeSetAxis, curr);
            this.translateTo(molecule, curr.x, curr.y, bounds);
            curr.scaleAdd(halfBoundsWidth, moleculeSetAxis, curr);
            curr.scaleAdd(molGap, moleculeSetAxis, curr);
            Object moleculeLabel = molecule.getID();
            if (moleculeLabel == null || ((String)moleculeLabel).isEmpty()) {
                moleculeLabel = "mol" + String.valueOf(molLabel);
                ++molLabel;
            } else {
                moleculeLabel = (String)moleculeLabel + ":" + i;
            }
            this.boundsTree.add(rootLabel + "_" + (String)moleculeLabel, bounds);
            ++i;
            this.shouldInvert = true;
        }
        return this.boundsTree;
    }

    @Override
    public Vector2d getAxis() {
        return new Vector2d(1.0, 0.0);
    }

    @Override
    public double getAxisPosition() {
        return this.boundsTree.getWidth() / 2.0 + (double)this.params.borderX;
    }
}

