/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import uk.ac.ebi.reactionblast.graphics.direct.GeometryTools;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class SingleMoleculeLayout
extends AbstractDirectLayout<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(SingleMoleculeLayout.class.getName());
    private StructureDiagramGenerator sdg;
    private boolean forceRelayout;

    public SingleMoleculeLayout(Params params) {
        this(params, false);
    }

    public SingleMoleculeLayout(Params params, boolean forceRelayout) {
        this.setParams(params);
        this.sdg = new StructureDiagramGenerator();
        this.forceRelayout = forceRelayout;
    }

    @Override
    public BoundsTree layout(IAtomContainer atomContainer, Vector2d axis) {
        Point2d center = new Point2d(axis);
        if (this.forceRelayout || !GeometryTools.has2DCoordinates(atomContainer)) {
            this.sdg.setMolecule(new AtomContainer(atomContainer), false);
            try {
                if (ConnectivityChecker.isConnected(atomContainer)) {
                    this.sdg.generateCoordinates();
                } else {
                    System.err.println("Disconnected components needs to be layout separately");
                }
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        }
        double scale = GeometryTools.getScaleFactor(atomContainer, this.params.bondLength);
        Rectangle2D bounds = GeometryTools.getRectangle2D(atomContainer);
        GeometryTools.scaleMolecule(atomContainer, scale);
        this.translateTo(atomContainer, center.x, center.y, bounds);
        String label = atomContainer.getID();
        return new BoundsTree(label, label, bounds);
    }

    @Override
    public Vector2d getAxis() {
        return null;
    }

    @Override
    public double getAxisPosition() {
        return 0.0;
    }
}

