/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.GeometryTools;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class ZoomToFitLayout
extends AbstractDirectLayout<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(ZoomToFitLayout.class.getName());
    private final DirectMoleculeDrawer drawer;

    public ZoomToFitLayout(DirectMoleculeDrawer drawer) {
        this.drawer = drawer;
    }

    public void layout(IAtomContainer mol, Dimension cellCanvas, Graphics2D g) {
        AffineTransform originalTransform = g.getTransform();
        double w = cellCanvas.width;
        double h = cellCanvas.height;
        double zoom = this.calculateZoom(mol, cellCanvas.width, cellCanvas.height);
        double centerX = w / 2.0;
        Params params = this.drawer.getParams();
        double centerY = params.drawMoleculeID ? h / 2.0 - params.labelYGap : h / 2.0;
        g.translate(centerX, centerY);
        g.scale(zoom, zoom);
        this.drawer.drawMolecule(mol, g);
        g.setTransform(originalTransform);
    }

    private double calculateZoom(IAtomContainer ac, double w, double h) {
        double borderX = this.drawer.getParams().borderX;
        double borderY = this.drawer.getParams().borderY;
        double canvasWidth = w;
        double canvasHeight = h;
        double scaleFactor = GeometryTools.getScaleFactor(ac, this.drawer.getParams().bondLength);
        Rectangle2D r2D = GeometryTools.getRectangle2D(ac);
        this.translateTo(ac, 0.0, 0.0, r2D);
        GeometryTools.scaleMolecule(ac, scaleFactor);
        double objectWidth = r2D.getWidth() + borderX * 2.0;
        double objectHeight = r2D.getHeight() + borderY * 2.0;
        return Math.min(canvasWidth / objectWidth, canvasHeight / objectHeight);
    }

    @Override
    public BoundsTree layout(IAtomContainer obj, Vector2d axis) {
        return null;
    }

    @Override
    public Vector2d getAxis() {
        return null;
    }

    @Override
    public double getAxisPosition() {
        return 0.0;
    }
}

