/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.io.filesystem;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.interfaces.IDataStore;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Writer;

public class FilesystemMoleculeDataStore
implements IDataStore<IAtomContainer> {
    private File moleculeDir;
    private MDLV2000Writer molWriter;

    public FilesystemMoleculeDataStore(String moleculePath) {
        if (moleculePath != null) {
            this.moleculeDir = new File(moleculePath);
            this.molWriter = new MDLV2000Writer();
        }
    }

    @Override
    public void store(IAtomContainer molecule) {
        String id = molecule.getID();
        File file = new File(this.moleculeDir, id + ".mol");
        try {
            FileWriter writer = new FileWriter(file);
            this.molWriter = new MDLV2000Writer(writer);
            this.molWriter.write(molecule);
            this.molWriter.close();
        }
        catch (IOException | CDKException e) {
            e.printStackTrace();
        }
    }
}

