/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.io.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.interfaces.IDataSource;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLRXNV2000Reader;

public class FilesystemReactionDataSource
implements IDataSource<IReaction> {
    private File reactionDir;
    private MDLRXNV2000Reader rxnReader;
    private ITransformation<IReaction> transformation;

    public FilesystemReactionDataSource(String reactionPath) {
        if (reactionPath != null) {
            this.reactionDir = new File(reactionPath);
            this.rxnReader = new MDLRXNV2000Reader();
        }
    }

    @Override
    public void setTransformation(ITransformation<IReaction> transformation) {
        this.transformation = transformation;
    }

    @Override
    public IReaction get(String id) {
        File reactionFile = new File(this.reactionDir, id + ".rxn");
        try {
            this.rxnReader.setReader(new FileReader(reactionFile));
            IReaction reaction = this.rxnReader.read(new Reaction());
            if (this.transformation == null) {
                return reaction;
            }
            return this.transformation.transform(reaction);
        }
        catch (FileNotFoundException | CDKException c) {
            c.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterable<IReaction> getAll() {
        final String[] fileNames = this.reactionDir.list();
        final int numberOfReactions = fileNames.length;
        return new Iterable<IReaction>(){

            @Override
            public Iterator<IReaction> iterator() {
                return new Iterator<IReaction>(){
                    private int currentIndex;

                    @Override
                    public boolean hasNext() {
                        return this.currentIndex < numberOfReactions;
                    }

                    @Override
                    public IReaction next() {
                        String filename = fileNames[this.currentIndex];
                        File rxnFile = new File(FilesystemReactionDataSource.this.reactionDir, filename);
                        ++this.currentIndex;
                        try {
                            IReaction reaction;
                            try (FileReader reader = new FileReader(rxnFile);){
                                FilesystemReactionDataSource.this.rxnReader.setReader(reader);
                                reaction = FilesystemReactionDataSource.this.rxnReader.read(new Reaction());
                                reaction.setID(filename.substring(0, filename.indexOf(46)));
                            }
                            return reaction;
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            return null;
                        }
                        catch (IOException | CDKException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public List<String> getIDList() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String filename : this.reactionDir.list()) {
            ids.add(filename.substring(0, filename.indexOf(46)));
        }
        return ids;
    }

    @Override
    public void close() {
        try {
            this.rxnReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

