/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.interfaces.IStandardizer;
import uk.ac.ebi.reactionblast.mapping.MappingThread;
import uk.ac.ebi.reactionblast.mapping.Reactor;
import uk.ac.ebi.reactionblast.mapping.cache.ThreadSafeCache;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000RXNWriter;

public class CallableAtomMappingTool
implements Serializable {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final boolean DEBUG = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CallableAtomMappingTool.class);
    private static final long serialVersionUID = 188635354869707070L;
    private Map<IMappingAlgorithm, Reactor> solution = Collections.synchronizedMap(new EnumMap(IMappingAlgorithm.class));

    public static synchronized void writeMappingRXN(Reactor reactor, String outputDirectoryName, String outFileName) throws Exception {
        String reactionID = reactor.getReactionWithAtomAtomMapping().getID();
        IReaction mappedReaction = reactor.getReactionWithAtomAtomMapping();
        if (reactionID == null) {
            reactionID = String.valueOf(System.currentTimeMillis());
            reactor.getReactionWithAtomAtomMapping().setID(reactionID);
        }
        Object outputFile = outputDirectoryName;
        outputFile = (String)outputFile + File.separator + outFileName;
        try (MDLV2000RXNWriter rxnW = new MDLV2000RXNWriter(new FileWriter(new File((String)outputFile)));){
            rxnW.write(mappedReaction);
        }
    }

    public CallableAtomMappingTool(IReaction reaction, IStandardizer standardizer, boolean removeHydrogen, boolean checkComplex) throws Exception {
        this.generateAtomAtomMapping(reaction, standardizer, removeHydrogen, checkComplex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void generateAtomAtomMapping(IReaction reaction, IStandardizer standardizer, boolean removeHydrogen, boolean checkComplex) {
        ThreadSafeCache mappingcache = ThreadSafeCache.getInstance();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        int jobCounter = 0;
        try {
            ExecutorCompletionService<Reactor> cs = new ExecutorCompletionService<Reactor>(executor);
            LOGGER.info(NEW_LINE + "|++++++++++++++++++++++++++++|");
            LOGGER.info("b) Local Model: ");
            IReaction cleanedReaction1 = null;
            try {
                cleanedReaction1 = standardizer.standardize(reaction);
            }
            catch (Exception e) {
                LOGGER.debug("ERROR: in AtomMappingTool: " + e.getMessage());
                LOGGER.error(e);
            }
            MappingThread minThread = new MappingThread("IMappingAlgorithm.MIN", cleanedReaction1, IMappingAlgorithm.MIN, removeHydrogen);
            cs.submit(minThread);
            ++jobCounter;
            LOGGER.info(NEW_LINE + "|++++++++++++++++++++++++++++|");
            LOGGER.info("a) Global Model: ");
            IReaction cleanedReaction2 = null;
            try {
                cleanedReaction2 = standardizer.standardize(reaction);
            }
            catch (Exception e) {
                LOGGER.debug("ERROR: in AtomMappingTool: " + e.getMessage());
                LOGGER.error(e);
            }
            MappingThread maxThread = new MappingThread("IMappingAlgorithm.MAX", cleanedReaction2, IMappingAlgorithm.MAX, removeHydrogen);
            cs.submit(maxThread);
            ++jobCounter;
            LOGGER.info(NEW_LINE + "|++++++++++++++++++++++++++++|");
            LOGGER.info("c) Mixture Model: ");
            IReaction cleanedReaction3 = null;
            try {
                cleanedReaction3 = standardizer.standardize(reaction);
            }
            catch (Exception e) {
                LOGGER.debug("ERROR: in AtomMappingTool: " + e.getMessage());
                LOGGER.error(e);
            }
            MappingThread maxMixtureThread = new MappingThread("IMappingAlgorithm.MIXTURE", cleanedReaction3, IMappingAlgorithm.MIXTURE, removeHydrogen);
            cs.submit(maxMixtureThread);
            ++jobCounter;
            if (checkComplex) {
                LOGGER.info(NEW_LINE + "|++++++++++++++++++++++++++++|");
                LOGGER.info("d) Rings Model: ");
                IReaction cleanedReaction4 = null;
                try {
                    cleanedReaction4 = standardizer.standardize(reaction);
                }
                catch (Exception e) {
                    LOGGER.debug("ERROR: in AtomMappingTool: " + e.getMessage());
                    LOGGER.error(e);
                }
                MappingThread ringThread = new MappingThread("IMappingAlgorithm.RINGS", cleanedReaction4, IMappingAlgorithm.RINGS, removeHydrogen);
                cs.submit(ringThread);
                ++jobCounter;
            }
            for (int i = 0; i < jobCounter; ++i) {
                Reactor chosen = (Reactor)cs.take().get();
                this.putSolution(chosen.getAlgorithm(), chosen);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            System.gc();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.debug("ERROR: in AtomMappingTool: " + e.getMessage());
            LOGGER.error(e);
        }
        finally {
            executor.shutdown();
        }
        mappingcache.cleanup();
    }

    public Map<IMappingAlgorithm, Reactor> getSolutions() {
        return Collections.unmodifiableMap(this.solution);
    }

    private void putSolution(IMappingAlgorithm choice, Reactor reactor) {
        this.solution.put(choice, reactor);
    }
}

