/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.graph.ShortestPaths;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.tools.labelling.SignatureMoleculeLabeller;

public class CanonicalNumberingGenerator {
    private final IAtomContainer atomContainer;
    private final List<Integer> canonicalPermutationList;
    private final List<Integer> orbitalCanonicalLabellingList;

    private static synchronized void resetFlags(IAtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            atomContainer.getAtom(f).setFlag(16, false);
        }
        for (f = 0; f < atomContainer.getBondCount(); ++f) {
            atomContainer.getBond(f).setFlag(16, false);
        }
    }

    private static synchronized <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public CanonicalNumberingGenerator(IAtomContainer atomContainer) {
        this.atomContainer = new AtomContainer(atomContainer);
        CanonicalNumberingGenerator.resetFlags(this.atomContainer);
        SignatureMoleculeLabeller molLabel = new SignatureMoleculeLabeller();
        int[] canonicalPermutation = molLabel.getCanonicalPermutation(atomContainer);
        this.canonicalPermutationList = this.asList(canonicalPermutation);
        TreeMap subLabels = new TreeMap();
        int counter = 0;
        for (int i : this.canonicalPermutationList) {
            IAtom atom = this.atomContainer.getAtom(i);
            List labels2 = !subLabels.containsKey(atom.getSymbol()) ? new ArrayList() : (List)subLabels.get(atom.getSymbol());
            Label l2 = new Label();
            l2.atom = atom;
            l2.rank = i;
            l2.postion = counter++;
            labels2.add(l2);
            subLabels.put(atom.getSymbol(), labels2);
        }
        this.orbitalCanonicalLabellingList = new ArrayList<Integer>(this.canonicalPermutationList.size());
        subLabels.values().stream().map(labels -> {
            ArrayList l = new ArrayList();
            labels.stream().forEach(label -> l.add(label.rank));
            return l;
        }).forEach(l -> this.orbitalCanonicalLabellingList.addAll((Collection<Integer>)l));
    }

    private synchronized List<Integer> asList(int[] is) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int index = 0; index < is.length; ++index) {
            intList.add(index, is[index]);
        }
        return intList;
    }

    public synchronized int[] getCanonicalPermutation() {
        int[] val = new int[this.canonicalPermutationList.size()];
        int index = 0;
        for (Integer i : this.canonicalPermutationList) {
            val[index++] = i;
        }
        return val;
    }

    public synchronized int[] getOrbitalCanonicalLabelling() {
        int[] val = new int[this.orbitalCanonicalLabellingList.size()];
        int index = 0;
        for (Integer i : this.orbitalCanonicalLabellingList) {
            val[index++] = i;
        }
        return val;
    }

    class Label {
        int rank;
        IAtom atom;
        int postion;

        Label() {
        }

        public synchronized String toString() {
            StringBuilder result = new StringBuilder();
            String NEW_LINE = System.getProperty("line.separator");
            result.append("Atom: ").append(this.atom.getSymbol()).append(", Rank: ").append(this.rank);
            result.append(NEW_LINE);
            return result.toString();
        }
    }

    class Distance
    implements Comparator<Label> {
        Distance() {
        }

        @Override
        public synchronized int compare(Label t1, Label t2) {
            ShortestPaths sp = new ShortestPaths(CanonicalNumberingGenerator.this.atomContainer, t1.atom);
            IAtom[] atomsTo = sp.atomsTo(t2.atom);
            if (t1.atom == t2.atom) {
                return 0;
            }
            if (atomsTo.length == 0) {
                return 99999;
            }
            if (atomsTo.length == 1) {
                return 1;
            }
            return -1;
        }
    }
}

