/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping;

import java.util.concurrent.Callable;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.mapping.Reactor;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;

class MappingThread
implements Callable<Reactor> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MappingThread.class);
    private final IReaction cleanedReaction;
    private final IMappingAlgorithm algorithm;
    private final boolean removeHydrogen;

    MappingThread(String message, IReaction cleanedReaction, IMappingAlgorithm algorithm, boolean removeHydrogen) {
        this.cleanedReaction = cleanedReaction;
        this.algorithm = algorithm;
        this.removeHydrogen = removeHydrogen;
        LOGGER.info("|++++++++++++++++++++++++++++|");
        LOGGER.info("|Atom Atom Mapping Tool Initialized for " + message);
    }

    @Override
    public Reactor call() throws Exception {
        Reactor reactor = new Reactor(this.cleanedReaction, this.removeHydrogen, this.algorithm);
        LOGGER.info("|Done " + reactor.getAlgorithm() + " |");
        return reactor;
    }
}

