/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.mapping.algorithm.CalculationProcess;
import uk.ac.ebi.reactionblast.mapping.container.MoleculeMoleculeMapping;
import uk.ac.ebi.reactionblast.mapping.helper.AbstractReactor;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.tools.ExtReactionManipulatorTool;

public class Reactor
extends AbstractReactor
implements Serializable {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 197816786981017L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Reactor.class);
    private final Map<Integer, Integer> rLabelledAtoms;
    private final Map<Integer, Integer> pLabelledAtoms;
    private final Map<Integer, Integer> inputRankLabelledAtomsReactant;
    private final Map<Integer, Integer> inputRankLabelledAtomsProduct;
    private final Map<Integer, IAtomContainer> educts;
    private final Map<Integer, IAtomContainer> products;
    private final List<IBond> rBonds;
    private final List<IBond> pBonds;
    private final IReaction reactionWithSTOICHIOMETRY;
    private final boolean partialMapping;
    private final IMappingAlgorithm algorithm;
    private MoleculeMoleculeMapping reactionBlastMolMapping;
    private Integer substrateAtomCounter;
    private Integer productAtomCounter;
    private int delta;
    private boolean balanceFlag;
    private IReaction reactionWithUniqueSTOICHIOMETRY;
    private final SmilesGenerator smiles;

    Reactor(IReaction reaction, boolean partialMapping, IMappingAlgorithm algorithm) throws Exception {
        this.smiles = partialMapping ? new SmilesGenerator(1796) : new SmilesGenerator(1812);
        this.partialMapping = partialMapping;
        this.algorithm = algorithm;
        this.reactionWithSTOICHIOMETRY = reaction.getBuilder().newInstance(IReaction.class, new Object[0]);
        this.reactionWithUniqueSTOICHIOMETRY = reaction.getBuilder().newInstance(IReaction.class, new Object[0]);
        this.balanceFlag = true;
        this.inputRankLabelledAtomsReactant = Collections.synchronizedMap(new HashMap());
        this.inputRankLabelledAtomsProduct = Collections.synchronizedMap(new HashMap());
        this.rLabelledAtoms = Collections.synchronizedMap(new HashMap());
        this.pLabelledAtoms = Collections.synchronizedMap(new HashMap());
        this.rBonds = Collections.synchronizedList(new ArrayList());
        this.pBonds = Collections.synchronizedList(new ArrayList());
        this.educts = Collections.synchronizedSortedMap(new TreeMap());
        this.products = Collections.synchronizedSortedMap(new TreeMap());
        this.substrateAtomCounter = 1;
        this.productAtomCounter = 1;
        Reactor.cleanMapping(reaction);
        this.copyReferenceReaction(reaction);
        this.expandReaction();
        this.checkReactionBalance();
        this.calculateAtomAtomMapping();
    }

    public String toString() {
        String createReactionSMILES = "";
        try {
            createReactionSMILES = this.smiles.create(this.reactionWithUniqueSTOICHIOMETRY);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return "Reactor{partialMapping=" + this.partialMapping + ", algorithm=" + this.algorithm + ", mapping=" + createReactionSMILES + "}";
    }

    private synchronized void copyReferenceReaction(IReaction referenceReaction) throws CDKException, IOException, Exception {
        Double st;
        IAtomContainer cloneMolecule;
        SmilesParser sp;
        IAtomContainer mol;
        IAtomContainer refMol;
        int i;
        try {
            for (i = 0; i < referenceReaction.getReactantCount(); ++i) {
                refMol = referenceReaction.getReactants().getAtomContainer(i);
                mol = ExtAtomContainerManipulator.cloneWithIDs(refMol);
                sp = new SmilesParser(SilentChemObjectBuilder.getInstance());
                cloneMolecule = sp.parseSmiles(this.smiles.create(mol));
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(cloneMolecule);
                cloneMolecule = this.prepareMol(cloneMolecule);
                cloneMolecule.setID(refMol.getID());
                st = referenceReaction.getReactantCoefficient(refMol);
                ExtAtomContainerManipulator.aromatizeMolecule(cloneMolecule);
                this.reactionWithSTOICHIOMETRY.addReactant(cloneMolecule, st);
            }
        }
        catch (CloneNotSupportedException | CDKException e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
        try {
            for (i = 0; i < referenceReaction.getProductCount(); ++i) {
                refMol = referenceReaction.getProducts().getAtomContainer(i);
                mol = ExtAtomContainerManipulator.cloneWithIDs(refMol);
                sp = new SmilesParser(SilentChemObjectBuilder.getInstance());
                cloneMolecule = sp.parseSmiles(this.smiles.create(mol));
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(cloneMolecule);
                cloneMolecule = this.prepareMol(cloneMolecule);
                cloneMolecule.setID(refMol.getID());
                st = referenceReaction.getProductCoefficient(refMol);
                ExtAtomContainerManipulator.aromatizeMolecule(cloneMolecule);
                this.reactionWithSTOICHIOMETRY.addProduct(cloneMolecule, st);
            }
            this.reactionWithSTOICHIOMETRY.setID(referenceReaction.getID());
            this.reactionWithSTOICHIOMETRY.setDirection(referenceReaction.getDirection());
        }
        catch (CloneNotSupportedException | CDKException e) {
            LOGGER.error(Level.SEVERE, "Error in Reactor class", e.getMessage());
        }
    }

    private synchronized void expandReaction() throws CloneNotSupportedException {
        Double stoichiometry;
        for (int i = 0; i < this.reactionWithSTOICHIOMETRY.getReactantCount(); ++i) {
            IAtomContainer _react = this.reactionWithSTOICHIOMETRY.getReactants().getAtomContainer(i);
            stoichiometry = this.reactionWithSTOICHIOMETRY.getReactantCoefficient(_react);
            while (stoichiometry > 0.0) {
                stoichiometry = stoichiometry - 1.0;
                IAtomContainer _reactDup = ExtAtomContainerManipulator.cloneWithIDs(_react);
                _reactDup.setID(_react.getID());
                _reactDup.setProperty("STOICHIOMETRY", 1.0);
                this.reactionWithUniqueSTOICHIOMETRY.addReactant(_reactDup, 1.0);
            }
        }
        for (int j = 0; j < this.reactionWithSTOICHIOMETRY.getProductCount(); ++j) {
            IAtomContainer _prod = this.reactionWithSTOICHIOMETRY.getProducts().getAtomContainer(j);
            stoichiometry = this.reactionWithSTOICHIOMETRY.getProductCoefficient(_prod);
            while (stoichiometry > 0.0) {
                stoichiometry = stoichiometry - 1.0;
                IAtomContainer prodDup = ExtAtomContainerManipulator.cloneWithIDs(_prod);
                prodDup.setID(_prod.getID());
                prodDup.setProperty("STOICHIOMETRY", 1.0);
                this.reactionWithUniqueSTOICHIOMETRY.addProduct(prodDup, 1.0);
            }
        }
        this.reactionWithUniqueSTOICHIOMETRY.setID(this.reactionWithSTOICHIOMETRY.getID() == null ? "MappedReaction (ecBLAST)" : this.reactionWithSTOICHIOMETRY.getID());
        this.reactionWithUniqueSTOICHIOMETRY.setDirection(this.reactionWithSTOICHIOMETRY.getDirection() == null ? IReaction.Direction.BIDIRECTIONAL : this.reactionWithSTOICHIOMETRY.getDirection());
        this.LabelAtoms();
        this.BondCollection();
    }

    private synchronized void LabelAtoms() {
        IAtom atom;
        String counter;
        int k;
        IAtomContainer container;
        int new_atom_rank_index_reactant = 1;
        int new_atom_rank_index_product = 1;
        for (int i = 0; i < this.reactionWithUniqueSTOICHIOMETRY.getReactantCount(); ++i) {
            container = this.reactionWithUniqueSTOICHIOMETRY.getReactants().getAtomContainer(i);
            for (k = 0; k < container.getAtomCount(); ++k) {
                counter = this.substrateAtomCounter.toString();
                this.substrateAtomCounter = this.substrateAtomCounter + 1;
                atom = container.getAtom(k);
                atom.setID(counter);
                this.rLabelledAtoms.put(atom.hashCode(), i);
                if (atom.getProperty("OLD_RANK") == null) continue;
                this.inputRankLabelledAtomsReactant.put((int)((Integer)atom.getProperty("OLD_RANK")), new_atom_rank_index_reactant++);
            }
            this.educts.put(i, container);
        }
        for (int j = 0; j < this.reactionWithUniqueSTOICHIOMETRY.getProductCount(); ++j) {
            container = this.reactionWithUniqueSTOICHIOMETRY.getProducts().getAtomContainer(j);
            for (k = 0; k < container.getAtomCount(); ++k) {
                counter = this.productAtomCounter.toString();
                this.productAtomCounter = this.productAtomCounter + 1;
                atom = container.getAtom(k);
                atom.setID(counter);
                this.pLabelledAtoms.put(atom.hashCode(), j);
                if (atom.getProperty("OLD_RANK") == null) continue;
                this.inputRankLabelledAtomsProduct.put((int)((Integer)atom.getProperty("OLD_RANK")), new_atom_rank_index_product++);
            }
            this.products.put(j, container);
        }
    }

    private synchronized void BondCollection() {
        IBond bond;
        int j;
        IAtomContainer mol;
        int i;
        for (i = 0; i < this.reactionWithUniqueSTOICHIOMETRY.getReactantCount(); ++i) {
            mol = this.reactionWithUniqueSTOICHIOMETRY.getReactants().getAtomContainer(i);
            for (j = 0; j < mol.getBondCount(); ++j) {
                bond = mol.getBond(j);
                this.rBonds.add(bond);
            }
        }
        for (i = 0; i < this.reactionWithUniqueSTOICHIOMETRY.getProductCount(); ++i) {
            mol = this.reactionWithUniqueSTOICHIOMETRY.getProducts().getAtomContainer(i);
            for (j = 0; j < mol.getBondCount(); ++j) {
                bond = mol.getBond(j);
                this.pBonds.add(bond);
            }
        }
    }

    private synchronized void checkReactionBalance() throws IOException {
        int count;
        IAtomContainerSet reactantSet = this.getExpandedReactants();
        IAtomContainerSet productSet = this.getExpandedProducts();
        HashMap<String, Integer> AtomMap = new HashMap<String, Integer>();
        for (int i = 0; i < reactantSet.getAtomContainerCount(); ++i) {
            IAtomContainer rMol = reactantSet.getAtomContainer(i);
            for (IAtom rAtom : rMol.atoms()) {
                if (rAtom.getSymbol().equals("H")) continue;
                if (AtomMap.containsKey(rAtom.getSymbol())) {
                    count = (Integer)AtomMap.get(rAtom.getSymbol()) + 1;
                    AtomMap.put(rAtom.getSymbol(), count);
                    continue;
                }
                AtomMap.put(rAtom.getSymbol(), 1);
            }
        }
        block2: for (int j = 0; j < productSet.getAtomContainerCount(); ++j) {
            IAtomContainer pMol = productSet.getAtomContainer(j);
            for (IAtom pAtom : pMol.atoms()) {
                if (pAtom.getSymbol().equals("H")) continue;
                if (AtomMap.containsKey(pAtom.getSymbol())) {
                    count = (Integer)AtomMap.get(pAtom.getSymbol()) - 1;
                    AtomMap.put(pAtom.getSymbol(), count);
                    continue;
                }
                if (AtomMap.containsKey(pAtom.getSymbol())) continue;
                AtomMap.put(pAtom.getSymbol(), 1);
                this.balanceFlag = false;
                continue block2;
            }
        }
        for (Map.Entry I : AtomMap.entrySet()) {
            if ((Integer)I.getValue() == 0) continue;
            this.balanceFlag = false;
            break;
        }
    }

    private synchronized void calculateAtomAtomMapping() throws IOException, Exception {
        try {
            IReaction reactionCopy = this.copyReaction(this.reactionWithUniqueSTOICHIOMETRY, this.partialMapping);
            CalculationProcess calP = new CalculationProcess(this.partialMapping, reactionCopy, this.getAlgorithm());
            this.delta = calP.getDelta();
            IReaction mappedReaction = calP.getMappedReaction();
            this.reactionWithUniqueSTOICHIOMETRY = this.getMapping(mappedReaction);
            this.setReactionBlastMolMapping(calP.getReactionBlastMolMapping());
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, "Error in Reactor class", ex);
        }
    }

    private synchronized IReaction getMapping(IReaction coreMappedReaction) throws IOException, CDKException, CloneNotSupportedException {
        Object atomLabel;
        IAtom atom;
        int eAtom;
        IAtomContainer eMolecule;
        int eMol;
        IReaction mappedReaction = ExtReactionManipulatorTool.deepClone(this.reactionWithUniqueSTOICHIOMETRY);
        Reactor.cleanMapping(mappedReaction);
        int counter = 1;
        counter = Reactor.setMappingFlags(mappedReaction, this.reactionWithUniqueSTOICHIOMETRY, coreMappedReaction, counter);
        for (eMol = 0; eMol < mappedReaction.getReactantCount(); ++eMol) {
            eMolecule = mappedReaction.getReactants().getAtomContainer(eMol);
            for (eAtom = 0; eAtom < eMolecule.getAtomCount(); ++eAtom) {
                atom = mappedReaction.getReactants().getAtomContainer(eMol).getAtom(eAtom);
                if (!atom.getSymbol().equalsIgnoreCase("H") && atom.getID().equalsIgnoreCase("-1")) {
                    atomLabel = Integer.toString(counter);
                    atom.setID((String)atomLabel);
                    atom.setFlag(128, false);
                }
                ++counter;
            }
        }
        for (int pMol = 0; pMol < mappedReaction.getProductCount(); ++pMol) {
            IAtomContainer pMolecule = mappedReaction.getProducts().getAtomContainer(pMol);
            for (int pAtom = 0; pAtom < pMolecule.getAtomCount(); ++pAtom) {
                atom = mappedReaction.getProducts().getAtomContainer(pMol).getAtom(pAtom);
                if (atom.getSymbol().equalsIgnoreCase("H") || !atom.getID().equalsIgnoreCase("-1")) continue;
                atomLabel = Integer.toString(counter);
                atom.setID((String)atomLabel);
                atom.setFlag(128, false);
                ++counter;
            }
        }
        for (eMol = 0; eMol < mappedReaction.getReactantCount(); ++eMol) {
            eMolecule = mappedReaction.getReactants().getAtomContainer(eMol);
            block5: for (eAtom = 0; eAtom < eMolecule.getAtomCount(); ++eAtom) {
                atom = mappedReaction.getReactants().getAtomContainer(eMol).getAtom(eAtom);
                if (atom.getSymbol().equalsIgnoreCase("H") || atom.getID().equalsIgnoreCase("-1")) continue;
                List<IAtom> eductConnAtoms = eMolecule.getConnectedAtomsList(atom);
                List<IAtom> productHAtoms = this.markHAroundCoreAtoms(atom.getID(), mappedReaction.getProducts());
                for (IAtom eAtomH : eductConnAtoms) {
                    if (!eAtomH.getID().equalsIgnoreCase("-1") || !eAtomH.getSymbol().equalsIgnoreCase("H")) continue;
                    if (productHAtoms.isEmpty()) continue block5;
                    String atomLabel2 = Integer.toString(counter);
                    eAtomH.setID(atomLabel2);
                    eAtomH.setFlag(128, true);
                    IAtom pAtomH = productHAtoms.iterator().next();
                    pAtomH.setID(atomLabel2);
                    pAtomH.setFlag(128, true);
                    productHAtoms.remove(pAtomH);
                    ++counter;
                }
            }
        }
        List<IAtom> unMappedSingleHAtEduct = this.collectUnMappedSingleHAtoms(mappedReaction.getReactants());
        List<IAtom> unMappedSingleHAtProduct = this.collectUnMappedSingleHAtoms(mappedReaction.getProducts());
        for (IAtom eAtomH : unMappedSingleHAtEduct) {
            if (unMappedSingleHAtProduct.isEmpty()) break;
            atomLabel = Integer.toString(counter);
            eAtomH.setID((String)atomLabel);
            eAtomH.setFlag(128, true);
            IAtom pAtomH = unMappedSingleHAtProduct.iterator().next();
            pAtomH.setID((String)atomLabel);
            pAtomH.setFlag(128, true);
            unMappedSingleHAtProduct.remove(pAtomH);
            ++counter;
        }
        List<IAtom> unMappedHAtEduct = this.collectUnMappedHAtoms(mappedReaction.getReactants());
        List<IAtom> unMappedHAtProduct = this.collectUnMappedHAtoms(mappedReaction.getProducts());
        for (IAtom eAtomH : unMappedHAtEduct) {
            if (unMappedHAtProduct.isEmpty()) break;
            String atomLabel3 = Integer.toString(counter);
            eAtomH.setID(atomLabel3);
            eAtomH.setFlag(128, true);
            IAtom pAtomH = unMappedHAtProduct.iterator().next();
            pAtomH.setID(atomLabel3);
            pAtomH.setFlag(128, true);
            unMappedHAtProduct.remove(pAtomH);
            ++counter;
        }
        counter = this.markUnMappedHAtoms(mappedReaction, counter);
        HashMap<IAtom, IAtom> mappings = new HashMap<IAtom, IAtom>();
        for (IAtomContainer ac1 : mappedReaction.getReactants().atomContainers()) {
            for (IAtom atom1 : ac1.atoms()) {
                IAtom atom2 = this.getContainerAtomByID(mappedReaction.getProducts(), atom1.getID());
                if (atom2 == null) continue;
                mappings.put(atom1, atom2);
            }
        }
        mappings.keySet().stream().filter(key -> key != null && mappings.get(key) != null).map(key -> mappedReaction.getBuilder().newInstance(IMapping.class, key, mappings.get(key))).forEachOrdered(mappingObject -> mappedReaction.addMapping((IMapping)mappingObject));
        counter = this.setCanonicalMappingLabels(mappedReaction);
        return mappedReaction;
    }

    @Override
    public synchronized IAtomContainerSet getExpandedReactants() throws IOException {
        return this.reactionWithUniqueSTOICHIOMETRY.getReactants();
    }

    @Override
    public synchronized IAtomContainerSet getExpandedProducts() throws IOException {
        return this.reactionWithUniqueSTOICHIOMETRY.getProducts();
    }

    @Override
    public synchronized IReaction getReactionWithAtomAtomMapping() throws Exception {
        return this.reactionWithUniqueSTOICHIOMETRY;
    }

    @Override
    public synchronized Double getExpandedReactantStoichiometry(int i) {
        IAtomContainer Mol = this.reactionWithUniqueSTOICHIOMETRY.getReactants().getAtomContainer(i);
        return this.reactionWithUniqueSTOICHIOMETRY.getReactantCoefficient(Mol);
    }

    @Override
    public synchronized Double getExpandedProductStoichiometry(int i) {
        IAtomContainer Mol = this.reactionWithUniqueSTOICHIOMETRY.getProducts().getAtomContainer(i);
        return this.reactionWithUniqueSTOICHIOMETRY.getProductCoefficient(Mol);
    }

    @Override
    public synchronized boolean getReactionBalanceFlag() throws IOException {
        boolean flag = true;
        if (!Objects.equals(this.getLabledReactantAtomsCount(), this.getLabledProductAtomsCount())) {
            flag = false;
        }
        if (!this.getReactionBalanceFlagWithoutHydrogen()) {
            flag = false;
        }
        return flag;
    }

    @Override
    public synchronized boolean getReactionBalanceFlagWithChargeBalance() throws IOException {
        boolean flag = true;
        if (!Objects.equals(this.getLabledReactantAtomsCount(), this.getLabledProductAtomsCount())) {
            flag = false;
        }
        if (AtomContainerSetManipulator.getTotalFormalCharge(this.getExpandedReactants()) != AtomContainerSetManipulator.getTotalFormalCharge(this.getExpandedProducts())) {
            flag = false;
        }
        if (!this.getReactionBalanceFlagWithoutHydrogen()) {
            flag = false;
        }
        return flag;
    }

    @Override
    public synchronized boolean getReactionBalanceFlagWithoutHydrogen() {
        return this.balanceFlag;
    }

    private synchronized List<IAtom> getLabledReactantAtoms() {
        ArrayList<IAtom> reactantAtoms = new ArrayList<IAtom>();
        IAtomContainerSet MSet = this.reactionWithUniqueSTOICHIOMETRY.getReactants();
        for (int j = 0; j < MSet.getAtomContainerCount(); ++j) {
            IAtomContainer M = MSet.getAtomContainer(j);
            for (int k = 0; k < M.getAtomCount(); ++k) {
                reactantAtoms.add(M.getAtom(k));
            }
        }
        return Collections.unmodifiableList(reactantAtoms);
    }

    private synchronized List<IAtom> getLabledProductAtoms() {
        ArrayList<IAtom> productAtoms = new ArrayList<IAtom>();
        IAtomContainerSet MSet = this.reactionWithUniqueSTOICHIOMETRY.getProducts();
        for (int j = 0; j < MSet.getAtomContainerCount(); ++j) {
            IAtomContainer M = MSet.getAtomContainer(j);
            for (int k = 0; k < M.getAtomCount(); ++k) {
                productAtoms.add(M.getAtom(k));
            }
        }
        return Collections.unmodifiableList(productAtoms);
    }

    private synchronized Integer getLabledReactantAtomsCount() {
        return this.getLabledReactantAtoms().size();
    }

    private synchronized Integer getLabledProductAtomsCount() {
        return this.getLabledProductAtoms().size();
    }

    @Override
    public synchronized List<IBond> getEductBonds() {
        return Collections.unmodifiableList(this.rBonds);
    }

    @Override
    public synchronized List<IBond> getProductBonds() {
        return Collections.unmodifiableList(this.pBonds);
    }

    @Override
    public synchronized int getMappingCount() {
        return this.reactionWithUniqueSTOICHIOMETRY.getMappingCount();
    }

    private synchronized IReaction copyReaction(IReaction orignalReaction, boolean removeHydrogen) throws Exception {
        IAtom atom;
        int index;
        IAtomContainer newMol;
        Double st;
        IAtomContainer mol;
        int i;
        IReaction copiedReaction = this.reactionWithUniqueSTOICHIOMETRY.getBuilder().newInstance(IReaction.class, new Object[0]);
        for (i = 0; i < orignalReaction.getReactantCount(); ++i) {
            mol = orignalReaction.getReactants().getAtomContainer(i);
            st = orignalReaction.getReactantCoefficient(mol);
            newMol = ExtAtomContainerManipulator.cloneWithIDs(mol);
            for (index = 0; index < mol.getAtomCount(); ++index) {
                mol.getAtom(index).setProperty("index", index);
                atom = newMol.getAtom(index);
                atom.setProperty("index", index);
            }
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(newMol);
            if (removeHydrogen) {
                newMol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(newMol);
            }
            copiedReaction.addReactant(newMol, st);
        }
        for (i = 0; i < orignalReaction.getProductCount(); ++i) {
            mol = orignalReaction.getProducts().getAtomContainer(i);
            st = orignalReaction.getProductCoefficient(mol);
            newMol = ExtAtomContainerManipulator.cloneWithIDs(mol);
            for (index = 0; index < mol.getAtomCount(); ++index) {
                mol.getAtom(index).setProperty("index", index);
                atom = newMol.getAtom(index);
                atom.setProperty("index", index);
            }
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(newMol);
            if (removeHydrogen) {
                newMol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(newMol);
            }
            copiedReaction.addProduct(newMol, st);
        }
        copiedReaction.setFlags(orignalReaction.getFlags());
        copiedReaction.setID(orignalReaction.getID());
        copiedReaction.setDirection(orignalReaction.getDirection());
        copiedReaction.notifyChanged();
        return copiedReaction;
    }

    private synchronized List<IAtom> markHAroundCoreAtoms(String id, IAtomContainerSet molSet) {
        ArrayList<IAtom> list = new ArrayList<IAtom>();
        for (int pMol = 0; pMol < molSet.getAtomContainerCount(); ++pMol) {
            IAtomContainer pMolecule = molSet.getAtomContainer(pMol);
            for (int pAtom = 0; pAtom < pMolecule.getAtomCount(); ++pAtom) {
                IAtom atom = molSet.getAtomContainer(pMol).getAtom(pAtom);
                if (atom.getSymbol().equalsIgnoreCase("H") || atom.getID().equalsIgnoreCase("-1") || !atom.getID().equalsIgnoreCase(id)) continue;
                List<IAtom> conAtoms = pMolecule.getConnectedAtomsList(atom);
                conAtoms.stream().filter(atomH -> atomH.getID().equalsIgnoreCase("-1") && atomH.getSymbol().equalsIgnoreCase("H")).forEach(atomH -> list.add((IAtom)atomH));
            }
        }
        return list;
    }

    private synchronized List<IAtom> collectUnMappedSingleHAtoms(IAtomContainerSet molSet) {
        ArrayList<IAtom> list = new ArrayList<IAtom>();
        for (int index = 0; index < molSet.getAtomContainerCount(); ++index) {
            IAtomContainer mol = molSet.getAtomContainer(index);
            if (mol.getAtomCount() != 1) continue;
            for (int atomIndex = 0; atomIndex < mol.getAtomCount(); ++atomIndex) {
                IAtom atom = molSet.getAtomContainer(index).getAtom(atomIndex);
                if (!atom.getSymbol().equalsIgnoreCase("H") || atom.getFlag(128) || !atom.getID().equalsIgnoreCase("-1")) continue;
                list.add(atom);
            }
        }
        return list;
    }

    private synchronized List<IAtom> collectUnMappedHAtoms(IAtomContainerSet molSet) {
        ArrayList<IAtom> list = new ArrayList<IAtom>();
        for (int index = 0; index < molSet.getAtomContainerCount(); ++index) {
            IAtomContainer mol = molSet.getAtomContainer(index);
            for (int atomIndex = 0; atomIndex < mol.getAtomCount(); ++atomIndex) {
                IAtom atom = molSet.getAtomContainer(index).getAtom(atomIndex);
                if (!atom.getSymbol().equalsIgnoreCase("H") || atom.getFlag(128) || !atom.getID().equalsIgnoreCase("-1")) continue;
                list.add(atom);
            }
        }
        return list;
    }

    private synchronized int markUnMappedHAtoms(IReaction mappedReaction, int counter) {
        String atomLabel;
        IAtom atom;
        int localCounter = counter;
        for (int eMol = 0; eMol < mappedReaction.getReactantCount(); ++eMol) {
            IAtomContainer eMolecule = mappedReaction.getReactants().getAtomContainer(eMol);
            for (int eAtom = 0; eAtom < eMolecule.getAtomCount(); ++eAtom) {
                atom = mappedReaction.getReactants().getAtomContainer(eMol).getAtom(eAtom);
                if (!atom.getSymbol().equalsIgnoreCase("H") || atom.getFlag(128) || !atom.getID().equalsIgnoreCase("-1")) continue;
                atomLabel = Integer.toString(localCounter);
                atom.setFlag(128, false);
                atom.setID(atomLabel);
                ++localCounter;
            }
        }
        for (int pMol = 0; pMol < mappedReaction.getProductCount(); ++pMol) {
            IAtomContainer pMolecule = mappedReaction.getProducts().getAtomContainer(pMol);
            for (int pAtom = 0; pAtom < pMolecule.getAtomCount(); ++pAtom) {
                atom = mappedReaction.getProducts().getAtomContainer(pMol).getAtom(pAtom);
                if (!atom.getSymbol().equalsIgnoreCase("H") || atom.getFlag(128) || !atom.getID().equalsIgnoreCase("-1")) continue;
                atomLabel = Integer.toString(localCounter);
                atom.setID(atomLabel);
                atom.setFlag(128, false);
                ++localCounter;
            }
        }
        return localCounter;
    }

    public synchronized int getDelta() {
        return this.delta;
    }

    public synchronized MoleculeMoleculeMapping getReactionBlastMolMapping() {
        return this.reactionBlastMolMapping;
    }

    private synchronized void setReactionBlastMolMapping(MoleculeMoleculeMapping reactionBlastMolMapping) {
        this.reactionBlastMolMapping = reactionBlastMolMapping;
    }

    private synchronized IAtom getContainerAtomByID(IAtomContainerSet products, String mappingID) {
        for (IAtomContainer ac : products.atomContainers()) {
            for (IAtom atom : ac.atoms()) {
                if (!atom.getID().equals(mappingID)) continue;
                return atom;
            }
        }
        return null;
    }

    private synchronized int setCanonicalMappingLabels(IReaction mappedReaction) throws CDKException {
        String id;
        int c;
        Iterator iterator;
        int index;
        Iterator<IAtom> array;
        ArrayList<Integer> atom_index;
        IAtomContainerSet rMolSet = mappedReaction.getReactants();
        IAtomContainerSet pMolSet = mappedReaction.getProducts();
        HashMap<IAtom, IAtom> mappingMap = new HashMap<IAtom, IAtom>();
        for (IMapping aaMapping : mappedReaction.mappings()) {
            aaMapping.getChemObject(0).removeProperty("cdk:AtomAtomMapping");
            aaMapping.getChemObject(1).removeProperty("cdk:AtomAtomMapping");
            mappingMap.put((IAtom)aaMapping.getChemObject(0), (IAtom)aaMapping.getChemObject(1));
        }
        for (IAtomContainer mol : rMolSet.atomContainers()) {
            atom_index = new ArrayList<Integer>();
            for (IAtom a : mol.atoms()) {
                if (a.getSymbol().equalsIgnoreCase("H")) continue;
                atom_index.add(mol.indexOf(a));
            }
            for (IAtom a : mol.atoms()) {
                if (!a.getSymbol().equalsIgnoreCase("H")) continue;
                atom_index.add(mol.indexOf(a));
            }
            array = (Iterator<IAtom>)new int[atom_index.size()];
            index = 0;
            iterator = atom_index.iterator();
            while (iterator.hasNext()) {
                c = (Integer)iterator.next();
                array[index] = (Iterator<IAtom>)c;
                ++index;
            }
            this.permuteWithoutClone((int[])array, mol);
        }
        for (IAtomContainer mol : pMolSet.atomContainers()) {
            atom_index = new ArrayList();
            for (IAtom a : mol.atoms()) {
                if (a.getSymbol().equalsIgnoreCase("H")) continue;
                atom_index.add(mol.indexOf(a));
            }
            for (IAtom a : mol.atoms()) {
                if (!a.getSymbol().equalsIgnoreCase("H")) continue;
                atom_index.add(mol.indexOf(a));
            }
            array = (Iterator<IAtom>)new int[atom_index.size()];
            index = 0;
            iterator = atom_index.iterator();
            while (iterator.hasNext()) {
                c = (Integer)iterator.next();
                array[index] = (Iterator<IAtom>)c;
                ++index;
            }
            this.permuteWithoutClone((int[])array, mol);
        }
        int counter = 1;
        for (IAtomContainer mol : rMolSet.atomContainers()) {
            for (IAtom qAtom : mol.atoms()) {
                if (!mappingMap.containsKey(qAtom) || qAtom.getSymbol().equalsIgnoreCase("H")) continue;
                id = String.valueOf(counter);
                qAtom.setID(id);
                ((IAtom)mappingMap.get(qAtom)).setID(id);
                qAtom.setProperty("cdk:AtomAtomMapping", Integer.parseInt(qAtom.getID()));
                ((IAtom)mappingMap.get(qAtom)).setProperty("cdk:AtomAtomMapping", Integer.parseInt(((IAtom)mappingMap.get(qAtom)).getID()));
                ++counter;
            }
        }
        for (IAtomContainer mol : rMolSet.atomContainers()) {
            for (IAtom qAtom : mol.atoms()) {
                if (!mappingMap.containsKey(qAtom) || !qAtom.getSymbol().equalsIgnoreCase("H")) continue;
                id = String.valueOf(counter);
                qAtom.setID(id);
                ((IAtom)mappingMap.get(qAtom)).setID(id);
                qAtom.setProperty("cdk:AtomAtomMapping", Integer.parseInt(qAtom.getID()));
                ((IAtom)mappingMap.get(qAtom)).setProperty("cdk:AtomAtomMapping", Integer.parseInt(((IAtom)mappingMap.get(qAtom)).getID()));
                ++counter;
            }
        }
        for (IAtomContainer mol : rMolSet.atomContainers()) {
            for (IAtom qAtom : mol.atoms()) {
                if (mappingMap.containsKey(qAtom)) continue;
                id = String.valueOf(counter);
                qAtom.setID(id);
                qAtom.setProperty("cdk:AtomAtomMapping", Integer.parseInt(qAtom.getID()));
                ++counter;
            }
        }
        for (IAtomContainer mol : pMolSet.atomContainers()) {
            for (IAtom tAtom : mol.atoms()) {
                if (mappingMap.containsValue(tAtom)) continue;
                id = String.valueOf(counter);
                tAtom.setID(id);
                tAtom.setProperty("cdk:AtomAtomMapping", Integer.parseInt(tAtom.getID()));
                ++counter;
            }
        }
        for (IAtomContainer mol : pMolSet.atomContainers()) {
            TreeMap<Integer, Integer> mapping_rank = new TreeMap<Integer, Integer>();
            for (IAtom a : mol.atoms()) {
                mapping_rank.put((Integer)a.getProperty("cdk:AtomAtomMapping"), mol.indexOf(a));
            }
            int[] mappingIndexPermutation = new int[mapping_rank.size()];
            int index2 = 0;
            Iterator iterator2 = mapping_rank.values().iterator();
            while (iterator2.hasNext()) {
                int i;
                mappingIndexPermutation[index2] = i = ((Integer)iterator2.next()).intValue();
                ++index2;
            }
            this.permuteWithoutClone(mappingIndexPermutation, mol);
        }
        mappingMap.clear();
        return counter;
    }

    public synchronized IMappingAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    private synchronized IAtomContainer prepareMol(IAtomContainer cloneMolecule) throws CloneNotSupportedException, CDKException {
        int[] p = new int[cloneMolecule.getAtomCount()];
        try {
            String string = SmilesGenerator.unique().create(cloneMolecule, p);
        }
        catch (CDKException e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
        this.permuteWithoutClone(p, cloneMolecule);
        if (!GeometryUtil.has2DCoordinates(cloneMolecule)) {
            try {
                StructureDiagramGenerator sdg = new StructureDiagramGenerator();
                sdg.setMolecule(cloneMolecule, false);
                sdg.generateCoordinates();
            }
            catch (CDKException e) {
                LOGGER.error(Level.SEVERE, "Error in 2D Generation ", e.getMessage());
            }
        }
        for (IAtom atom : cloneMolecule.atoms()) {
            atom.setID("-1");
        }
        return cloneMolecule;
    }

    private synchronized void permuteWithoutClone(int[] p, IAtomContainer atomContainer) {
        int n = atomContainer.getAtomCount();
        IAtom[] permutedAtoms = new IAtom[n];
        for (int i = 0; i < n; ++i) {
            IAtom atom;
            permutedAtoms[p[i]] = atom = atomContainer.getAtom(i);
            atom.setProperty("label", p[i]);
        }
        atomContainer.setAtoms(permutedAtoms);
        IBond[] bonds = AtomContainerManipulator.getBondArray(atomContainer);
        Arrays.sort(bonds, (o1, o2) -> {
            int u = (Integer)o1.getAtom(0).getProperty("label");
            int v = (Integer)o1.getAtom(1).getProperty("label");
            int x = (Integer)o2.getAtom(0).getProperty("label");
            int y = (Integer)o2.getAtom(1).getProperty("label");
            int min1 = Math.min(u, v);
            int min2 = Math.min(x, y);
            int max1 = Math.max(u, v);
            int max2 = Math.max(x, y);
            int minCmp = Integer.compare(min1, min2);
            if (minCmp != 0) {
                return minCmp;
            }
            int maxCmp = Integer.compare(max1, max2);
            if (maxCmp != 0) {
                return maxCmp;
            }
            LOGGER.debug("pokemon!");
            throw new InternalError();
        });
        atomContainer.setBonds(bonds);
    }

    public Map<Integer, Integer> getInputRankLabelledAtomsReactant() {
        return this.inputRankLabelledAtomsReactant;
    }

    public Map<Integer, Integer> getInputRankLabelledAtomsProduct() {
        return this.inputRankLabelledAtomsProduct;
    }
}

