/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.CircularFingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.Isomorphism;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.interfaces.Algorithm;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.fingerprints.tools.Similarity;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.cache.ThreadSafeCache;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.mapping.graph.GraphMatcher;
import uk.ac.ebi.reactionblast.mapping.graph.MCSSolution;
import uk.ac.ebi.reactionblast.mapping.helper.Debugger;
import uk.ac.ebi.reactionblast.mapping.interfaces.BestMatch;
import uk.ac.ebi.reactionblast.mapping.interfaces.IGameTheory;

public abstract class BaseGameTheory
extends Debugger
implements IGameTheory,
Serializable {
    private static final boolean DEBUG = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(BaseGameTheory.class);
    private static final long serialVersionUID = 1698688633678282L;

    protected static synchronized boolean isPseudoAtoms(IAtomContainer atomContainer) {
        for (IAtom atoms : atomContainer.atoms()) {
            if (!(atoms instanceof IPseudoAtom) && !(atoms instanceof PseudoAtom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized String getSuffix() throws IOException {
        GregorianCalendar cal = new GregorianCalendar();
        int ms = cal.get(1);
        String suffix = String.valueOf(ms);
        ms = cal.get(2);
        suffix = suffix.concat(String.valueOf(ms));
        ms = cal.get(5);
        suffix = suffix.concat(String.valueOf(ms));
        ms = cal.get(10);
        suffix = suffix.concat(String.valueOf(ms));
        ms = cal.get(12);
        suffix = suffix.concat(String.valueOf(ms));
        ms = cal.get(14);
        suffix = suffix.concat(String.valueOf(ms));
        return suffix;
    }

    @Override
    public synchronized void UpdateMatrix(Holder mh, boolean removeHydrogen) throws InterruptedException {
        try {
            ReactionContainer reactionStructureInformation = mh.getReactionContainer();
            Collection<MCSSolution> mcsSolutions = null;
            try {
                mcsSolutions = GraphMatcher.matcher(mh);
            }
            catch (InterruptedException e) {
                LOGGER.error("Error in matching molecules, check Graph Matcher module! ", e.getMessage());
            }
            for (int substrateIndex = 0; substrateIndex < reactionStructureInformation.getEductCount(); ++substrateIndex) {
                for (int productIndex = 0; productIndex < reactionStructureInformation.getProductCount(); ++productIndex) {
                    try {
                        IAtomContainer educt = reactionStructureInformation.getEduct(substrateIndex);
                        IAtomContainer product = reactionStructureInformation.getProduct(productIndex);
                        if (educt != null && product != null && reactionStructureInformation.getEduct(substrateIndex).getAtomCount() > 0 && reactionStructureInformation.getProduct(productIndex).getAtomCount() > 0 || mh.getGraphSimilarityMatrix().getValue(substrateIndex, productIndex) == -1.0) {
                            if (reactionStructureInformation.isEductModified(substrateIndex) || reactionStructureInformation.isProductModified(productIndex)) {
                                this.refillMatrixWithNewData(mh, substrateIndex, productIndex, mcsSolutions);
                                continue;
                            }
                            this.refillMatrixWithOldData(mh, substrateIndex, productIndex);
                            continue;
                        }
                        mh.getGraphSimilarityMatrix().setValue(substrateIndex, productIndex, 0.0);
                        mh.getStereoMatrix().setValue(substrateIndex, productIndex, 0.0);
                        mh.getCliqueMatrix().setValue(substrateIndex, productIndex, 0.0);
                        mh.getCarbonOverlapMatrix().setValue(substrateIndex, productIndex, 0.0);
                        mh.getFragmentMatrix().setValue(substrateIndex, productIndex, 0.0);
                        mh.getEnergyMatrix().setValue(substrateIndex, productIndex, 0.0);
                        mh.getFPSimilarityMatrix().setValue(substrateIndex, productIndex, 0.0);
                        continue;
                    }
                    catch (IOException | CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in matching molecules, check Graph Matcher module! ", e.getMessage().toString());
        }
        try {
            this.resetFLAGS(mh);
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    @Override
    public synchronized void UpdateMatrix(Collection<MCSSolution> mcsSolutions, Holder mh, boolean removeHydrogen) throws Exception {
        try {
            ReactionContainer reactionStructureInformation = mh.getReactionContainer();
            for (int substrateIndex = 0; substrateIndex < reactionStructureInformation.getEductCount(); ++substrateIndex) {
                for (int productIndex = 0; productIndex < reactionStructureInformation.getProductCount(); ++productIndex) {
                    IAtomContainer educt = reactionStructureInformation.getEduct(substrateIndex);
                    IAtomContainer product = reactionStructureInformation.getProduct(productIndex);
                    if (educt != null && product != null && reactionStructureInformation.getEduct(substrateIndex).getAtomCount() > 0 && reactionStructureInformation.getProduct(productIndex).getAtomCount() > 0 || mh.getGraphSimilarityMatrix().getValue(substrateIndex, productIndex) == -1.0) {
                        if (reactionStructureInformation.isEductModified(substrateIndex) || reactionStructureInformation.isProductModified(productIndex)) {
                            this.refillMatrixWithNewData(mh, substrateIndex, productIndex, mcsSolutions);
                            continue;
                        }
                        this.refillMatrixWithOldData(mh, substrateIndex, productIndex);
                        continue;
                    }
                    mh.getGraphSimilarityMatrix().setValue(substrateIndex, productIndex, 0.0);
                    mh.getStereoMatrix().setValue(substrateIndex, productIndex, 0.0);
                    mh.getCliqueMatrix().setValue(substrateIndex, productIndex, 0.0);
                    mh.getCarbonOverlapMatrix().setValue(substrateIndex, productIndex, 0.0);
                    mh.getFragmentMatrix().setValue(substrateIndex, productIndex, 0.0);
                    mh.getEnergyMatrix().setValue(substrateIndex, productIndex, 0.0);
                    mh.getFPSimilarityMatrix().setValue(substrateIndex, productIndex, 0.0);
                }
            }
            this.resetFLAGS(mh);
        }
        catch (Exception e) {
            LOGGER.error("Error in matching molecules, check Graph Matcher module! ", e.getMessage().toString());
        }
    }

    private synchronized void refillMatrixWithNewData(Holder holder, int substrateIndex, int productIndex, Collection<MCSSolution> mcsSolutions) {
        try {
            ReactionContainer reactionContainer = holder.getReactionContainer();
            BestMatch initMcsAtom = holder.getBestMatchContainer();
            double stereoVal = 0.0;
            int fragmentVal = 0;
            double energyVal = 0.0;
            double graphSimilarity = 0.0;
            double mappingSize = 0.0;
            double fpSim = 0.0;
            double carbonCount = 0.0;
            IAtomContainer educt = reactionContainer.getEduct(substrateIndex);
            IAtomContainer product = reactionContainer.getProduct(productIndex);
            MCSSolution atomatomMapping = this.getMappings(substrateIndex, productIndex, educt, product, mcsSolutions);
            carbonCount = atomatomMapping.getAtomAtomMapping().getMappingsByAtoms().keySet().stream().filter(atom -> atom.getSymbol().equalsIgnoreCase("C")).map(_item -> 1.0).reduce(carbonCount, (accumulator, _item) -> accumulator + 1.0);
            if (atomatomMapping == null) {
                throw new CDKException("atom-atom mapping is null");
            }
            if (atomatomMapping.getStereoScore() != null) {
                stereoVal = atomatomMapping.getStereoScore().intValue();
            }
            if (atomatomMapping.getFragmentSize() != null) {
                fragmentVal = atomatomMapping.getFragmentSize();
            }
            if (atomatomMapping.getEnergy() != null) {
                energyVal = atomatomMapping.getEnergy();
            }
            AtomAtomMapping fam = atomatomMapping.getAtomAtomMapping();
            initMcsAtom.putBestMapping(substrateIndex, productIndex, fam);
            double ACount = educt.getAtomCount();
            double BCount = product.getAtomCount();
            mappingSize = atomatomMapping.getAtomAtomMapping().getCount();
            graphSimilarity = mappingSize / (ACount + BCount - mappingSize);
            initMcsAtom.setTotalFragmentCount(substrateIndex, productIndex, fragmentVal);
            initMcsAtom.setBondEnergy(substrateIndex, productIndex, energyVal);
            initMcsAtom.setStereoScore(substrateIndex, productIndex, stereoVal);
            initMcsAtom.setGraphSimilarity(substrateIndex, productIndex, graphSimilarity);
            BitSet a = reactionContainer.getFingerPrintofEduct(substrateIndex);
            BitSet b = reactionContainer.getFingerPrintofProduct(productIndex);
            if (a != null && b != null) {
                try {
                    fpSim = Similarity.getTanimotoSimilarity(a, b);
                }
                catch (Exception ex) {
                    LOGGER.error(Level.SEVERE, " error in calculating fingerprint ", ex.getMessage());
                }
            }
            holder.getCliqueMatrix().setValue(substrateIndex, productIndex, mappingSize);
            holder.getGraphSimilarityMatrix().setValue(substrateIndex, productIndex, graphSimilarity);
            holder.getStereoMatrix().setValue(substrateIndex, productIndex, stereoVal);
            holder.getCarbonOverlapMatrix().setValue(substrateIndex, productIndex, carbonCount);
            holder.getFragmentMatrix().setValue(substrateIndex, productIndex, fragmentVal);
            holder.getEnergyMatrix().setValue(substrateIndex, productIndex, energyVal);
            holder.getFPSimilarityMatrix().setValue(substrateIndex, productIndex, fpSim);
        }
        catch (IOException | CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    private synchronized MCSSolution getMappings(int queryPosition, int targetPosition, IAtomContainer educt, IAtomContainer product, Collection<MCSSolution> mcsSolutions) throws CDKException {
        if (mcsSolutions.isEmpty()) {
            return this.quickMapping(educt, product, queryPosition, targetPosition);
        }
        for (MCSSolution solution : mcsSolutions) {
            if (solution.getQueryPosition() != queryPosition || solution.getTargetPosition() != targetPosition) continue;
            if (solution.getAtomAtomMapping().isEmpty()) {
                HashSet<String> atomMaps = new HashSet<String>();
                for (IAtom a : educt.atoms()) {
                    atomMaps.add(a.getSymbol());
                }
                boolean mappingPossible = false;
                for (IAtom a : product.atoms()) {
                    if (!atomMaps.contains(a.getSymbol())) continue;
                    mappingPossible = true;
                }
                atomMaps.clear();
                if (mappingPossible) {
                    return this.quickMapping(educt, product, queryPosition, targetPosition);
                }
            }
            return solution;
        }
        return null;
    }

    private MCSSolution quickMapping(IAtomContainer educt, IAtomContainer product, int queryPosition, int targetPosition) {
        ThreadSafeCache mappingcache = ThreadSafeCache.getInstance();
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(educt);
            MoleculeInitializer.initializeMolecule(educt);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, "Error in config. mol ", ex.getMessage());
        }
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(product);
            MoleculeInitializer.initializeMolecule(product);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, "Error in config. mol ", ex.getMessage());
        }
        try {
            CycleFinder cycles = Cycles.vertexShort();
            Cycles rings = cycles.find(educt);
            int numberOfCyclesEduct = rings.numberOfCycles();
            rings = cycles.find(product);
            int numberOfCyclesProduct = rings.numberOfCycles();
            String key = this.generateUniqueKey(educt, product, educt.getID(), product.getID(), educt.getAtomCount(), product.getAtomCount(), educt.getBondCount(), product.getBondCount(), false, false, false, false, numberOfCyclesEduct, numberOfCyclesProduct);
            if (mappingcache.containsKey(key)) {
                MCSSolution solution = (MCSSolution)mappingcache.get(key);
                MCSSolution mcs = this.copyOldSolutionToNew(queryPosition, targetPosition, educt, product, solution);
                return mcs;
            }
            AtomMatcher atomMatcher = AtomBondMatcher.atomMatcher(false, false);
            BondMatcher bondMatcher = AtomBondMatcher.bondMatcher(false, false);
            Isomorphism isomorphism = new Isomorphism(educt, product, Algorithm.DEFAULT, atomMatcher, bondMatcher);
            MCSSolution mcs = this.addMCSSolution(queryPosition, targetPosition, key, mappingcache, isomorphism);
            return mcs;
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void resetFLAGS(Holder mh) throws Exception {
        ReactionContainer reactionStructureInformation = mh.getReactionContainer();
        for (int substrateIndex = 0; substrateIndex < reactionStructureInformation.getEductCount(); ++substrateIndex) {
            for (int productIndex = 0; productIndex < reactionStructureInformation.getProductCount(); ++productIndex) {
                reactionStructureInformation.setEductModified(substrateIndex, false);
                reactionStructureInformation.setProductModified(productIndex, false);
            }
        }
    }

    private void refillMatrixWithOldData(Holder holder, int substrateIndex, int productIndex) {
        try {
            ReactionContainer reactionContainer = holder.getReactionContainer();
            BestMatch initMcsAtom = holder.getBestMatchContainer();
            double stereoVal = 0.0;
            int fragmentVal = 0;
            double energyVal = 0.0;
            double graphSimilarity = 0.0;
            double mappingSize = 0.0;
            double fpSim = 0.0;
            double carbonCount = 0.0;
            IAtomContainer educt = reactionContainer.getEduct(substrateIndex);
            IAtomContainer product = reactionContainer.getProduct(productIndex);
            if (initMcsAtom.containsKey(substrateIndex, productIndex)) {
                AtomAtomMapping bestAtomAtomMapping = initMcsAtom.getAtomMatch(substrateIndex, productIndex);
                if (bestAtomAtomMapping == null) {
                    throw new CDKException("atom-atom mapping is null");
                }
                carbonCount = bestAtomAtomMapping.getMappingsByAtoms().keySet().stream().filter(atom -> atom.getSymbol().equalsIgnoreCase("C")).map(_item -> 1.0).reduce(carbonCount, (accumulator, _item) -> accumulator + 1.0);
                stereoVal = initMcsAtom.getStereoScore(substrateIndex, productIndex);
                fragmentVal = initMcsAtom.getTotalFragmentCount(substrateIndex, productIndex);
                energyVal = initMcsAtom.getBondEnergy(substrateIndex, productIndex);
                double ACount = educt.getAtomCount();
                double BCount = product.getAtomCount();
                mappingSize = bestAtomAtomMapping.getCount();
                graphSimilarity = mappingSize / (ACount + BCount - mappingSize);
                initMcsAtom.setTotalFragmentCount(substrateIndex, productIndex, fragmentVal);
                initMcsAtom.setBondEnergy(substrateIndex, productIndex, energyVal);
                initMcsAtom.setStereoScore(substrateIndex, productIndex, stereoVal);
                initMcsAtom.setGraphSimilarity(substrateIndex, productIndex, graphSimilarity);
                BitSet a = reactionContainer.getFingerPrintofEduct(substrateIndex);
                BitSet b = reactionContainer.getFingerPrintofProduct(productIndex);
                if (a != null && b != null) {
                    try {
                        fpSim = Similarity.getTanimotoSimilarity(a, b);
                    }
                    catch (Exception ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                }
            }
            holder.getCliqueMatrix().setValue(substrateIndex, productIndex, mappingSize);
            holder.getGraphSimilarityMatrix().setValue(substrateIndex, productIndex, graphSimilarity);
            holder.getStereoMatrix().setValue(substrateIndex, productIndex, stereoVal);
            holder.getCarbonOverlapMatrix().setValue(substrateIndex, productIndex, carbonCount);
            holder.getFragmentMatrix().setValue(substrateIndex, productIndex, fragmentVal);
            holder.getEnergyMatrix().setValue(substrateIndex, productIndex, energyVal);
            holder.getFPSimilarityMatrix().setValue(substrateIndex, productIndex, fpSim);
        }
        catch (CDKException ex) {
            LOGGER.debug(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    synchronized String generateUniqueKey(IAtomContainer compound1, IAtomContainer compound2, String id1, String id2, int atomCount1, int atomCount2, int bondCount1, int bondCount2, boolean atomtypeMatcher, boolean bondMatcher, boolean ringMatcher, boolean hasPerfectRings, int numberOfCyclesEduct, int numberOfCyclesProduct) {
        StringBuilder key = new StringBuilder();
        key.append(id1).append(id2).append(atomCount1).append(atomCount2).append(bondCount1).append(bondCount2).append(atomtypeMatcher).append(bondMatcher).append(ringMatcher).append(hasPerfectRings).append(numberOfCyclesEduct).append(numberOfCyclesProduct);
        try {
            int[] sm1 = this.getCircularFP(compound1);
            int[] sm2 = this.getCircularFP(compound2);
            key.append(Arrays.toString(sm1));
            key.append(Arrays.toString(sm2));
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, "Error in Generating Circular FP: ", ex);
        }
        return key.toString();
    }

    private synchronized int[] getCircularFP(IAtomContainer mol) throws CDKException {
        CircularFingerprinter circularFingerprinter = new CircularFingerprinter(6, 1024);
        circularFingerprinter.setPerceiveStereo(true);
        IBitFingerprint bitFingerprint = circularFingerprinter.getBitFingerprint(mol);
        return bitFingerprint.getSetbits();
    }

    synchronized MCSSolution copyOldSolutionToNew(int queryPosition, int targetPosition, IAtomContainer compound1, IAtomContainer compound2, MCSSolution oldSolution) {
        AtomAtomMapping atomAtomMapping = oldSolution.getAtomAtomMapping();
        Map<Integer, Integer> mappingsByIndex = atomAtomMapping.getMappingsByIndex();
        AtomAtomMapping atomAtomMappingNew = new AtomAtomMapping(compound1, compound2);
        mappingsByIndex.entrySet().forEach(m -> atomAtomMappingNew.put(compound1.getAtom((Integer)m.getKey()), compound2.getAtom((Integer)m.getValue())));
        MCSSolution mcsSolution = new MCSSolution(queryPosition, targetPosition, compound1, compound2, atomAtomMappingNew);
        mcsSolution.setEnergy(oldSolution.getEnergy());
        mcsSolution.setFragmentSize(oldSolution.getFragmentSize());
        mcsSolution.setStereoScore(oldSolution.getStereoScore());
        return mcsSolution;
    }

    synchronized MCSSolution addMCSSolution(int queryPosition, int targetPosition, String key, ThreadSafeCache<String, MCSSolution> mappingcache, Isomorphism isomorphism) {
        isomorphism.setChemFilters(true, true, true);
        MCSSolution mcs = new MCSSolution(queryPosition, targetPosition, isomorphism.getQuery(), isomorphism.getTarget(), isomorphism.getFirstAtomMapping());
        mcs.setEnergy(isomorphism.getEnergyScore(0));
        mcs.setFragmentSize(isomorphism.getFragmentSize(0));
        mcs.setStereoScore(isomorphism.getStereoScore(0));
        if (!mappingcache.containsKey(key)) {
            mappingcache.put(key, mcs);
        }
        return mcs;
    }
}

