/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.io.Serializable;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.mapping.algorithm.CaseHandler;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryFactory;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryMatrix;
import uk.ac.ebi.reactionblast.mapping.container.MoleculeMoleculeMapping;
import uk.ac.ebi.reactionblast.mapping.interfaces.IGameTheory;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;

public class CalculationProcess
extends CaseHandler
implements Serializable {
    private static final boolean DEBUG = false;
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CalculationProcess.class);
    private static final long serialVersionUID = 19876520009L;
    private final boolean removeHydrogen;
    private int delta = 0;
    private MoleculeMoleculeMapping reactionBlastMolMapping;
    private final IMappingAlgorithm algorithm;

    public CalculationProcess(boolean removeHydrogen, IReaction reaction, IMappingAlgorithm algorithm) throws Intractable {
        super(reaction);
        this.removeHydrogen = removeHydrogen;
        LOGGER.debug(NEW_LINE + "|++++++++++++++++++++++++++++|");
        LOGGER.debug("Performing Atom-Atom Mapping ....... " + reaction.getID() + " .......");
        LOGGER.debug(NEW_LINE + "|++++++++++++++++++++++++++++|");
        this.algorithm = algorithm;
        this.run();
    }

    private synchronized void run() {
        switch (this.algorithm) {
            case MIN: {
                LOGGER.debug("Processing Reaction for Local Minimum: ");
                this.delta = (int)this.calRelation(this.reaction, IMappingAlgorithm.MIN);
                break;
            }
            case MAX: {
                LOGGER.debug("Processing Reaction for Global Minimum: ");
                this.delta = (int)this.calRelation(this.reaction, IMappingAlgorithm.MAX);
                break;
            }
            case MIXTURE: {
                LOGGER.debug("Processing Reaction for Max-Mixture Model: ");
                this.delta = (int)this.calRelation(this.reaction, IMappingAlgorithm.MIXTURE);
                break;
            }
            case RINGS: {
                LOGGER.debug("Processing Reaction for Ring Model: ");
                this.delta = (int)this.calRelation(this.reaction, IMappingAlgorithm.RINGS);
            }
        }
    }

    public synchronized IReaction getMappedReaction() {
        return this.reaction;
    }

    private synchronized double calRelation(IReaction reaction, IMappingAlgorithm theory) {
        try {
            SortedMap<Integer, IAtomContainer> educts = Collections.synchronizedSortedMap(new TreeMap());
            for (int i = 0; i < reaction.getReactantCount(); ++i) {
                educts.put(i, reaction.getReactants().getAtomContainer(i));
            }
            SortedMap<Integer, IAtomContainer> products = Collections.synchronizedSortedMap(new TreeMap());
            for (int i = 0; i < reaction.getProductCount(); ++i) {
                products.put(i, reaction.getProducts().getAtomContainer(i));
            }
            GameTheoryMatrix EDSH = new GameTheoryMatrix(theory, reaction, this.removeHydrogen);
            IGameTheory gameTheory = GameTheoryFactory.make(theory, reaction, this.removeHydrogen, educts, products, EDSH);
            this.reactionBlastMolMapping = gameTheory.getReactionMolMapping();
            EDSH.Clear();
            return gameTheory.getDelta();
        }
        catch (Exception e) {
            LOGGER.error(e);
            return -1.0;
        }
    }

    public synchronized int getDelta() {
        return this.delta;
    }

    public synchronized MoleculeMoleculeMapping getReactionBlastMolMapping() {
        return this.reactionBlastMolMapping;
    }
}

