/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smarts.SmartsPattern;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import org.openscience.smsd.tools.Utility;

class CaseHandler {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CaseHandler.class);
    private final Map<IRingSet, IAtomContainer> ringContainerCountR;
    private final Map<IRingSet, IAtomContainer> ringContainerCountP;
    private final IRingSet sssrEduct;
    private final IRingSet sssrProduct;
    private final boolean DEBUG = false;
    protected final IReaction reaction;

    protected static void initializeMolecule(IAtomContainer atomContainer) throws CDKException {
        MoleculeInitializer.initializeMolecule(atomContainer);
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
    }

    CaseHandler(IReaction reaction) throws Intractable {
        boolean bl;
        this.reaction = reaction;
        this.ringContainerCountR = this.getRingContainerCount(reaction.getReactants());
        this.ringContainerCountP = this.getRingContainerCount(reaction.getProducts());
        if (this.ringContainerCountR.size() == 1 && this.ringContainerCountP.size() == 1) {
            IAtomContainer educt = this.ringContainerCountR.values().iterator().next();
            IAtomContainer product = this.ringContainerCountP.values().iterator().next();
            try {
                CaseHandler.initializeMolecule(educt);
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            try {
                CaseHandler.initializeMolecule(product);
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            CycleFinder cf = Cycles.essential();
            Cycles cycles = cf.find(educt);
            this.sssrEduct = cycles.toRingSet();
            cycles = cf.find(product);
            this.sssrProduct = cycles.toRingSet();
            bl = this.chipBondInTheRing(educt, product);
        } else {
            this.sssrEduct = null;
            this.sssrProduct = null;
            IAtomContainerSet reactants = reaction.getReactants();
            IAtomContainerSet products = reaction.getProducts();
            if (reactants.getAtomContainerCount() == 1 && products.getAtomContainerCount() == 1) {
                try {
                    IAtomContainer educt = reactants.atomContainers().iterator().next();
                    IAtomContainer product = products.atomContainers().iterator().next();
                    bl = this.chipPhophateInSingleReactantProductNotInRing(educt, product);
                }
                catch (IOException | CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
        }
        for (IAtomContainer ac1 : reaction.getReactants().atomContainers()) {
            for (IAtomContainer ac2 : reaction.getProducts().atomContainers()) {
                try {
                    this.deleteBonds(ac1, ac2);
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private Map<IRingSet, IAtomContainer> getRingContainerCount(IAtomContainerSet acs) {
        CycleFinder cycles = Cycles.or(Cycles.all(), Cycles.all());
        HashMap<IRingSet, IAtomContainer> ringSet = new HashMap<IRingSet, IAtomContainer>();
        for (IAtomContainer ac : acs.atomContainers()) {
            try {
                Cycles rings = cycles.find(ac);
                IRingSet basicRings = rings.toRingSet();
                if (basicRings.isEmpty()) continue;
                basicRings.setID(ac.getID());
                ringSet.put(basicRings, ac);
            }
            catch (Intractable ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        return ringSet;
    }

    private boolean chipBondInTheRing(IAtomContainer educt, IAtomContainer product) {
        if (this.sssrEduct.getAtomContainerCount() == 1 && this.sssrProduct.getAtomContainerCount() == 1) {
            IAtomContainer ringE = this.sssrEduct.atomContainers().iterator().next();
            IAtomContainer ringP = this.sssrProduct.atomContainers().iterator().next();
            if (ringE.getAtomCount() == 6 && ringP.getAtomCount() == 5) {
                return this.findAndChipBond(ringE, educt);
            }
            if (ringE.getAtomCount() == 5 && ringP.getAtomCount() == 6) {
                return this.findAndChipBond(ringP, product);
            }
        } else if (this.sssrEduct.getAtomContainerCount() == 2 && this.sssrEduct.getAtomContainerCount() == this.sssrProduct.getAtomContainerCount()) {
            return this.findAndChipBondBetweenRings(educt) | this.findAndChipBondBetweenRings(product);
        }
        return false;
    }

    private boolean chipPhophateInSingleReactantProductNotInRing(IAtomContainer educt, IAtomContainer product) throws CDKException, IOException {
        if (this.ringContainerCountR.isEmpty() && this.ringContainerCountP.isEmpty()) {
            String phosphateSMILES = "OP(O)(O)=O";
            SmartsPattern smartsPhosphate = SmartsPattern.create(phosphateSMILES, SilentChemObjectBuilder.getInstance());
            boolean matchesE = smartsPhosphate.matches(educt);
            boolean matchesP = smartsPhosphate.matches(product);
            if (matchesE && matchesP) {
                boolean findAndChipBondPhophate1 = this.findAndChipBondPhophate(educt);
                boolean findAndChipBondPhophate2 = this.findAndChipBondPhophate(product);
                return findAndChipBondPhophate1 && findAndChipBondPhophate2;
            }
        }
        return false;
    }

    private boolean findAndChipBond(IAtomContainer container, IAtomContainer referenceContainer) {
        boolean flag = false;
        if (container != null) {
            for (IBond bond : container.bonds()) {
                if ((!bond.getAtom(0).getSymbol().equalsIgnoreCase("O") || !bond.getAtom(1).getSymbol().equalsIgnoreCase("C")) && (!bond.getAtom(0).getSymbol().equalsIgnoreCase("C") || !bond.getAtom(1).getSymbol().equalsIgnoreCase("O")) || bond.getAtom(0).getFlag(32) || bond.getAtom(1).getFlag(32) || !referenceContainer.contains(bond)) continue;
                IAtom atom = bond.getAtom(0).getSymbol().equalsIgnoreCase("C") ? bond.getAtom(0) : bond.getAtom(1);
                List<IBond> neighbourhoodBonds = referenceContainer.getConnectedBondsList(atom);
                flag = false;
                for (IBond neighbourhoodBond : neighbourhoodBonds) {
                    if (!neighbourhoodBond.contains(atom) || neighbourhoodBond.getFlag(2) || (!neighbourhoodBond.getAtom(0).getSymbol().equalsIgnoreCase("O") || !neighbourhoodBond.getAtom(1).getSymbol().equalsIgnoreCase("C")) && (!neighbourhoodBond.getAtom(0).getSymbol().equalsIgnoreCase("C") || !neighbourhoodBond.getAtom(1).getSymbol().equalsIgnoreCase("O"))) continue;
                    flag = true;
                }
                if (!flag) continue;
                referenceContainer.removeBond(bond);
                break;
            }
        }
        return flag;
    }

    private boolean findAndChipBondPhophate(IAtomContainer container) {
        boolean flag = false;
        for (IBond bond : container.bonds()) {
            IAtom oxygen;
            List<IBond> neighbourBonds;
            IAtom atomE = bond.getAtom(0);
            IAtom atomP = bond.getAtom(1);
            if ((!atomE.getSymbol().equals("O") || !atomP.getSymbol().equals("P")) && (!atomE.getSymbol().equals("P") || !atomP.getSymbol().equals("O")) || !bond.getOrder().equals((Object)IBond.Order.SINGLE) || (neighbourBonds = container.getConnectedBondsList(oxygen = atomE.getSymbol().equals("O") ? atomE : atomP)).size() != 2) continue;
            neighbourBonds.stream().filter(b -> b.getAtom(0).getSymbol().equals("O") || b.getAtom(0).getSymbol().equals("P")).filter(b -> b.getAtom(1).getSymbol().equals("O") || b.getAtom(1).getSymbol().equals("P")).map(b -> {
                container.removeBond((IBond)b);
                return b;
            }).filter(b -> false).map(b -> {
                System.out.println("bondToBeChipped " + b.getAtom(0).getSymbol());
                return b;
            }).map(b -> {
                System.out.println("bondToBeChipped " + b.getAtom(1).getSymbol());
                return b;
            }).forEach(_item -> System.out.println("removeBond o-p "));
            return true;
        }
        return flag;
    }

    private boolean findAndChipBondBetweenRings(IAtomContainer container) {
        ArrayList<IBond> bond_to_be_removed = new ArrayList<IBond>();
        for (IAtom atom : container.atoms()) {
            if (!atom.getSymbol().equals("O") || atom.isAromatic()) continue;
            int number_of_rings = (Integer)atom.getProperty("cdk:RingConnections");
            List<IBond> bonds = container.getConnectedBondsList(atom);
            if (bonds.size() != 2 || number_of_rings != 2) continue;
            IBond bondToBeChipped = bonds.iterator().next();
            bond_to_be_removed.add(bondToBeChipped);
        }
        bond_to_be_removed.stream().map(bond -> {
            container.removeBond((IBond)bond);
            return bond;
        }).filter(bond -> false).forEach(bond -> {
            try {
                System.out.println("CHIPPING BONDS  B0 " + bond.getAtom(0).getSymbol() + " B1 " + bond.getAtom(1).getSymbol());
                System.out.println("CHIPPED SM " + new SmilesGenerator(0).create(container));
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, "Clipping Bonds: ", ex.getMessage());
            }
        });
        return !bond_to_be_removed.isEmpty();
    }

    private boolean deleteBonds(IAtomContainer s, IAtomContainer t) throws InvalidSmilesException, CDKException {
        boolean flag = false;
        return flag |= this.case1(s, t);
    }

    private boolean case1(IAtomContainer s, IAtomContainer t) throws InvalidSmilesException, CDKException {
        String moiety;
        boolean flag = false;
        SmilesParser smilesParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
        IAtomContainer query2 = smilesParser.parseSmiles(moiety = "NC(=O)C1=CN(C=N1)C1OC(COP(O)(O)=O)C(O)C1O");
        if (Utility.isMatch(query2, s, false) && Utility.isMatch(query2, t, false)) {
            IBond bond;
            Map<IAtom, IAtom> map;
            IAtomContainer ac1 = s;
            IAtomContainer ac2 = t;
            Map<IAtom, IAtom> subgraph1 = Utility.findSubgraph(query2, ac1, true, true, true, true);
            Map<IAtom, IAtom> subgraph2 = Utility.findSubgraph(query2, ac2, true, true, true, true);
            if (subgraph1 != null && subgraph2 != null && subgraph1.isEmpty() && subgraph2.isEmpty()) {
                ac1 = t;
                ac2 = s;
                subgraph1 = Utility.findSubgraph(query2, ac1, true, true, true, true);
                subgraph2 = Utility.findSubgraph(query2, ac2, true, true, true, true);
            }
            if (subgraph1 != null && !subgraph1.isEmpty()) {
                map = subgraph1;
                for (IAtom a : map.values()) {
                    for (IAtom b : map.values()) {
                        if (a == b || a.getAtomicNumber() != 6 || b.getAtomicNumber() != 6) continue;
                        bond = ac1.getBond(a, b);
                        ac1.removeBond(bond);
                        flag = true;
                    }
                }
            }
            if (subgraph2 != null && !subgraph2.isEmpty()) {
                map = subgraph2;
                for (IAtom a : map.values()) {
                    for (IAtom b : map.values()) {
                        if (a == b || a.getAtomicNumber() != 6 || b.getAtomicNumber() != 6) continue;
                        bond = ac2.getBond(a, b);
                        ac2.removeBond(bond);
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }

    private static /* synthetic */ void lambda$findAndChipBondBetweenRings$7(IBond bond) {
        System.out.println("BONDS  B0 " + bond.getAtom(0).getSymbol() + " B1 " + bond.getAtom(1).getSymbol());
    }
}

