/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.algorithm.BaseGameTheory;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryMatrix;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.ChooseWinner;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.MaxSelection;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.RuleBasedMappingHandler;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.Selector;
import uk.ac.ebi.reactionblast.mapping.container.MoleculeMoleculeMapping;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.mapping.container.helper.MolMapping;
import uk.ac.ebi.reactionblast.mapping.graph.GraphMatching;
import uk.ac.ebi.reactionblast.mapping.interfaces.AbstractGraphMatching;
import uk.ac.ebi.reactionblast.tools.CDKSMILES;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;
import uk.ac.ebi.reactionblast.tools.labelling.SmilesMoleculeLabeller;

final class GameTheoryMax
extends BaseGameTheory {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 1887868678797L;
    private final List<String> eductList;
    private final List<String> productList;
    private final ChooseWinner winner;
    private final IReaction reaction;
    private final String rid;
    private final String dirSuffix;
    private final boolean removeHydrogen;
    private MoleculeMoleculeMapping reactionMolMapping = null;
    private Map<Integer, IAtomContainer> educts = null;
    private Map<Integer, IAtomContainer> products = null;
    private Holder mh;
    private int delta = 0;
    private Integer stepIndex = 0;
    private final ICanonicalMoleculeLabeller canonLabeler = new SmilesMoleculeLabeller();
    private int counter = 1;

    GameTheoryMax(IReaction reaction, boolean removeHydrogen, Map<Integer, IAtomContainer> _educts, Map<Integer, IAtomContainer> _products, GameTheoryMatrix rpsh) throws Exception {
        this.removeHydrogen = removeHydrogen;
        this.reaction = reaction;
        this.educts = _educts;
        this.products = _products;
        this.rid = reaction.getID();
        this.eductList = Collections.synchronizedList(rpsh.getEductCounter());
        this.productList = Collections.synchronizedList(rpsh.getProductCounter());
        this.mh = rpsh.getMatrixHolder();
        this.setReactionMolMapping(rpsh.getReactionMolMapping());
        this.winner = new ChooseWinner(this.eductList, this.productList);
        this.dirSuffix = super.getSuffix();
        this.GenerateMapping(false);
    }

    private synchronized void GenerateMapping(boolean flag) throws Exception {
        MaxSelection select;
        boolean ruleMatchingFlag = flag;
        ++this.counter;
        boolean conditionmet = false;
        if (!ruleMatchingFlag) {
            RuleBasedMappingHandler ruleBasedMappingHandler = new RuleBasedMappingHandler(this.mh, this.eductList, this.productList);
            if (ruleBasedMappingHandler.isMatchFound()) {
                this.mh = Selector.modifyMatrix(ruleBasedMappingHandler.getMatrixHolder());
                conditionmet = true;
            }
            ruleMatchingFlag = true;
        }
        if (!conditionmet && this.counter <= 5 && (select = new MaxSelection(this.mh, this.eductList, this.productList)).isSubAndCompleteMatchFlag()) {
            this.mh = select.getUpdatedHolder();
        }
        this.winner.searchWinners(this.educts, this.products, this.mh);
        if (this.winner.getFlag()) {
            this.UpdateMapping();
            this.UpdateMatrix(this.mh, this.removeHydrogen);
            this.GenerateMapping(ruleMatchingFlag);
        }
    }

    private synchronized void UpdateMapping() throws Exception {
        boolean[][] FlagMatrix = this.winner.getFlagMatrix();
        ReactionContainer reactionStructureInformation = this.mh.getReactionContainer();
        for (int iIndex = 0; iIndex < reactionStructureInformation.getEductCount(); ++iIndex) {
            for (int jIndex = 0; jIndex < reactionStructureInformation.getProductCount(); ++jIndex) {
                int substrateIndex = iIndex;
                int productIndex = jIndex;
                IAtomContainer ac1 = reactionStructureInformation.getEduct(substrateIndex);
                IAtomContainer ac2 = reactionStructureInformation.getProduct(productIndex);
                if (!FlagMatrix[substrateIndex][productIndex]) continue;
                BitSet A = reactionStructureInformation.getFingerPrintofEduct(substrateIndex);
                BitSet B = reactionStructureInformation.getFingerPrintofProduct(productIndex);
                ac1.setID(this.eductList.get(substrateIndex));
                ac2.setID(this.productList.get(productIndex));
                GraphMatching GM = new GraphMatching(this.rid, ac1, ac2, this.dirSuffix, this.removeHydrogen);
                boolean mcsMatch = ((AbstractGraphMatching)GM).mcsMatch(this.mh, this.removeHydrogen, substrateIndex, productIndex, A, B);
                if (mcsMatch) {
                    this.delta += ((AbstractGraphMatching)GM).removeMatchedAtomsAndUpdateAAM(this.reaction);
                    List<MolMapping> rMap = this.getReactionMolMapping().getMapping(this.rid, this.eductList.get(substrateIndex), this.productList.get(productIndex));
                    rMap.stream().map(map -> {
                        map.setReactionMapping(true);
                        return map;
                    }).forEach(map -> {
                        try {
                            IAtomContainer mol = GM.getMatchedPart();
                            mol = this.canonLabeler.getCanonicalMolecule(mol);
                            CDKSMILES cdkSmiles = new CDKSMILES(mol, true, false);
                            this.stepIndex = this.stepIndex + 1;
                            map.setMatchedSMILES(cdkSmiles.getCanonicalSMILES(), this.stepIndex);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                    });
                }
                IAtomContainer remainingEduct = ((AbstractGraphMatching)GM).getRemainingEduct();
                IAtomContainer remainingProduct = ((AbstractGraphMatching)GM).getRemainingProduct();
                reactionStructureInformation.putEduct(substrateIndex, remainingEduct);
                reactionStructureInformation.putProduct(productIndex, remainingProduct);
                reactionStructureInformation.setEductModified(substrateIndex, true);
                reactionStructureInformation.setProductModified(productIndex, true);
            }
        }
    }

    @Override
    public synchronized MoleculeMoleculeMapping getReactionMolMapping() {
        return this.reactionMolMapping;
    }

    @Override
    public synchronized void setReactionMolMapping(MoleculeMoleculeMapping reactionMolMapping) {
        this.reactionMolMapping = reactionMolMapping;
    }

    @Override
    public synchronized int getDelta() {
        return this.delta;
    }
}

