/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm.checks;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.Selector;
import uk.ac.ebi.reactionblast.mapping.interfaces.IResult;

public class MaxSelection
extends Selector
implements IResult {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MaxSelection.class);
    private static final long serialVersionUID = 108089707097L;
    private final Holder mHolder;
    private final Holder updatedHolder;
    private boolean SubAndCompleteFlag;

    public MaxSelection(Holder mHolder, List<String> EdMapOrignal, List<String> PdMapOrignal) throws IOException, Exception {
        this.mHolder = mHolder;
        this.updatedHolder = (Holder)mHolder.clone();
        this.rowSize = mHolder.getCliqueMatrix().getRowDimension();
        this.colSize = mHolder.getCliqueMatrix().getColumnDimension();
        this.flagMatrix = new boolean[this.rowSize][this.colSize];
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.colSize; ++j) {
                this.flagMatrix[i][j] = false;
            }
        }
        try {
            this.PhaseOneMatcher();
            this.SubAndCompleteFlag = this.PhaseTwoMatcher();
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    private synchronized void PhaseOneMatcher() throws IOException, CDKException {
        for (int i = 0; i < this.rowSize; ++i) {
            IAtomContainer ac1 = this.mHolder.getReactionContainer().getEduct(i);
            for (int j = 0; j < this.colSize; ++j) {
                IAtomContainer ac2 = this.mHolder.getReactionContainer().getProduct(j);
                double cliqueVal = this.mHolder.getCliqueMatrix().getValue(i, j);
                double simVal = this.mHolder.getGraphSimilarityMatrix().getValue(i, j);
                if (!(cliqueVal > 0.0)) continue;
                boolean maxValueI = this.isMajorSubgraphRow(this.mHolder, i, j);
                boolean maxValueJ = this.isMajorSubgraphColumn(this.mHolder, i, j);
                if (maxValueI || maxValueJ) {
                    if (!(simVal > 0.0) || ac1 == null || ac2 == null) continue;
                    int eMolSize = ac1.getAtomCount();
                    int pMolSize = ac2.getAtomCount();
                    if (eMolSize == 1 && pMolSize == 1 && ac1.atoms().iterator().next().getSymbol().equals(ac2.atoms().iterator().next().getSymbol())) {
                        this.flagMatrix[i][j] = true;
                        continue;
                    }
                    if (eMolSize > 1 && pMolSize > 1 && ac1.getAtomCount() <= ac2.getAtomCount() && this.isMCSSubgraph(ac1, this.mHolder.getCliqueMatrix().getValue(i, j))) {
                        this.flagMatrix[i][j] = true;
                        continue;
                    }
                    if (eMolSize > 1 && pMolSize > 1 && ac2.getAtomCount() <= ac1.getAtomCount() && this.isMCSSubgraph(ac2, this.mHolder.getCliqueMatrix().getValue(i, j))) {
                        this.flagMatrix[i][j] = true;
                        continue;
                    }
                    this.flagMatrix[i][j] = false;
                    this.updatedHolder.getGraphSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.updatedHolder.getCliqueMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.updatedHolder.getStereoMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.updatedHolder.getCarbonOverlapMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.updatedHolder.getFragmentMatrix().setValue(i, j, Double.MAX_VALUE);
                    this.updatedHolder.getEnergyMatrix().setValue(i, j, Double.MAX_VALUE);
                    this.updatedHolder.getFPSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                    continue;
                }
                this.flagMatrix[i][j] = false;
                this.updatedHolder.getGraphSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getCliqueMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getStereoMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getCarbonOverlapMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getFragmentMatrix().setValue(i, j, Double.MAX_VALUE);
                this.updatedHolder.getEnergyMatrix().setValue(i, j, Double.MAX_VALUE);
                this.updatedHolder.getFPSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
            }
        }
    }

    private synchronized boolean PhaseTwoMatcher() throws IOException, CDKException {
        boolean flag = false;
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.colSize; ++j) {
                double cliqueVal = this.updatedHolder.getCliqueMatrix().getValue(i, j);
                double simVal = this.updatedHolder.getGraphSimilarityMatrix().getValue(i, j);
                if (simVal == 1.0 || !(cliqueVal >= 1.0)) continue;
                if (this.flagMatrix[i][j]) {
                    flag = true;
                    continue;
                }
                this.updatedHolder.getGraphSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getCliqueMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getStereoMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getCarbonOverlapMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getFragmentMatrix().setValue(i, j, Double.MAX_VALUE);
                this.updatedHolder.getEnergyMatrix().setValue(i, j, Double.MAX_VALUE);
                this.updatedHolder.getFPSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
            }
        }
        return flag;
    }

    private synchronized boolean isMCSSubgraph(IAtomContainer educt, double mcsSize) throws CDKException {
        return (double)educt.getAtomCount() == mcsSize;
    }

    @Override
    public synchronized boolean isSubAndCompleteMatchFlag() {
        return this.SubAndCompleteFlag;
    }

    @Override
    public synchronized Holder getUpdatedHolder() {
        return this.updatedHolder;
    }
}

