/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm.checks;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.Selector;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.mapping.interfaces.IResult;

public class MinSelection
extends Selector
implements IResult {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MinSelection.class);
    private static final long serialVersionUID = 1908987778L;
    private final Holder mHolder;
    private final Holder updatedHolder;
    private boolean isSubstructure;

    public MinSelection(Holder mHolder, List<String> EdMapOrignal, List<String> PdMapOrignal) throws IOException, CloneNotSupportedException {
        this.mHolder = mHolder;
        this.updatedHolder = (Holder)mHolder.clone();
        this.rowSize = mHolder.getCliqueMatrix().getRowDimension();
        this.colSize = mHolder.getCliqueMatrix().getColumnDimension();
        try {
            this.PhaseOneMatcher();
            this.isSubstructure = this.PhaseTwoMatcher();
        }
        catch (IOException | CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    private synchronized void PhaseOneMatcher() throws IOException, CDKException {
        int i;
        this.flagMatrix = new boolean[this.rowSize][this.colSize];
        for (i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.colSize; ++j) {
                this.flagMatrix[i][j] = false;
            }
        }
        for (i = 0; i < this.rowSize; ++i) {
            IAtomContainer ac1 = this.mHolder.getReactionContainer().getEduct(i);
            for (int j = 0; j < this.colSize; ++j) {
                double simVal;
                IAtomContainer ac2 = this.mHolder.getReactionContainer().getProduct(j);
                double cliqueVal = this.mHolder.getCliqueMatrix().getValue(i, j);
                if (!(cliqueVal > 0.0) || !((simVal = this.mHolder.getGraphSimilarityMatrix().getValue(i, j)) > 0.0) || ac1 == null || ac2 == null) continue;
                int eMolSize = ac1.getAtomCount();
                int pMolSize = ac2.getAtomCount();
                if (eMolSize == 1 && pMolSize == 1 && ac1.atoms().iterator().next().getSymbol().equals(ac2.atoms().iterator().next().getSymbol())) {
                    this.flagMatrix[i][j] = true;
                    continue;
                }
                if (eMolSize > 1 && pMolSize > 1 && ac1.getAtomCount() <= ac2.getAtomCount() && this.isMCSSubgraph(ac1, this.mHolder.getCliqueMatrix().getValue(i, j))) {
                    this.flagMatrix[i][j] = true;
                    continue;
                }
                if (eMolSize > 1 && pMolSize > 1 && ac2.getAtomCount() <= ac1.getAtomCount() && this.isMCSSubgraph(ac2, this.mHolder.getCliqueMatrix().getValue(i, j))) {
                    this.flagMatrix[i][j] = true;
                    continue;
                }
                this.flagMatrix[i][j] = false;
                this.updatedHolder.getGraphSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getCliqueMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getStereoMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getCarbonOverlapMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getFragmentMatrix().setValue(i, j, Double.MAX_VALUE);
                this.updatedHolder.getEnergyMatrix().setValue(i, j, Double.MAX_VALUE);
                this.updatedHolder.getFPSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
            }
        }
    }

    private synchronized boolean PhaseTwoMatcher() throws IOException, CDKException {
        boolean flag = false;
        for (int i = 0; i < this.rowSize; ++i) {
            IAtomContainer ac1 = this.updatedHolder.getReactionContainer().getEduct(i);
            for (int j = 0; j < this.colSize; ++j) {
                IAtomContainer ac2 = this.updatedHolder.getReactionContainer().getProduct(j);
                double graphSim = this.updatedHolder.getGraphSimilarityMatrix().getValue(i, j);
                if (!this.flagMatrix[i][j]) continue;
                double eMolSize = ac1.getAtomCount();
                double pMolSize = ac2.getAtomCount();
                if (!(eMolSize > 0.0) || !(pMolSize > 0.0) || !(graphSim > 0.0)) continue;
                boolean isMinorSubgraphColumn = this.isMinorSubgraphColumn(this.updatedHolder, i, j);
                boolean isMinorSubgraphRow = this.isMinorSubgraphRow(this.updatedHolder, i, j);
                if (isMinorSubgraphColumn && isMinorSubgraphRow) {
                    double updatedGraphSimScore = 1.01 - this.mHolder.getGraphSimilarityMatrix().getValue(i, j);
                    double updatedFPSimScore = 1.01 - this.mHolder.getFPSimilarityMatrix().getValue(i, j);
                    this.updatedHolder.getGraphSimilarityMatrix().setValue(i, j, updatedGraphSimScore);
                    this.updatedHolder.getFPSimilarityMatrix().setValue(i, j, updatedFPSimScore);
                    flag = true;
                    continue;
                }
                this.updatedHolder.getGraphSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                this.updatedHolder.getFPSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
            }
        }
        return flag;
    }

    @Override
    public synchronized boolean isSubAndCompleteMatchFlag() {
        return this.isSubstructure;
    }

    private synchronized boolean isMCSSubgraph(IAtomContainer educt, double mcsSize) throws CDKException {
        return Double.valueOf(educt.getAtomCount()) == mcsSize;
    }

    @Override
    public synchronized Holder getUpdatedHolder() {
        return this.updatedHolder;
    }

    static void printSimMatrix(Holder mh) {
        ReactionContainer reactionStructureInformationContainer = mh.getReactionContainer();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Similarity Matrix");
            System.out.print("\t\t");
            for (int j = 0; j < reactionStructureInformationContainer.getProductCount(); ++j) {
                System.out.print(" " + reactionStructureInformationContainer.getProduct(j).getID() + ":(" + reactionStructureInformationContainer.getProduct(j).getAtomCount() + ")");
            }
            System.out.println();
            double val = 0.0;
            for (int i = 0; i < reactionStructureInformationContainer.getEductCount(); ++i) {
                System.out.print(" " + reactionStructureInformationContainer.getEduct(i).getID() + ":(" + reactionStructureInformationContainer.getEduct(i).getAtomCount() + ")");
                for (int j = 0; j < reactionStructureInformationContainer.getProductCount(); ++j) {
                    val = mh.getGraphSimilarityMatrix().getValue(i, j);
                    String result = format.format(val);
                    System.out.print("   " + result);
                }
                System.out.println();
            }
        }
        catch (IOException | CDKException e) {
            LOGGER.debug(" Parser Error: ");
        }
        System.out.println();
    }

    static void printCliqueMatrix(Holder mh) {
        ReactionContainer reactionStructureInformationContainer = mh.getReactionContainer();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Clique Matrix");
            System.out.print("\t\t");
            for (int j = 0; j < reactionStructureInformationContainer.getProductCount(); ++j) {
                System.out.print(" " + reactionStructureInformationContainer.getProduct(j).getID() + ":(" + reactionStructureInformationContainer.getProduct(j).getAtomCount() + ")");
            }
            System.out.println();
            double val = 0.0;
            for (int i = 0; i < reactionStructureInformationContainer.getEductCount(); ++i) {
                System.out.print(" " + reactionStructureInformationContainer.getEduct(i).getID() + ":(" + reactionStructureInformationContainer.getEduct(i).getAtomCount() + ")");
                for (int j = 0; j < reactionStructureInformationContainer.getProductCount(); ++j) {
                    val = mh.getCliqueMatrix().getValue(i, j);
                    String result = format.format(val);
                    System.out.print("   " + result);
                }
                System.out.println();
            }
        }
        catch (IOException | CDKException e) {
            LOGGER.debug(" Parser Error: ");
        }
        System.out.println();
    }

    static void printFLAGMatrix(Holder mh, boolean[][] flagMatrix) {
        ReactionContainer reactionStructureInformationContainer = mh.getReactionContainer();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            System.out.println("Flag Matrix");
            System.out.print("\t\t");
            for (int j = 0; j < reactionStructureInformationContainer.getProductCount(); ++j) {
                System.out.print(" " + reactionStructureInformationContainer.getProduct(j).getID() + ":(" + reactionStructureInformationContainer.getProduct(j).getAtomCount() + ")");
            }
            System.out.println();
            for (int i = 0; i < reactionStructureInformationContainer.getEductCount(); ++i) {
                System.out.print(" " + reactionStructureInformationContainer.getEduct(i).getID() + ":(" + reactionStructureInformationContainer.getEduct(i).getAtomCount() + ")");
                for (int j = 0; j < reactionStructureInformationContainer.getProductCount(); ++j) {
                    System.out.print("   " + flagMatrix[i][j]);
                }
                System.out.println();
            }
        }
        catch (IOException | CDKException e) {
            LOGGER.error("Parser Error", e.getMessage());
        }
        System.out.println();
    }
}

