/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm.checks;

import java.io.Serializable;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.smsd.Substructure;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;

public class ReactionIsomorphismHandler
implements Serializable {
    private static final long serialVersionUID = 7877865433123231L;
    private int rowSize = -1;
    private int colSize = -1;
    private boolean[][] flagSimilarityMatrix = null;
    private boolean[][] flagStereoMatrix = null;
    private boolean isomorphismFlag;
    private Holder matrixHolder;
    private final Holder matrixHolderWithSimilarityCheck;
    private final Holder matrixHolderWithStereoCheck;

    public ReactionIsomorphismHandler(Holder mHolder, List<String> EdMapOrignal, List<String> PdMapOrignal) throws Exception {
        this.matrixHolder = mHolder;
        this.matrixHolderWithSimilarityCheck = (Holder)mHolder.clone();
        this.matrixHolderWithStereoCheck = (Holder)mHolder.clone();
        this.isomorphismFlag = false;
        this.rowSize = this.matrixHolder.getCliqueMatrix().getRowDimension();
        this.colSize = this.matrixHolder.getCliqueMatrix().getColumnDimension();
        if (this.rowSize > 1 && this.rowSize == this.colSize) {
            this.setReactionMappingFlags();
            boolean flag1 = this.checkSimilarityWithStereo();
            boolean flag2 = this.checkSimilarityWithFingerprint();
            if (flag1 && !flag2) {
                this.isomorphismFlag = true;
                this.matrixHolder = this.matrixHolderWithStereoCheck;
            } else if (flag1 && flag2) {
                this.isomorphismFlag = true;
                this.matrixHolder = this.matrixHolderWithSimilarityCheck;
            }
        }
    }

    private synchronized boolean checkSimilarityWithStereo() {
        boolean stSimilarity;
        block5: {
            int i;
            boolean ColT;
            block4: {
                stSimilarity = false;
                boolean RowT = true;
                ColT = true;
                for (i = 0; i < this.rowSize; ++i) {
                    if (this.flagStereoMatrix[i][i]) continue;
                    RowT = false;
                    break;
                }
                for (i = this.rowSize - 1; i >= 0; --i) {
                    if (this.flagStereoMatrix[i][i]) continue;
                    ColT = false;
                    break;
                }
                if (!RowT) break block4;
                stSimilarity = true;
                for (i = 0; i < this.rowSize; ++i) {
                    this.matrixHolderWithStereoCheck.getGraphSimilarityMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithStereoCheck.getCliqueMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithStereoCheck.getStereoMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithStereoCheck.getCarbonOverlapMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithStereoCheck.getFragmentMatrix().set(i, i, Double.MAX_VALUE);
                    this.matrixHolderWithStereoCheck.getEnergyMatrix().set(i, i, Double.MAX_VALUE);
                }
                break block5;
            }
            if (!ColT) break block5;
            stSimilarity = true;
            for (i = this.rowSize - 1; i >= 0; --i) {
                this.matrixHolderWithStereoCheck.getGraphSimilarityMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithStereoCheck.getCliqueMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithStereoCheck.getStereoMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithStereoCheck.getCarbonOverlapMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithStereoCheck.getFragmentMatrix().set(i, i, Double.MAX_VALUE);
                this.matrixHolderWithStereoCheck.getEnergyMatrix().set(i, i, Double.MAX_VALUE);
            }
        }
        return stSimilarity;
    }

    private synchronized boolean checkSimilarityWithFingerprint() {
        boolean fpFlag;
        block5: {
            int i;
            boolean ColT;
            block4: {
                fpFlag = false;
                boolean RowT = true;
                ColT = true;
                for (i = 0; i < this.rowSize; ++i) {
                    if (this.flagSimilarityMatrix[i][i]) continue;
                    RowT = false;
                    break;
                }
                for (i = this.rowSize - 1; i >= 0; --i) {
                    if (this.flagSimilarityMatrix[i][i]) continue;
                    ColT = false;
                    break;
                }
                if (!RowT) break block4;
                fpFlag = true;
                for (i = 0; i < this.rowSize; ++i) {
                    this.matrixHolderWithSimilarityCheck.getGraphSimilarityMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithSimilarityCheck.getCliqueMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithSimilarityCheck.getStereoMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithStereoCheck.getCarbonOverlapMatrix().setValue(i, i, Double.MIN_VALUE);
                    this.matrixHolderWithSimilarityCheck.getFragmentMatrix().set(i, i, Double.MAX_VALUE);
                    this.matrixHolderWithSimilarityCheck.getEnergyMatrix().set(i, i, Double.MAX_VALUE);
                }
                break block5;
            }
            if (!ColT) break block5;
            fpFlag = true;
            for (i = this.rowSize - 1; i >= 0; --i) {
                this.matrixHolderWithSimilarityCheck.getGraphSimilarityMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithSimilarityCheck.getCliqueMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithSimilarityCheck.getStereoMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithStereoCheck.getCarbonOverlapMatrix().setValue(i, i, Double.MIN_VALUE);
                this.matrixHolderWithSimilarityCheck.getFragmentMatrix().set(i, i, Double.MAX_VALUE);
                this.matrixHolderWithSimilarityCheck.getEnergyMatrix().set(i, i, Double.MAX_VALUE);
            }
        }
        return fpFlag;
    }

    private synchronized void setReactionMappingFlags() throws Exception {
        int j;
        int i;
        this.flagSimilarityMatrix = new boolean[this.rowSize][this.colSize];
        this.flagStereoMatrix = new boolean[this.rowSize][this.colSize];
        for (i = 0; i < this.rowSize; ++i) {
            for (j = 0; j < this.colSize; ++j) {
                this.flagSimilarityMatrix[i][j] = false;
                this.flagStereoMatrix[i][j] = false;
            }
        }
        for (i = 0; i < this.rowSize; ++i) {
            for (j = 0; j < this.colSize; ++j) {
                IAtomContainer ac1 = this.matrixHolder.getReactionContainer().getEduct(i);
                IAtomContainer ac2 = this.matrixHolder.getReactionContainer().getProduct(j);
                if (this.matrixHolder.getFPSimilarityMatrix().getValue(i, j) != 1.0 || AtomContainerManipulator.getTotalFormalCharge(ac1) != AtomContainerManipulator.getTotalFormalCharge(ac2)) continue;
                try {
                    AtomMatcher atomMatcher = AtomBondMatcher.atomMatcher(true, true);
                    BondMatcher bondMatcher = AtomBondMatcher.bondMatcher(true, true);
                    Substructure isomorphism = new Substructure(ac1, ac2, atomMatcher, bondMatcher, false);
                    if (isomorphism.isSubgraph()) {
                        isomorphism.setChemFilters(true, true, true);
                        if (isomorphism.getTanimotoSimilarity() == 1.0 && !isomorphism.isStereoMisMatch()) {
                            this.flagStereoMatrix[i][j] = true;
                        }
                    }
                }
                catch (Exception ex) {
                    this.flagStereoMatrix[i][j] = false;
                }
                this.flagSimilarityMatrix[i][j] = true;
            }
        }
    }

    public synchronized boolean getIsomorphismFlag() {
        return this.isomorphismFlag;
    }

    public synchronized Holder getMatrixHolder() {
        return this.matrixHolder;
    }

    public synchronized void setMatrixHolder(Holder matrixHolder) {
        this.matrixHolder = matrixHolder;
    }
}

