/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm.checks;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import org.openscience.smsd.tools.Utility;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;

public final class RuleBasedMappingHandler
implements Serializable {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final boolean DEBUG1 = false;
    private static final boolean DEBUG2 = false;
    private static final long serialVersionUID = 88765671L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(RuleBasedMappingHandler.class);
    private boolean ruleMatched = false;
    private Holder matrixHolder;
    private Holder matrixHolderClone;
    private final Map<Integer, Integer> matchedRowColoumn;
    private IAtomContainer smartsWater;
    private IAtomContainer smartsPhosphate;
    private IAtomContainer smartsSulphate;
    private IAtomContainer smartsL_Glutamate;
    private IAtomContainer smartsL_Glutamine;
    private IAtomContainer smartsL_Glutamine_clipped;
    private IAtomContainer smartsL_Glutamate_clipped;
    private IAtomContainer smartsTwoOxoglutarate;
    private IAtomContainer smartsD_Glutamate;
    private IAtomContainer smartsAcetate;
    private IAtomContainer smartsATP;
    private IAtomContainer smartsADP;
    private IAtomContainer smartsCoA;
    private IAtomContainer smartsAcetyl_CoA;
    private IAtomContainer smartsC00003;
    private IAtomContainer smartsC00006;
    private IAtomContainer smartsC00004;
    private IAtomContainer smartsC00005;
    private IAtomContainer smartsPyruvate;
    private IAtomContainer smartsAlanine;
    private IAtomContainer smartsNRule;
    private IAtomContainer smartsCRule;
    private IAtomContainer smartsDoublePhosphate;
    private IAtomContainer smartsC04666Rule;
    private IAtomContainer smartsC04916Rule;

    public RuleBasedMappingHandler(Holder matrixHolder, List<String> EdMapOrignal, List<String> PdMapOrignal) throws CDKException, IOException {
        this.setRulesSmiles();
        this.matrixHolder = matrixHolder;
        this.matchedRowColoumn = new HashMap<Integer, Integer>();
        this.setRuleMatched(false);
        int smallestMatchedReactant = Integer.MAX_VALUE;
        int smallestMatchedProduct = Integer.MAX_VALUE;
        for (int i = 0; i < this.matrixHolder.getReactionContainer().getEductCount(); ++i) {
            IAtomContainer ac1 = new AtomContainer(this.matrixHolder.getReactionContainer().getEduct(i));
            if ((ac1 = ExtAtomContainerManipulator.removeHydrogens(ac1)).getAtomCount() < this.getSmartsPhosphate().getAtomCount() && ac1.getAtomCount() < this.getSmartsSulphate().getAtomCount() || !Utility.isMatch(this.getSmartsPhosphate(), ac1, false) && !Utility.isMatch(this.getSmartsSulphate(), ac1, false) || smallestMatchedReactant <= ac1.getAtomCount()) continue;
            smallestMatchedReactant = ac1.getAtomCount();
        }
        for (int j = 0; j < this.matrixHolder.getReactionContainer().getProductCount(); ++j) {
            IAtomContainer ac2 = new AtomContainer(this.matrixHolder.getReactionContainer().getProduct(j));
            if ((ac2 = ExtAtomContainerManipulator.removeHydrogens(ac2)).getAtomCount() < this.getSmartsPhosphate().getAtomCount() && ac2.getAtomCount() < this.getSmartsSulphate().getAtomCount() || !Utility.isMatch(this.getSmartsPhosphate(), ac2, false) && !Utility.isMatch(this.getSmartsSulphate(), ac2, false) || smallestMatchedProduct <= ac2.getAtomCount()) continue;
            smallestMatchedProduct = ac2.getAtomCount();
        }
        boolean phosphate_changed = this.phosphate_cleaved(this.matrixHolder.getReactionContainer().getEducts(), this.matrixHolder.getReactionContainer().getProducts());
        try {
            for (int i = 0; i < this.matrixHolder.getReactionContainer().getEductCount(); ++i) {
                IAtomContainer educt = this.matrixHolder.getReactionContainer().getEduct(i);
                IAtomContainer ac1 = new AtomContainer(educt);
                ac1 = ExtAtomContainerManipulator.removeHydrogens(ac1);
                for (int j = 0; j < this.matrixHolder.getReactionContainer().getProductCount(); ++j) {
                    IAtomContainer product = this.matrixHolder.getReactionContainer().getProduct(j);
                    IAtomContainer ac2 = new AtomContainer(product);
                    ac2 = ExtAtomContainerManipulator.removeHydrogens(ac2);
                    if (this.matrixHolder.getCliqueMatrix().getValue(i, j) == 0.0) continue;
                    if (phosphate_changed && ac1.getAtomCount() == 1 && Utility.isMatch(this.getSmartsWater(), ac1, false) && Utility.isMatch(this.getSmartsPhosphate(), ac2, false) && !Utility.isMatch(this.getSmartsDoublePhosphate(), ac2, false) && ac2.getAtomCount() == smallestMatchedProduct) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                    }
                    if (phosphate_changed && ac2.getAtomCount() == 1 && Utility.isMatch(this.getSmartsWater(), ac2, false) && Utility.isMatch(this.getSmartsPhosphate(), ac1, false) && !Utility.isMatch(this.getSmartsDoublePhosphate(), ac1, false) && ac1.getAtomCount() == smallestMatchedReactant) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                    }
                    if (ac1.getAtomCount() == 1 && Utility.isMatch(this.getSmartsWater(), ac1, false) && Utility.isMatch(this.getSmartsSulphate(), ac2, false) && ac2.getAtomCount() == smallestMatchedProduct) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac2.getAtomCount() == 1 && Utility.isMatch(this.getSmartsWater(), ac2, false) && Utility.isMatch(this.getSmartsSulphate(), ac1, false) && ac1.getAtomCount() == smallestMatchedReactant) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (Utility.isMatch(this.getSmartsC04666Rule(), ac1, false) && Utility.isMatch(this.getSmartsC04916Rule(), ac2, false) || Utility.isMatch(this.getSmartsC04916Rule(), ac1, false) && Utility.isMatch(this.getSmartsC04666Rule(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && Utility.isMatch(this.getSmartsGlutamate(), ac1, false) && Utility.isMatch(this.getSmartsGlutamine(), ac2, false) || ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && Utility.isMatch(this.getSmartsGlutamine(), ac1, false) && Utility.isMatch(this.getSmartsGlutamate(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && Utility.isMatch(this.getSmartsGlutamateClipped(), ac1, false) && Utility.isMatch(this.getSmartsGlutamineClipped(), ac2, false) || ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && Utility.isMatch(this.getSmartsGlutamineClipped(), ac1, false) && Utility.isMatch(this.getSmartsGlutamateClipped(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac2.getAtomCount() == 10 && ac1.getAtomCount() == 10 && Utility.isMatch(this.getSmartsTwoOxoglutarate(), ac2, false) && Utility.isMatch(this.getSmartsD_Glutamate(), ac1, false) || ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && Utility.isMatch(this.getSmartsTwoOxoglutarate(), ac1, false) && Utility.isMatch(this.getSmartsD_Glutamate(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == 1 && Utility.isMatch(this.getSmartsWater(), ac1, false) && ac2.getAtomCount() == this.getSmartsAcetate().getAtomCount() && Utility.isMatch(this.getSmartsAcetate(), ac2, false) || ac2.getAtomCount() == 1 && Utility.isMatch(this.getSmartsWater(), ac2, false) && ac1.getAtomCount() == this.getSmartsAcetate().getAtomCount() && Utility.isMatch(this.getSmartsAcetate(), ac1, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsATP().getAtomCount() && Utility.isMatch(this.getSmartsATP(), ac1, false) && Utility.isMatch(this.getSmartsADP(), ac2, false) || ac1.getAtomCount() == this.getSmartsADP().getAtomCount() && Utility.isMatch(this.getSmartsADP(), ac1, false) && Utility.isMatch(this.getSmartsATP(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsCoA().getAtomCount() && Utility.isMatch(this.getSmartsCoA(), ac1, false) && Utility.isMatch(this.getSmartsAcetyl_CoA(), ac2, false) || ac1.getAtomCount() == this.getSmartsAcetyl_CoA().getAtomCount() && Utility.isMatch(this.getSmartsAcetyl_CoA(), ac1, false) && Utility.isMatch(this.getSmartsCoA(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsC00003().getAtomCount() && Utility.isMatch(this.getSmartsC00003(), ac1, false) && Utility.isMatch(this.getSmartsC00006(), ac2, false) || ac1.getAtomCount() == this.getSmartsC00006().getAtomCount() && Utility.isMatch(this.getSmartsC00006(), ac1, false) && Utility.isMatch(this.getSmartsC00003(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsC00004().getAtomCount() && Utility.isMatch(this.getSmartsC00004(), ac1, false) && Utility.isMatch(this.getSmartsC00005(), ac2, false) || ac1.getAtomCount() == this.getSmartsC00005().getAtomCount() && Utility.isMatch(this.getSmartsC00005(), ac1, false) && Utility.isMatch(this.getSmartsC00004(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsPyruvate().getAtomCount() && Utility.isMatch(this.getSmartsPyruvate(), ac1, false) && Utility.isMatch(this.getSmartsAlanine(), ac2, false) || ac1.getAtomCount() == this.getSmartsAlanine().getAtomCount() && Utility.isMatch(this.getSmartsAlanine(), ac1, false) && Utility.isMatch(this.getSmartsPyruvate(), ac2, false)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if ((!Utility.isMatch(this.getSmartsNRule(), ac1, false) || !Utility.isMatch(this.getSmartsCRule(), ac2, false)) && (!Utility.isMatch(this.getSmartsCRule(), ac1, false) || !Utility.isMatch(this.getSmartsNRule(), ac2, false))) continue;
                    this.setRuleMatched(true);
                    this.matchedRowColoumn.put(i, j);
                }
            }
        }
        catch (IOException | CDKException ex) {
            LOGGER.error(Level.WARNING, "Error in Matching Rules", ex);
        }
        if (this.isMatchFound()) {
            try {
                this.matrixHolderClone = (Holder)matrixHolder.clone();
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("ERROR: Matrix Holder clone error");
                LOGGER.error(Level.SEVERE, null, ex);
            }
            for (int i = 0; i < this.matrixHolder.getReactionContainer().getEductCount(); ++i) {
                for (int j = 0; j < this.matrixHolder.getReactionContainer().getProductCount(); ++j) {
                    if (this.matchedRowColoumn.containsKey(i) && this.matchedRowColoumn.get(i) == j) {
                        this.matrixHolderClone.getGraphSimilarityMatrix().setValue(i, j, 1.0);
                        continue;
                    }
                    this.matrixHolderClone.getGraphSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.matrixHolderClone.getCliqueMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.matrixHolderClone.getStereoMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.matrixHolderClone.getCarbonOverlapMatrix().setValue(i, j, Double.MIN_VALUE);
                    this.matrixHolderClone.getFragmentMatrix().setValue(i, j, Double.MAX_VALUE);
                    this.matrixHolderClone.getEnergyMatrix().setValue(i, j, Double.MAX_VALUE);
                    this.matrixHolderClone.getFPSimilarityMatrix().setValue(i, j, Double.MIN_VALUE);
                }
            }
            this.matrixHolder = this.matrixHolderClone;
        }
    }

    public synchronized Holder getMatrixHolder() {
        return this.matrixHolder;
    }

    public synchronized boolean isMatchFound() {
        return this.ruleMatched;
    }

    private synchronized void setRuleMatched(boolean ruleMatched) {
        this.ruleMatched = ruleMatched;
    }

    private void setRulesSmiles() throws CDKException {
        String waterSMILES = "O";
        String phosphateSMILES = "OP(O)(O)=O";
        String double_phosphateSMILES = "OP(O)(=O)OP(O)(O)=O";
        String acetate = "CC(O)=O";
        String sulphateSMILES = "O=S(=O)(O)O";
        String lGlutamate = "N[C@@H](CCC(O)=O)C(O)=O";
        String lGlutamine = "N[C@@H](CCC(N)=O)C(O)=O";
        String lGlutamate_clipped = "O=[C]O.O=C(O)C(N)C[CH2]";
        String lGlutamine_clipped = "O=[C]N.O=C(O)C(N)C[CH2]";
        String twoOxoglutarate = "OC(=O)CCC(=O)C(O)=O";
        String dGlutamate = "N[C@H](CCC(O)=O)C(O)=O";
        String ATP = "NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O";
        String ADP = "NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O";
        String CoA = "CC(C)(COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N)[C@@H](O)C(=O)NCCC(=O)NCCS";
        String Acetyl_CoA = "CC(=O)SCCNC(=O)CCNC(=O)[C@H](O)C(C)(C)COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N";
        String C00003 = "NC(=O)C1=CC=C[N+](=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C(N)N=CN=C23)[C@@H](O)[C@H]1O";
        String C00006 = "NC(=O)C1=C[N+](=CC=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O";
        String C00004 = "NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O";
        String C00005 = "NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O";
        String C00022 = "[CH3][C](=O)C(O)=O";
        String C00041 = "[CH3][C](N)C(O)=O";
        String N = "CC(C)[C@H](N)C(O)=O";
        String C2 = "CC(C)C(=O)C(O)=O";
        String smartsC04666 = "O=P(O)(O)O[CH2].[CH]O.O[CH]C=1N=CNC1";
        String smartsC04916 = "O=C(N)C=1N=CN(C1N=CNCC(=O)[CH]O)C(O[CH])C(O)[CH]O.O=P(O)(O)O[CH2].O=P(O)(O)O[CH2].[CH]O";
        SmilesParser smilesParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
        this.smartsWater = smilesParser.parseSmiles("O");
        this.smartsPhosphate = smilesParser.parseSmiles("OP(O)(O)=O");
        this.smartsDoublePhosphate = smilesParser.parseSmiles("OP(O)(=O)OP(O)(O)=O");
        this.smartsSulphate = smilesParser.parseSmiles("O=S(=O)(O)O");
        this.smartsL_Glutamate = smilesParser.parseSmiles("N[C@@H](CCC(O)=O)C(O)=O");
        this.smartsL_Glutamine = smilesParser.parseSmiles("N[C@@H](CCC(N)=O)C(O)=O");
        this.smartsL_Glutamine_clipped = smilesParser.parseSmiles("O=[C]N.O=C(O)C(N)C[CH2]");
        this.smartsL_Glutamate_clipped = smilesParser.parseSmiles("O=[C]O.O=C(O)C(N)C[CH2]");
        this.smartsTwoOxoglutarate = smilesParser.parseSmiles("OC(=O)CCC(=O)C(O)=O");
        this.smartsD_Glutamate = smilesParser.parseSmiles("N[C@H](CCC(O)=O)C(O)=O");
        this.smartsAcetate = smilesParser.parseSmiles("CC(O)=O");
        this.smartsATP = smilesParser.parseSmiles("NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O");
        this.smartsADP = smilesParser.parseSmiles("NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O");
        this.smartsCoA = smilesParser.parseSmiles("CC(C)(COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N)[C@@H](O)C(=O)NCCC(=O)NCCS");
        this.smartsAcetyl_CoA = smilesParser.parseSmiles("CC(=O)SCCNC(=O)CCNC(=O)[C@H](O)C(C)(C)COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N");
        this.smartsC00003 = smilesParser.parseSmiles("NC(=O)C1=CC=C[N+](=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C(N)N=CN=C23)[C@@H](O)[C@H]1O");
        this.smartsC00006 = smilesParser.parseSmiles("NC(=O)C1=C[N+](=CC=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O");
        this.smartsC00004 = smilesParser.parseSmiles("NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O");
        this.smartsC00005 = smilesParser.parseSmiles("NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O");
        this.smartsAlanine = smilesParser.parseSmiles("[CH3][C](N)C(O)=O");
        this.smartsPyruvate = smilesParser.parseSmiles("[CH3][C](=O)C(O)=O");
        this.smartsNRule = smilesParser.parseSmiles("CC(C)[C@H](N)C(O)=O");
        this.smartsCRule = smilesParser.parseSmiles("CC(C)C(=O)C(O)=O");
        this.smartsC04666Rule = smilesParser.parseSmiles("O=P(O)(O)O[CH2].[CH]O.O[CH]C=1N=CNC1");
        this.smartsC04916Rule = smilesParser.parseSmiles("O=C(N)C=1N=CN(C1N=CNCC(=O)[CH]O)C(O[CH])C(O)[CH]O.O=P(O)(O)O[CH2].O=P(O)(O)O[CH2].[CH]O");
    }

    private IAtomContainer getSmartsWater() {
        return this.smartsWater;
    }

    private IAtomContainer getSmartsPhosphate() {
        return this.smartsPhosphate;
    }

    private IAtomContainer getSmartsDoublePhosphate() {
        return this.smartsDoublePhosphate;
    }

    private IAtomContainer getSmartsGlutamate() {
        return this.smartsL_Glutamate;
    }

    private IAtomContainer getSmartsGlutamine() {
        return this.smartsL_Glutamine;
    }

    private IAtomContainer getSmartsGlutamineClipped() {
        return this.smartsL_Glutamine_clipped;
    }

    private IAtomContainer getSmartsGlutamateClipped() {
        return this.smartsL_Glutamate_clipped;
    }

    private IAtomContainer getSmartsTwoOxoglutarate() {
        return this.smartsTwoOxoglutarate;
    }

    private IAtomContainer getSmartsD_Glutamate() {
        return this.smartsD_Glutamate;
    }

    private IAtomContainer getSmartsAcetate() {
        return this.smartsAcetate;
    }

    private IAtomContainer getSmartsSulphate() {
        return this.smartsSulphate;
    }

    public IAtomContainer getSmartsATP() {
        return this.smartsATP;
    }

    public IAtomContainer getSmartsADP() {
        return this.smartsADP;
    }

    public IAtomContainer getSmartsCoA() {
        return this.smartsCoA;
    }

    public IAtomContainer getSmartsAcetyl_CoA() {
        return this.smartsAcetyl_CoA;
    }

    public IAtomContainer getSmartsC00003() {
        return this.smartsC00003;
    }

    public IAtomContainer getSmartsC00006() {
        return this.smartsC00006;
    }

    public IAtomContainer getSmartsC00004() {
        return this.smartsC00004;
    }

    public IAtomContainer getSmartsC00005() {
        return this.smartsC00005;
    }

    public IAtomContainer getSmartsPyruvate() {
        return this.smartsPyruvate;
    }

    public IAtomContainer getSmartsAlanine() {
        return this.smartsAlanine;
    }

    public IAtomContainer getSmartsNRule() {
        return this.smartsNRule;
    }

    public IAtomContainer getSmartsCRule() {
        return this.smartsCRule;
    }

    public IAtomContainer getSmartsC04666Rule() {
        return this.smartsC04666Rule;
    }

    public IAtomContainer getSmartsC04916Rule() {
        return this.smartsC04916Rule;
    }

    private boolean phosphate_cleaved(Collection<IAtomContainer> molsE, Collection<IAtomContainer> molsP) {
        int countphosE = 0;
        int countphosP = 0;
        for (IAtomContainer ac : molsE) {
            try {
                if (!Utility.isMatch(this.getSmartsPhosphate(), ac, false)) continue;
                countphosE += ac.getAtomCount();
            }
            catch (CDKException ex) {
                Logger.getLogger(RuleBasedMappingHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (IAtomContainer ac : molsP) {
            try {
                if (!Utility.isMatch(this.getSmartsPhosphate(), ac, false)) continue;
                countphosP += ac.getAtomCount();
            }
            catch (CDKException ex) {
                Logger.getLogger(RuleBasedMappingHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return countphosE != countphosP;
    }
}

