/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.reactionblast.mapping.blocks.Block;
import uk.ac.ebi.reactionblast.mapping.blocks.SubgraphMoleculeSignature;

public class BlockList
implements Comparable<BlockList> {
    private final List<Block> blocks = new ArrayList<Block>();
    private String signatureString;
    private int totalSize = 0;

    public void add(Block block) {
        this.blocks.add(block);
    }

    public int[] getBlockPermutation() {
        this.totalSize = 0;
        ArrayList<StringIntPair> signatureToBlockIndexMap = new ArrayList<StringIntPair>();
        for (int i = 0; i < this.blocks.size(); ++i) {
            Block block = this.blocks.get(i);
            String signature = block.getSignatureString();
            this.totalSize += block.getAtomCount();
            signatureToBlockIndexMap.add(new StringIntPair(signature, i));
        }
        Collections.sort(signatureToBlockIndexMap);
        int index = 0;
        int[] blockPermutation = new int[this.blocks.size()];
        for (StringIntPair stringIntPair : signatureToBlockIndexMap) {
            blockPermutation[index] = stringIntPair.intValue;
            ++index;
        }
        return blockPermutation;
    }

    public int[] getAtomContainerPermutation() {
        int[] blockPermutation = this.getBlockPermutation();
        int totalPermutationIndex = 0;
        int[] totalPermutation = new int[this.totalSize];
        int blockStart = 0;
        for (int blockIndex = 0; blockIndex < this.blocks.size(); ++blockIndex) {
            int permutedBlockIndex = blockPermutation[blockIndex];
            Block block = this.blocks.get(permutedBlockIndex);
            SubgraphMoleculeSignature subgraphSignature = block.getSubgraphSignature();
            int[] labels = subgraphSignature.getCanonicalLabels();
            for (int labelIndex = 0; labelIndex < labels.length; ++labelIndex) {
                int x;
                totalPermutation[totalPermutationIndex] = x = blockStart + labels[labelIndex];
                ++totalPermutationIndex;
            }
            blockStart += labels.length;
        }
        return totalPermutation;
    }

    private String calculateSignatureString() {
        ArrayList signatures = new ArrayList();
        this.blocks.stream().forEach(block -> signatures.add(block.getSignatureString()));
        Collections.sort(signatures);
        StringBuilder sb = new StringBuilder();
        signatures.stream().forEach(s -> sb.append((String)s).append("|"));
        return sb.toString();
    }

    public String getSignatureString() {
        if (this.signatureString == null) {
            this.signatureString = this.calculateSignatureString();
        }
        return this.signatureString;
    }

    public int numberOfAtoms() {
        int total = 0;
        total = this.blocks.stream().map(block -> block.getAtomCount()).reduce(total, Integer::sum);
        return total;
    }

    @Override
    public int compareTo(BlockList o) {
        int countOther;
        int countThis = this.numberOfAtoms();
        if (countThis > (countOther = o.numberOfAtoms())) {
            return -1;
        }
        if (countThis < countOther) {
            return 1;
        }
        return this.getSignatureString().compareTo(o.getSignatureString());
    }

    public int hashCode() {
        return this.getSignatureString().hashCode();
    }

    public boolean equals(Object o) {
        boolean signaturesEqual;
        if (o instanceof BlockList && (signaturesEqual = this.getSignatureString().equals(((BlockList)o).getSignatureString()))) {
            return ((BlockList)o).blocks.get(0).getAtomContainer() == this.blocks.get(0).getAtomContainer();
        }
        return false;
    }

    public Block get(int m) {
        return this.blocks.get(m);
    }

    public String toString() {
        return this.blocks.toString();
    }

    private class StringIntPair
    implements Comparable<StringIntPair> {
        public String stringValue;
        public int intValue;

        StringIntPair(String stringValue, int intValue) {
            this.stringValue = stringValue;
            this.intValue = intValue;
        }

        @Override
        public int compareTo(StringIntPair o) {
            return this.stringValue.compareTo(o.stringValue);
        }
    }
}

