/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockPair;
import uk.ac.ebi.reactionblast.mapping.blocks.DefinedMapping;

public class BlockMapper {
    public List<BlockPair> createBlockPairs(IReaction reaction) {
        ArrayList<BlockPair> blockPairs = new ArrayList<BlockPair>();
        List<DefinedMapping> definedMappings = this.createDefinedMappings(reaction);
        List<List<DefinedMapping>> mappingComponents = this.findMappedConnectedComponents(reaction, definedMappings);
        mappingComponents.stream().map(mappingComponent -> {
            DefinedMapping aMapping = (DefinedMapping)mappingComponent.get(0);
            BlockPair blockPair = new BlockPair(aMapping.getrAtomContainer(), aMapping.getpAtomContainer());
            for (int i = 0; i < mappingComponent.size(); ++i) {
                DefinedMapping definedMapping = (DefinedMapping)mappingComponent.get(i);
                IMapping mapping = reaction.getMapping(definedMapping.getIndex());
                blockPair.addMapping(mapping, definedMapping.getRAtom(), definedMapping.getPAtom());
            }
            return blockPair;
        }).forEach(blockPair -> blockPairs.add((BlockPair)blockPair));
        return blockPairs;
    }

    public List<List<DefinedMapping>> findMappedConnectedComponents(IReaction reaction, List<DefinedMapping> definedMappings) {
        MappingGraph mappingGraph = new MappingGraph(definedMappings);
        return mappingGraph.calculateConnectedComponents();
    }

    public List<DefinedMapping> createDefinedMappings(IReaction reaction) {
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet products = reaction.getProducts();
        ArrayList<DefinedMapping> definedMappings = new ArrayList<DefinedMapping>();
        int i = 0;
        for (IMapping mapping : reaction.mappings()) {
            String id = mapping.getChemObject(0).getID();
            AtomContainerAtomPair reactantPair = this.getByID(reactants, id);
            AtomContainerAtomPair productPair = this.getByID(products, id);
            int rIndex = reactantPair.getIndex();
            int pIndex = productPair.getIndex();
            definedMappings.add(new DefinedMapping(rIndex, pIndex, i, reactantPair.atomContainer, productPair.atomContainer));
            ++i;
        }
        return definedMappings;
    }

    private AtomContainerAtomPair getByID(IAtomContainerSet moleculeSet, String id) {
        for (IAtomContainer ac : moleculeSet.atomContainers()) {
            for (IAtom atom : ac.atoms()) {
                String atomID = atom.getID();
                if (atomID == null || !atomID.equals(id)) continue;
                return new AtomContainerAtomPair(ac, atom);
            }
        }
        return null;
    }

    private class MappingGraph {
        public List<DefinedMapping> vertices;
        public List<DefinedMapping>[] adjacencyTable;

        MappingGraph(List<DefinedMapping> mappings) {
            this.vertices = mappings;
            this.adjacencyTable = this.makeAdjacencyTable();
        }

        private List<DefinedMapping>[] makeAdjacencyTable() {
            HashMap lookup = new HashMap();
            this.vertices.stream().map(mapping -> {
                lookup.put(mapping.getRAtom(), mapping);
                return mapping;
            }).forEach(mapping -> lookup.put(mapping.getPAtom(), mapping));
            List[] adjTable = new List[this.vertices.size()];
            for (int i = 0; i < this.vertices.size(); ++i) {
                List<DefinedMapping> neighbours;
                DefinedMapping vertexI = this.vertices.get(i);
                List<IAtom> pNeighbours = vertexI.getPAtomNeighbours();
                List<IAtom> rNeighbours = vertexI.getRAtomNeighbours();
                if (adjTable[i] == null) {
                    adjTable[i] = neighbours = new ArrayList();
                } else {
                    neighbours = adjTable[i];
                }
                for (int j = i + 1; j < this.vertices.size(); ++j) {
                    DefinedMapping vertexJ = this.vertices.get(j);
                    if (!pNeighbours.contains(vertexJ.getPAtom()) || !rNeighbours.contains(vertexJ.getRAtom())) continue;
                    neighbours.add(vertexJ);
                    if (adjTable[j] == null) {
                        adjTable[j] = new ArrayList();
                    }
                    adjTable[j].add(vertexI);
                }
            }
            return adjTable;
        }

        public List<List<DefinedMapping>> calculateConnectedComponents() {
            int[] componentLabels = new int[this.vertices.size()];
            ArrayList<List<DefinedMapping>> components = new ArrayList<List<DefinedMapping>>();
            int currentLabel = 1;
            int i = 0;
            while (i < this.vertices.size()) {
                ArrayList<DefinedMapping> component = new ArrayList<DefinedMapping>();
                DefinedMapping vertex = this.vertices.get(i);
                this.search(vertex, currentLabel, componentLabels, component);
                if (component.size() > 0) {
                    components.add(component);
                }
                while (i < this.vertices.size() && componentLabels[i] != 0) {
                    ++i;
                }
                ++currentLabel;
            }
            return components;
        }

        private void search(DefinedMapping vertex, int currentLabel, int[] labels, List<DefinedMapping> component) {
            if (!vertex.isVisited()) {
                vertex.setVisited(true);
                labels[vertex.getIndex()] = currentLabel;
                component.add(vertex);
                this.adjacencyTable[vertex.getIndex()].stream().forEach(neighbour -> {
                    if (!neighbour.isVisited()) {
                        this.search((DefinedMapping)neighbour, currentLabel, labels, component);
                    }
                });
            }
        }
    }

    private class AtomContainerAtomPair {
        public final IAtomContainer atomContainer;
        public final IAtom atom;

        AtomContainerAtomPair(IAtomContainer atomContainer, IAtom atom) {
            this.atom = atom;
            this.atomContainer = atomContainer;
        }

        public int getIndex() {
            return this.atomContainer.indexOf(this.atom);
        }
    }
}

