/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.blocks.Block;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockList;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockMapping;
import uk.ac.ebi.reactionblast.tools.labelling.AtomContainerPrinter;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalReactionLabeller;

public class BlockReactionCanoniser
implements ICanonicalReactionLabeller {
    private IChemObjectBuilder builder = null;

    @Override
    public IReaction getCanonicalReaction(IReaction reaction) {
        BlockMapping blockMapping = new BlockMapping(reaction);
        this.builder = reaction.getBuilder();
        IReaction permutedReaction = this.builder.newInstance(IReaction.class, new Object[0]);
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet permutedReactants = this.permuteR(reactants, blockMapping);
        permutedReaction.setReactants(permutedReactants);
        IAtomContainerSet products = reaction.getProducts();
        IAtomContainerSet permutedProducts = this.permuteP(products, blockMapping);
        permutedReaction.setProducts(permutedProducts);
        this.replaceMappings(reaction, permutedReaction);
        permutedReaction.setID(reaction.getID());
        return permutedReaction;
    }

    private void replaceMappings(IReaction reaction, IReaction permutedReaction) {
        HashMap<IAtom, Integer> indexMap = new HashMap<IAtom, Integer>();
        int globalIndex = this.fillIndexMap(indexMap, permutedReaction.getReactants(), 0);
        this.fillIndexMap(indexMap, permutedReaction.getProducts(), globalIndex);
        HashMap<Integer, IMapping> mappingMap = new HashMap<Integer, IMapping>();
        ArrayList<IMapping> orphanMappings = new ArrayList<IMapping>();
        for (IMapping mapping2 : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping2.getChemObject(0);
            IAtom a1 = (IAtom)mapping2.getChemObject(1);
            if (a0 == null || a1 == null) {
                orphanMappings.add(mapping2);
                continue;
            }
            Integer id = (Integer)indexMap.get(a0);
            if (id == null) {
                orphanMappings.add(mapping2);
                continue;
            }
            mappingMap.put(id, mapping2);
        }
        ArrayList keys = new ArrayList(mappingMap.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            permutedReaction.addMapping((IMapping)mappingMap.get(key));
        }
        orphanMappings.stream().forEach(mapping -> permutedReaction.addMapping((IMapping)mapping));
    }

    private int fillIndexMap(Map<IAtom, Integer> indexMap, IAtomContainerSet moleculeSet, int index) {
        for (IAtomContainer atomContainer : moleculeSet.atomContainers()) {
            for (IAtom atom : atomContainer.atoms()) {
                indexMap.put(atom, index);
                ++index;
            }
        }
        return index;
    }

    private IAtomContainerSet permuteR(IAtomContainerSet original, BlockMapping mapping) {
        int[] reactantPermutation = mapping.getPermutationOfReactants();
        IAtomContainerSet permutedContainers = this.builder.newInstance(IAtomContainerSet.class, new Object[0]);
        ArrayList<IAtomContainer> unusedContainers = new ArrayList<IAtomContainer>();
        for (IAtomContainer ac : original.atomContainers()) {
            unusedContainers.add(ac);
        }
        for (int i = 0; i < original.getAtomContainerCount(); ++i) {
            int pi = reactantPermutation[i];
            IAtomContainer container = original.getAtomContainer(pi);
            BlockList blockList = mapping.getBlockListForReactant(container);
            if (blockList == null) {
                System.out.println("blocklist null for " + i + new AtomContainerPrinter().toString(container) + " in " + Arrays.toString(reactantPermutation));
                continue;
            }
            unusedContainers.remove(container);
            IAtomContainer permutedContainer = this.builder.newInstance(IAtomContainer.class, new Object[0]);
            permutedContainer.setID(container.getID());
            IAtom[] atoms = this.getPermutedAtomsForReactant(blockList, container);
            permutedContainer.setAtoms(atoms);
            for (IBond bond : container.bonds()) {
                permutedContainer.addBond(bond);
            }
            permutedContainers.addAtomContainer(permutedContainer);
        }
        unusedContainers.stream().forEach(unusedContainer -> permutedContainers.addAtomContainer((IAtomContainer)unusedContainer));
        return permutedContainers;
    }

    private IAtomContainerSet permuteP(IAtomContainerSet original, BlockMapping mapping) {
        IAtomContainerSet permutedContainers = this.builder.newInstance(IAtomContainerSet.class, new Object[0]);
        int[] productPermutation = mapping.getPermutationOfProducts();
        ArrayList<IAtomContainer> unusedContainers = new ArrayList<IAtomContainer>();
        for (IAtomContainer ac : original.atomContainers()) {
            unusedContainers.add(ac);
        }
        for (int i = 0; i < original.getAtomContainerCount(); ++i) {
            int pi = productPermutation[i];
            IAtomContainer container = original.getAtomContainer(pi);
            BlockList blockList = mapping.getBlockListForProduct(container);
            if (blockList == null) {
                System.out.println("blocklist null for " + i + new AtomContainerPrinter().toString(container) + " in " + Arrays.toString(productPermutation));
                continue;
            }
            unusedContainers.remove(container);
            IAtomContainer permutedContainer = this.builder.newInstance(IAtomContainer.class, new Object[0]);
            permutedContainer.setID(container.getID());
            IAtom[] atoms = this.getPermutedAtomsForProduct(blockList, container);
            permutedContainer.setAtoms(atoms);
            for (IBond bond : container.bonds()) {
                permutedContainer.addBond(bond);
            }
            permutedContainers.addAtomContainer(permutedContainer);
        }
        unusedContainers.stream().forEach(unusedContainer -> permutedContainers.addAtomContainer((IAtomContainer)unusedContainer));
        return permutedContainers;
    }

    private void bucketSort(List<IAtom> atoms, IAtomContainer ac) {
        HashMap indexMap = new HashMap();
        atoms.stream().forEach(atom -> indexMap.put(atom, ac.indexOf((IAtom)atom)));
        Comparator sorter = (o1, o2) -> ((Integer)indexMap.get(o1)).compareTo((Integer)indexMap.get(o2));
        Collections.sort(atoms, sorter);
    }

    private IAtom[] getPermutedAtomsForReactant(BlockList blockList, IAtomContainer container) {
        int[] blockPermutation = blockList.getBlockPermutation();
        int m = blockPermutation.length;
        IAtom[] atoms = new IAtom[container.getAtomCount()];
        ArrayList<IAtom> unusedAtoms = new ArrayList<IAtom>();
        for (IAtom atom : container.atoms()) {
            unusedAtoms.add(atom);
        }
        int blockStart = 0;
        for (int blockIndex = 0; blockIndex < m; ++blockIndex) {
            Block block = blockList.get(blockPermutation[blockIndex]);
            int[] labels = block.getLabels();
            List<IAtom> subgraphAtoms = block.getAtoms();
            this.bucketSort(subgraphAtoms, container);
            int indexInBlock = 0;
            for (IAtom atom : subgraphAtoms) {
                int newIndex = labels[indexInBlock];
                atoms[blockStart + newIndex] = atom;
                unusedAtoms.remove(atom);
                ++indexInBlock;
            }
            blockStart += labels.length;
        }
        int numberUnused = unusedAtoms.size();
        if (numberUnused != 0) {
            int index = atoms.length - numberUnused;
            Iterator iterator = unusedAtoms.iterator();
            while (iterator.hasNext()) {
                IAtom unusedAtom;
                atoms[index] = unusedAtom = (IAtom)iterator.next();
                ++index;
            }
        }
        return atoms;
    }

    private IAtom[] getPermutedAtomsForProduct(BlockList blockList, IAtomContainer container) {
        int[] blockPermutation = blockList.getBlockPermutation();
        int m = blockPermutation.length;
        IAtom[] atoms = new IAtom[container.getAtomCount()];
        ArrayList<IAtom> unusedAtoms = new ArrayList<IAtom>();
        for (IAtom atom : container.atoms()) {
            unusedAtoms.add(atom);
        }
        int blockStart = 0;
        for (int blockIndex = 0; blockIndex < m; ++blockIndex) {
            Block block = blockList.get(blockPermutation[blockIndex]);
            int[] labels = block.getPartner().getLabels();
            List<IAtom> subgraphAtoms = block.getAtoms();
            this.bucketSort(subgraphAtoms, container);
            int[] mappingPermutation = block.getMappingPermutation();
            int indexInBlock = 0;
            this.printAtomIndices(subgraphAtoms, container);
            for (IAtom atom : subgraphAtoms) {
                int newIndex = labels[mappingPermutation[indexInBlock]];
                atoms[blockStart + newIndex] = atom;
                unusedAtoms.remove(atom);
                ++indexInBlock;
            }
            blockStart += labels.length;
        }
        int numberUnused = unusedAtoms.size();
        if (numberUnused != 0) {
            int index = atoms.length - numberUnused;
            Iterator iterator = unusedAtoms.iterator();
            while (iterator.hasNext()) {
                IAtom unusedAtom;
                atoms[index] = unusedAtom = (IAtom)iterator.next();
                ++index;
            }
        }
        return atoms;
    }

    private void printReaction(IReaction reaction) {
        for (IAtomContainer atomContainer : reaction.getReactants().atomContainers()) {
            for (IAtom atom : atomContainer.atoms()) {
                System.out.println("PRINTING ATOM " + atom.getID());
            }
        }
        for (IAtomContainer atomContainer : reaction.getProducts().atomContainers()) {
            for (IAtom atom : atomContainer.atoms()) {
                System.out.println("PRINTING ATOM " + atom.getID());
            }
        }
    }

    private void printAtomIndices(List<IAtom> atoms, IAtomContainer container) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom atom = atoms.get(i);
            if (atom == null) {
                // empty if block
            }
            int index = container.indexOf(atom);
            indices.add(index);
        }
    }

    private void printAtomIndices(IAtom[] atoms, IAtomContainer container) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = atoms[i];
            if (atom == null) {
                System.out.println("atom " + i + " is null");
            }
            int index = container.indexOf(atom);
            indices.add(index);
        }
        System.out.println("array atoms " + indices);
    }

    private String tmpAtomPrint(Iterable<IAtom> atoms, IAtomContainer ac) {
        Object s = "";
        for (IAtom atom : atoms) {
            if (atom == null) {
                s = (String)s + "!";
                continue;
            }
            s = (String)s + atom.getSymbol() + ac.indexOf(atom) + "(" + atom.getID() + ")";
        }
        return s;
    }
}

