/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import signature.AbstractGraphSignature;
import signature.AbstractVertexSignature;
import uk.ac.ebi.reactionblast.mapping.blocks.SubgraphAtomSignature;

public class SubgraphMoleculeSignature
extends AbstractGraphSignature {
    private final int vertexCount;
    private final IAtomContainer atomContainer;
    private Map<Integer, int[]> subgraphAdjacencyLists;
    private List<Integer> indexLookup;
    private final boolean useAdjLists;

    public SubgraphMoleculeSignature(IAtomContainer fullContainer, List<IAtom> subgraphAtoms, int dummy) {
        this.atomContainer = fullContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom[] sortedAtoms = new IAtom[fullContainer.getAtomCount()];
        ArrayList debugList = new ArrayList();
        subgraphAtoms.stream().forEach(atom -> {
            int atomNumber = fullContainer.indexOf((IAtom)atom);
            sortedAtoms[atomNumber] = atom;
            debugList.add(atom.getSymbol() + atomNumber);
        });
        Collections.sort(debugList);
        ArrayList<Integer> debugList2 = new ArrayList<Integer>();
        for (int i = 0; i < sortedAtoms.length; ++i) {
            if (sortedAtoms[i] == null) continue;
            this.atomContainer.addAtom(sortedAtoms[i]);
            debugList2.add(i);
        }
        for (IBond bond : fullContainer.bonds()) {
            IAtom a0 = bond.getAtom(0);
            IAtom a1 = bond.getAtom(1);
            int a0n = fullContainer.indexOf(a0);
            int a1n = fullContainer.indexOf(a1);
            if (!subgraphAtoms.contains(a0) || !subgraphAtoms.contains(a1)) continue;
            this.atomContainer.addBond(bond);
        }
        this.vertexCount = subgraphAtoms.size();
        this.useAdjLists = false;
    }

    public SubgraphMoleculeSignature(IAtomContainer atomContainer, List<IAtom> subgraphAtoms) {
        this.atomContainer = atomContainer;
        this.indexLookup = new ArrayList<Integer>();
        this.subgraphAdjacencyLists = new HashMap<Integer, int[]>();
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            IAtom atom = atomContainer.getAtom(i);
            if (!subgraphAtoms.contains(atom)) continue;
            ArrayList connectedIndices = new ArrayList();
            atomContainer.getConnectedAtomsList(atom).stream().filter(neighbour -> subgraphAtoms.contains(neighbour)).map(neighbour -> atomContainer.indexOf((IAtom)neighbour)).forEach(connectedIndices::add);
            int[] connectedIndicesArray = new int[connectedIndices.size()];
            int x = 0;
            Iterator iterator = connectedIndices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                connectedIndicesArray[x++] = index;
            }
            this.subgraphAdjacencyLists.put(i, connectedIndicesArray);
            this.indexLookup.add(i);
        }
        this.vertexCount = atomContainer.getAtomCount();
        this.useAdjLists = true;
    }

    @Override
    protected int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public AbstractVertexSignature signatureForVertex(int subgraphAtomIndex) {
        if (this.useAdjLists) {
            int actualIndex = this.indexLookup.get(subgraphAtomIndex);
            return new SubgraphAtomSignature(this.atomContainer, actualIndex, this.subgraphAdjacencyLists);
        }
        return new SubgraphAtomSignature(this.atomContainer, subgraphAtomIndex);
    }

    @Override
    public String signatureStringForVertex(int subgraphAtomIndex) {
        return this.signatureForVertex(subgraphAtomIndex).toCanonicalString();
    }

    @Override
    public String signatureStringForVertex(int atomIndex, int height) {
        return null;
    }
}

