/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ac.ebi.reactionblast.mapping.cache.Cache;

public class CacheMap<K, V>
implements Cache<K, V> {
    private long timeToLive;
    private HashMap<K, V> cacheMap;

    public CacheMap(long timeToLive, long timeInterval, int max) {
        this.timeToLive = timeToLive * 2000L;
        this.cacheMap = new HashMap(max);
        if (timeToLive > 0L && timeInterval > 0L) {
            Thread t = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(timeInterval * 1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        HashMap<K, V> hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        HashMap<K, V> hashMap = this.cacheMap;
        synchronized (hashMap) {
            CrunchifyCacheObject c = (CrunchifyCacheObject)this.cacheMap.get(key);
            if (c == null) {
                return null;
            }
            c.lastAccessed = System.currentTimeMillis();
            return (V)c.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        HashMap<K, V> hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        HashMap<K, V> hashMap = this.cacheMap;
        synchronized (hashMap) {
            return this.cacheMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        long now = System.currentTimeMillis();
        ArrayList<String> deleteKey = null;
        HashMap<K, V> hashMap = this.cacheMap;
        synchronized (hashMap) {
            Iterator<Map.Entry<K, V>> itr = this.cacheMap.entrySet().iterator();
            deleteKey = new ArrayList<String>(this.cacheMap.size() / 2 + 1);
            CrunchifyCacheObject c = null;
            while (itr.hasNext()) {
                String key = (String)((Object)itr.next());
                c = (CrunchifyCacheObject)((Map.Entry)((Object)itr)).getValue();
                if (c == null || now <= this.timeToLive + c.lastAccessed) continue;
                deleteKey.add(key);
            }
        }
        for (String key : deleteKey) {
            HashMap<K, V> hashMap2 = this.cacheMap;
            synchronized (hashMap2) {
                this.cacheMap.remove(key);
            }
            Thread.yield();
        }
    }

    protected class CrunchifyCacheObject {
        public long lastAccessed = System.currentTimeMillis();
        public String value;

        protected CrunchifyCacheObject(String value) {
            this.value = value;
        }
    }
}

