/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.cache;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.ebi.reactionblast.mapping.cache.Cache;

public class ThreadSafeCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> map = new ConcurrentHashMap();
    private static final ThreadSafeCache SC = new ThreadSafeCache();

    public static ThreadSafeCache getInstance() {
        return SC;
    }

    private ThreadSafeCache() {
    }

    @Override
    public synchronized void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public synchronized V get(K key) {
        return this.map.get(key);
    }

    public synchronized boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanup() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
        Thread.yield();
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized Set<K> keySet() {
        return this.map.keySet();
    }
}

