/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import uk.ac.ebi.reactionblast.mapping.container.helper.Key;
import uk.ac.ebi.reactionblast.mapping.interfaces.BestMatch;
import uk.ac.ebi.reactionblast.mapping.interfaces.IKey;

public class BestMatchContainer
extends BestMatch
implements Serializable {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(BestMatchContainer.class);
    private static final long serialVersionUID = 10947239472059259L;
    private final Map<IKey, AtomAtomMapping> mcsAtomMap = Collections.synchronizedMap(new HashMap());
    private final Map<IKey, Integer> fragmentCount = Collections.synchronizedMap(new HashMap());
    private final Map<IKey, Double> bondBreakingEnergy = Collections.synchronizedMap(new HashMap());
    private final Map<IKey, Double> stereoScore = Collections.synchronizedMap(new HashMap());
    private final Map<IKey, Double> similarity = Collections.synchronizedMap(new HashMap());

    public String toString() {
        return "BestMatchContainer{mcsAtomMap=" + this.mcsAtomMap + ", fragmentCount=" + this.fragmentCount + ", bondBreakingEnergy=" + this.bondBreakingEnergy + ", stereoScore=" + this.stereoScore + ", similarity=" + this.similarity + "}";
    }

    @Override
    public synchronized void Clear() throws IOException {
        this.mcsAtomMap.clear();
        this.fragmentCount.clear();
        this.bondBreakingEnergy.clear();
        this.stereoScore.clear();
        this.similarity.clear();
    }

    @Override
    public synchronized void Erase(int indexI, int indexJ) throws IOException {
        Key key = new Key(indexI, indexJ);
        this.mcsAtomMap.remove(key);
        this.fragmentCount.remove(key);
        this.bondBreakingEnergy.remove(key);
        this.stereoScore.remove(key);
        this.similarity.remove(key);
    }

    @Override
    public synchronized AtomAtomMapping getAtomMatch(int indexI, int indexJ) throws IOException {
        Key key = new Key(indexI, indexJ);
        if (this.mcsAtomMap.containsKey(key)) {
            return this.mcsAtomMap.get(key);
        }
        try {
            throw new CDKException("Key not found:" + key + " in " + this.mcsAtomMap.keySet());
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public synchronized double getBondEnergy(int indexI, int indexJ) {
        Key key = new Key(indexI, indexJ);
        return this.bondBreakingEnergy.containsKey(key) ? this.bondBreakingEnergy.get(key) : 0.0;
    }

    @Override
    public synchronized int getTotalFragmentCount(int indexI, int indexJ) {
        Key key = new Key(indexI, indexJ);
        return this.fragmentCount.containsKey(key) ? this.fragmentCount.get(key) : 0;
    }

    @Override
    public synchronized void setBondEnergy(int indexI, int indexJ, double value) {
        Key key = new Key(indexI, indexJ);
        this.bondBreakingEnergy.put(key, value);
    }

    @Override
    public synchronized void setTotalFragmentCount(int indexI, int indexJ, Integer value) {
        Key key = new Key(indexI, indexJ);
        this.fragmentCount.put(key, value);
    }

    @Override
    public synchronized void putBestMapping(int indexI, int indexJ, AtomAtomMapping matchingAtoms) throws IOException {
        Key key = new Key(indexI, indexJ);
        this.mcsAtomMap.put(key, matchingAtoms);
    }

    @Override
    public synchronized boolean containsKey(int indexI, int indexJ) throws IOException {
        Key key = new Key(indexI, indexJ);
        return this.mcsAtomMap.containsKey(key);
    }

    @Override
    public synchronized void setStereoScore(int indexI, int indexJ, double stereoVal) {
        Key key = new Key(indexI, indexJ);
        this.stereoScore.put(key, stereoVal);
    }

    @Override
    public synchronized double getStereoScore(int indexI, int indexJ) {
        Key key = new Key(indexI, indexJ);
        return this.stereoScore.containsKey(key) ? this.stereoScore.get(key) : 0.0;
    }

    @Override
    public synchronized void setGraphSimilarity(int indexI, int indexJ, double _simVal) {
        Key key = new Key(indexI, indexJ);
        this.similarity.put(key, _simVal);
    }

    @Override
    public synchronized double getGraphSimilarity(int indexI, int indexJ) {
        Key key = new Key(indexI, indexJ);
        return this.similarity.containsKey(key) ? this.similarity.get(key) : 0.0;
    }
}

