/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.fingerprints.tools.Similarity;
import uk.ac.ebi.reactionblast.interfaces.IFingerPrintContainer;

public class HydrogenFreeFingerPrintContainer
implements IFingerPrintContainer,
Serializable {
    private static final int FINGER_SIZE = 1920;
    private static final int DEPTH_SEARCH = 8;
    private static final long serialVersionUID = 987987606869669691L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(HydrogenFreeFingerPrintContainer.class);
    private final Map<String, BitSet> fingerPrintMap = Collections.synchronizedSortedMap(new TreeMap());

    public static int getFingerPrintSize() {
        return 1920;
    }

    public static int getFingerPrintDepth() {
        return 8;
    }

    public String toString() {
        return "HydrogenFreeFingerPrintContainer{fingerPrintMap=" + this.fingerPrintMap + "}";
    }

    @Override
    public synchronized void Clear() throws IOException {
        this.fingerPrintMap.clear();
    }

    @Override
    public synchronized void Erase(String Key2) throws IOException {
        this.fingerPrintMap.remove(Key2);
    }

    @Override
    public synchronized void put(String Key2, BitSet Value2) throws IOException {
        try {
            this.fingerPrintMap.put(Key2, Value2);
        }
        catch (Exception e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
    }

    @Override
    public synchronized BitSet getFingerPrint(String Key2) throws IOException {
        return this.fingerPrintMap.get(Key2);
    }

    @Override
    public synchronized String getMoleculeID(BitSet bitset) throws IOException {
        String Key2 = null;
        for (Map.Entry<String, BitSet> map : this.fingerPrintMap.entrySet()) {
            String key = map.getKey();
            try {
                if ((double)Similarity.getTanimotoSimilarity(map.getValue(), bitset) != 1.0) continue;
                Key2 = key;
                break;
            }
            catch (Exception ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        return Key2;
    }

    @Override
    public synchronized Map<String, BitSet> getFingerPrintMap() throws IOException {
        return Collections.synchronizedSortedMap(new TreeMap<String, BitSet>(this.fingerPrintMap));
    }

    @Override
    public synchronized boolean isKeyPresent(String Key2) throws IOException {
        return this.fingerPrintMap.containsKey(Key2);
    }

    @Override
    public synchronized void setValue(String Key2, BitSet Value2) throws IOException {
        this.fingerPrintMap.put(Key2, Value2);
    }

    @Override
    public synchronized boolean isValuePresent(BitSet value) throws IOException {
        for (BitSet bitset : this.fingerPrintMap.values()) {
            try {
                if ((double)Similarity.getTanimotoSimilarity(value, bitset) != 1.0) continue;
                return true;
            }
            catch (Exception ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public int getSize() {
        return this.fingerPrintMap.size();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.fingerPrintMap.isEmpty();
    }

    @Override
    public void write() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

