/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import uk.ac.ebi.reactionblast.mapping.container.helper.ReactionFileData;

public class KeggReactionFileContainer
implements Serializable {
    private static final long serialVersionUID = 1094750239472059259L;
    private static TreeMap<String, Map<String, ReactionFileData>> reactionMap = null;
    private static KeggReactionFileContainer ref = null;
    private static final String entry = "ENTRY";
    private static final String name = "NAME";
    private static final String equat = "EQUATION";
    private static final String defin = "DEFINITION";
    private static final String path = "PATHWAY";
    private static final String rpair = "RPAIR";
    private static final String ortho = "ORTHOLOGY";
    private static final String enzyme = "ENZYME";
    private static final String end = "///";
    private static final String comment = "COMMENT";
    private static final String remark = "REMARK";

    public static synchronized KeggReactionFileContainer getInstance() throws Exception {
        if (ref == null) {
            ref = new KeggReactionFileContainer();
        }
        return ref;
    }

    protected KeggReactionFileContainer() throws Exception {
        reactionMap = new TreeMap();
    }

    public synchronized void Clear() {
        reactionMap.clear();
        ref = null;
    }

    public synchronized boolean containsKey(String _recID, String Key2) {
        Map<String, ReactionFileData> DataMap = reactionMap.get(_recID);
        return DataMap.containsKey(Key2);
    }

    public synchronized Set<String> getKeySet() {
        return reactionMap.keySet();
    }

    public synchronized String getDefination(String _recID) {
        Map<String, ReactionFileData> DataMap;
        String _data = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(defin)) {
            _data = DataMap.get(defin).getValue(0);
        }
        return _data.trim();
    }

    public synchronized String getEntry(String _recID) {
        Map<String, ReactionFileData> DataMap;
        String _data = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(entry)) {
            _data = DataMap.get(entry).getValue(0);
        }
        return _data.trim();
    }

    public synchronized List<String> getEnzyme(String _recID) {
        Map<String, ReactionFileData> DataMap;
        ArrayList<String> ecData = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(enzyme)) {
            ecData = new ArrayList<String>();
            ReactionFileData eData = DataMap.get(enzyme);
            for (String data : eData.getValues()) {
                ecData.add(data);
            }
        }
        return ecData;
    }

    public synchronized String getEquation(String _recID) {
        Map<String, ReactionFileData> DataMap;
        String _data = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(equat)) {
            _data = DataMap.get(equat).getValue(0);
        }
        return _data.trim();
    }

    synchronized Set<String> getKeys() {
        return reactionMap.keySet();
    }

    public synchronized String getName(String _recID) {
        Map<String, ReactionFileData> DataMap;
        String _data = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(name)) {
            _data = DataMap.get(name).getValue(0).trim();
        }
        return _data;
    }

    public synchronized List<String> getPathway(String _recID) {
        Map<String, ReactionFileData> DataMap;
        ArrayList<String> _data = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(path)) {
            _data = new ArrayList<String>();
            for (String data : DataMap.get(path).getValues()) {
                _data.add(data);
            }
        }
        return _data;
    }

    public synchronized List<String> getRemark(String _recID) {
        Map<String, ReactionFileData> DataMap;
        ArrayList<String> _data = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(remark)) {
            _data = new ArrayList<String>();
            for (String data : DataMap.get(remark).getValues()) {
                _data.add(data);
            }
        }
        return _data;
    }

    public synchronized String getRpair(String _recID) {
        Map<String, ReactionFileData> DataMap;
        String _data = null;
        if (reactionMap.containsKey(_recID) && (DataMap = reactionMap.get(_recID)).containsKey(rpair)) {
            _data = DataMap.get(rpair).getValue(0);
        }
        return _data.trim();
    }

    public synchronized Integer getCount() {
        return reactionMap.size();
    }

    public synchronized void put(String key, Map<String, ReactionFileData> DataMap) {
        reactionMap.put(key, DataMap);
    }
}

