/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.fingerprints.FingerprintGenerator;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IFingerprintGenerator;

public class ReactionContainer
implements Cloneable,
Serializable {
    static final long serialVersionUID = 17278639972837695L;
    private final Map<Integer, IAtomContainer> eAtomContainerMap = Collections.synchronizedMap(new TreeMap());
    private final Map<Integer, IAtomContainer> pAtomContainerMap = Collections.synchronizedMap(new TreeMap());
    private final Map<Integer, BitSet> eFingerPrintMap = Collections.synchronizedMap(new TreeMap());
    private final Map<Integer, BitSet> pFingerPrintMap = Collections.synchronizedMap(new TreeMap());
    private final Map<Integer, Boolean> eductContainerModificationMap = Collections.synchronizedMap(new TreeMap());
    private final Map<Integer, Boolean> productContainerModificationMap = Collections.synchronizedMap(new TreeMap());
    private final IFingerprintGenerator fpr = new FingerprintGenerator();

    public String toString() {
        return "ReactionContainer{eAtomContainerMap=" + this.eAtomContainerMap + ", pAtomContainerMap=" + this.pAtomContainerMap + ", eFingerPrintMap=" + this.eFingerPrintMap + ", pFingerPrintMap=" + this.pFingerPrintMap + ", eductContainerModificationMap=" + this.eductContainerModificationMap + ", productContainerModificationMap=" + this.productContainerModificationMap + ", fpr=" + this.fpr + "}";
    }

    public synchronized void Clear() throws IOException {
        this.eAtomContainerMap.clear();
        this.pAtomContainerMap.clear();
        this.eFingerPrintMap.clear();
        this.pFingerPrintMap.clear();
        this.eductContainerModificationMap.clear();
        this.productContainerModificationMap.clear();
    }

    public synchronized void eraseEduct(int Key2) throws IOException {
        this.eAtomContainerMap.remove(Key2);
        this.eFingerPrintMap.remove(Key2);
        this.eductContainerModificationMap.remove(Key2);
    }

    public synchronized void eraseProduct(int Key2) throws IOException {
        this.pAtomContainerMap.remove(Key2);
        this.pFingerPrintMap.remove(Key2);
        this.productContainerModificationMap.remove(Key2);
    }

    public synchronized Integer getEductCount() {
        return this.eAtomContainerMap.size();
    }

    public synchronized Integer getProductCount() {
        return this.pAtomContainerMap.size();
    }

    public synchronized IAtomContainer getEduct(int value) throws IOException, CDKException {
        return this.eAtomContainerMap.containsKey(value) ? this.eAtomContainerMap.get(value) : null;
    }

    public synchronized IAtomContainer getProduct(int value) throws IOException, CDKException {
        return this.pAtomContainerMap.containsKey(value) ? this.pAtomContainerMap.get(value) : null;
    }

    public synchronized Collection<IAtomContainer> getEducts() throws IOException, CDKException {
        return this.eAtomContainerMap.values();
    }

    public synchronized Collection<IAtomContainer> getProducts() throws IOException, CDKException {
        return this.pAtomContainerMap.values();
    }

    public synchronized boolean isEductModified(int value) throws IOException, CDKException {
        return this.eductContainerModificationMap.containsKey(value) ? this.eductContainerModificationMap.get(value) : false;
    }

    public synchronized boolean isProductModified(int value) throws IOException, CDKException {
        return this.productContainerModificationMap.containsKey(value) ? this.productContainerModificationMap.get(value) : false;
    }

    public synchronized void putEduct(int index, IAtomContainer educt) throws IOException, Exception {
        this.eAtomContainerMap.put(index, educt);
        if (educt.getAtomCount() == 0) {
            this.setFingerPrintofEduct(index, new BitSet(FingerprintGenerator.getFingerprinterSize()));
        } else {
            BitSet fp = this.fpr.getFingerprint(educt);
            this.setFingerPrintofEduct(index, (BitSet)fp.clone());
        }
    }

    public synchronized void putProduct(int index, IAtomContainer product) throws IOException, Exception {
        this.pAtomContainerMap.put(index, product);
        if (product.getAtomCount() == 0) {
            this.setFingerPrintofProduct(index, new BitSet(FingerprintGenerator.getFingerprinterSize()));
        } else {
            BitSet fp = this.fpr.getFingerprint(product);
            this.setFingerPrintofProduct(index, (BitSet)fp.clone());
        }
    }

    public synchronized void setEductModified(int index, boolean flag) throws IOException, Exception {
        this.eductContainerModificationMap.put(index, flag);
    }

    public synchronized void setProductModified(int index, boolean flag) throws IOException, Exception {
        this.productContainerModificationMap.put(index, flag);
    }

    public synchronized void putAllEduct(TreeMap<Integer, IAtomContainer> eudMap) throws IOException, Exception {
        this.eAtomContainerMap.putAll(eudMap);
        for (Map.Entry<Integer, IAtomContainer> map : eudMap.entrySet()) {
            BitSet fp = this.fpr.getFingerprint(map.getValue());
            this.setFingerPrintofEduct(map.getKey(), fp);
        }
    }

    public synchronized void putAllProduct(TreeMap<Integer, IAtomContainer> prodMap) throws IOException, Exception {
        this.pAtomContainerMap.putAll(prodMap);
        for (Map.Entry<Integer, IAtomContainer> map : prodMap.entrySet()) {
            BitSet fp = this.fpr.getFingerprint(map.getValue());
            this.setFingerPrintofProduct(map.getKey(), fp);
        }
    }

    public synchronized BitSet getFingerPrintofEduct(int value) throws IOException, CDKException {
        return this.eFingerPrintMap.containsKey(value) ? this.eFingerPrintMap.get(value) : null;
    }

    public synchronized BitSet getFingerPrintofProduct(int value) throws IOException, CDKException {
        return this.pFingerPrintMap.containsKey(value) ? this.pFingerPrintMap.get(value) : null;
    }

    private synchronized void setFingerPrintofEduct(int value, BitSet edu) throws IOException {
        this.eFingerPrintMap.put(value, edu);
    }

    private synchronized void setFingerPrintofProduct(int value, BitSet prod) throws IOException {
        this.pFingerPrintMap.put(value, prod);
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

