/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.mapping.graph.Combination;
import uk.ac.ebi.reactionblast.mapping.graph.MCSSolution;
import uk.ac.ebi.reactionblast.mapping.graph.MCSThread;
import uk.ac.ebi.reactionblast.mapping.helper.Debugger;

public class GraphMatcher
extends Debugger {
    private static final boolean DEBUG = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(GraphMatcher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Collection<MCSSolution> matcher(Holder mh) throws Exception {
        ExecutorService executor = null;
        Collection mcsSolutions = Collections.synchronizedCollection(new ArrayList());
        TreeSet<Combination> jobReplicatorList = new TreeSet<Combination>();
        int taskCounter = 0;
        try {
            ReactionContainer reactionStructureInformation = mh.getReactionContainer();
            Integer eductCount = reactionStructureInformation.getEductCount();
            Integer productCount = reactionStructureInformation.getProductCount();
            for (int substrateIndex = 0; substrateIndex < eductCount; ++substrateIndex) {
                for (int productIndex = 0; productIndex < productCount; ++productIndex) {
                    IAtomContainer educt = reactionStructureInformation.getEduct(substrateIndex);
                    IAtomContainer product = reactionStructureInformation.getProduct(productIndex);
                    if ((educt == null || product == null || reactionStructureInformation.getEduct(substrateIndex).getAtomCount() <= 0 || reactionStructureInformation.getProduct(productIndex).getAtomCount() <= 0) && mh.getGraphSimilarityMatrix().getValue(substrateIndex, productIndex) != -1.0) continue;
                    Combination c = new Combination(substrateIndex, productIndex);
                    jobReplicatorList.add(c);
                }
            }
            if (jobReplicatorList.isEmpty()) {
                Collection<MCSSolution> substrateIndex = Collections.unmodifiableCollection(mcsSolutions);
                return substrateIndex;
            }
            TreeMap jobMap = new TreeMap();
            for (Combination c : jobReplicatorList) {
                int substrateIndex = c.getRowIndex();
                int productIndex = c.getColIndex();
                IAtomContainer educt = reactionStructureInformation.getEduct(substrateIndex);
                IAtomContainer product = reactionStructureInformation.getProduct(productIndex);
                boolean flag = false;
                for (Combination k : jobMap.keySet()) {
                    IAtomContainer eductJob = reactionStructureInformation.getEduct(k.getRowIndex());
                    IAtomContainer productJob = reactionStructureInformation.getProduct(k.getColIndex());
                    if (eductJob != educt || productJob != product || eductJob.getAtomCount() != educt.getAtomCount() || productJob.getAtomCount() != product.getAtomCount()) continue;
                    ((Set)jobMap.get(k)).add(c);
                    flag = true;
                    break;
                }
                if (flag) continue;
                TreeSet set = new TreeSet();
                jobMap.put(c, set);
            }
            int threadsAvailable = Runtime.getRuntime().availableProcessors() - 1;
            if (threadsAvailable == 0) {
                threadsAvailable = 1;
            }
            if (threadsAvailable > jobMap.size()) {
                threadsAvailable = jobMap.size();
            }
            if (threadsAvailable > 4) {
                threadsAvailable = 4;
            }
            executor = Executors.newFixedThreadPool(threadsAvailable);
            ExecutorCompletionService<MCSSolution> callablesQueue = new ExecutorCompletionService<MCSSolution>(executor);
            ArrayList<MCSThread> listOfJobs = new ArrayList<MCSThread>();
            for (Combination c : jobMap.keySet()) {
                MCSThread mcsThread;
                int substrateIndex = c.getRowIndex();
                int productIndex = c.getColIndex();
                IAtomContainer educt = reactionStructureInformation.getEduct(substrateIndex);
                IAtomContainer product = reactionStructureInformation.getProduct(productIndex);
                boolean ring = false;
                boolean ringSizeEqual = false;
                CycleFinder cycles = Cycles.or(Cycles.all(), Cycles.or(Cycles.relevant(), Cycles.essential()));
                Aromaticity aromaticity = new Aromaticity(ElectronDonation.daylight(), cycles);
                aromaticity.apply(educt);
                aromaticity.apply(product);
                cycles = Cycles.vertexShort();
                Cycles rings = cycles.find(educt);
                int numberOfCyclesEduct = rings.numberOfCycles();
                rings = cycles.find(product);
                int numberOfCyclesProduct = rings.numberOfCycles();
                if (numberOfCyclesEduct > 0 && numberOfCyclesProduct > 0) {
                    ring = true;
                }
                if (numberOfCyclesEduct == numberOfCyclesProduct) {
                    ringSizeEqual = true;
                }
                switch (mh.getTheory()) {
                    case MIN: {
                        mcsThread = new MCSThread(mh.getTheory(), substrateIndex, productIndex, educt, product);
                        mcsThread.setHasPerfectRings(ringSizeEqual);
                        mcsThread.setEductRingCount(numberOfCyclesEduct);
                        mcsThread.setProductRingCount(numberOfCyclesProduct);
                        break;
                    }
                    case MAX: {
                        mcsThread = new MCSThread(mh.getTheory(), substrateIndex, productIndex, educt, product);
                        mcsThread.setHasPerfectRings(ringSizeEqual);
                        mcsThread.setEductRingCount(numberOfCyclesEduct);
                        mcsThread.setProductRingCount(numberOfCyclesProduct);
                        break;
                    }
                    case MIXTURE: {
                        mcsThread = new MCSThread(mh.getTheory(), substrateIndex, productIndex, educt, product);
                        mcsThread.setHasPerfectRings(ringSizeEqual);
                        mcsThread.setEductRingCount(numberOfCyclesEduct);
                        mcsThread.setProductRingCount(numberOfCyclesProduct);
                        break;
                    }
                    case RINGS: {
                        mcsThread = new MCSThread(mh.getTheory(), substrateIndex, productIndex, educt, product);
                        mcsThread.setHasPerfectRings(ringSizeEqual);
                        mcsThread.setEductRingCount(numberOfCyclesEduct);
                        mcsThread.setProductRingCount(numberOfCyclesProduct);
                        break;
                    }
                    default: {
                        mcsThread = null;
                    }
                }
                if (mcsThread == null) continue;
                listOfJobs.add(mcsThread);
            }
            if (listOfJobs.size() > 1000) {
                System.err.println("holy moly...thats alot of molecules to compare...time for a coffee break!");
            }
            if (!listOfJobs.isEmpty()) {
                for (MCSThread mcsThreadJob : listOfJobs) {
                    callablesQueue.submit(mcsThreadJob);
                    ++taskCounter;
                }
            }
            Collection<MCSSolution> threadedUniqueMCSSolutions = Collections.synchronizedCollection(new ArrayList());
            for (int count = 0; count < taskCounter; ++count) {
                MCSSolution isomorphism = (MCSSolution)callablesQueue.take().get();
                threadedUniqueMCSSolutions.add(isomorphism);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            threadedUniqueMCSSolutions.stream().filter(mcs -> mcs != null).map(mcs -> {
                int queryPosition = mcs.getQueryPosition();
                int targetPosition = mcs.getTargetPosition();
                Combination referenceKey = null;
                for (Combination c : jobMap.keySet()) {
                    if (c.getRowIndex() != queryPosition || c.getColIndex() != targetPosition) continue;
                    referenceKey = c;
                    MCSSolution replicatedMCS = GraphMatcher.replicateMappingOnContainers(mh, c, mcs);
                    mcsSolutions.add(replicatedMCS);
                }
                return referenceKey;
            }).filter(removeKey -> removeKey != null).forEach(removeKey -> jobMap.remove(removeKey));
            jobReplicatorList.clear();
            System.gc();
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return Collections.unmodifiableCollection(mcsSolutions);
    }

    static MCSSolution replicateMappingOnContainers(Holder mh, Combination solution, MCSSolution mcs) {
        try {
            ReactionContainer reactionStructureInformation = mh.getReactionContainer();
            IAtomContainer q = reactionStructureInformation.getEduct(solution.getRowIndex());
            IAtomContainer t = reactionStructureInformation.getProduct(solution.getColIndex());
            int diff1 = q.getAtomCount() - mcs.getQueryContainer().getAtomCount();
            int diff2 = t.getAtomCount() - mcs.getTargetContainer().getAtomCount();
            AtomAtomMapping atomAtomMapping = mcs.getAtomAtomMapping();
            AtomAtomMapping atomAtomMappingNew = new AtomAtomMapping(q, t);
            atomAtomMapping.getMappingsByAtoms().keySet().stream().forEach(a -> {
                IAtom atomByID1 = GraphMatcher.getAtomByID(q, a);
                IAtom b = atomAtomMapping.getMappingsByAtoms().get(a);
                IAtom atomByID2 = GraphMatcher.getAtomByID(t, b);
                if (atomByID1 != null && atomByID2 != null) {
                    atomAtomMappingNew.put(atomByID1, atomByID2);
                } else {
                    LOGGER.error(Level.WARNING, "UnExpected NULL ATOM FOUND");
                    System.err.println("WARNING: UnExpected NULL ATOM FOUND");
                }
            });
            return new MCSSolution(solution.getRowIndex(), solution.getColIndex(), q, t, atomAtomMappingNew);
        }
        catch (IOException | CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static IAtom getAtomByID(IAtomContainer ac, IAtom atom) {
        if (atom.getID() == null) {
            return null;
        }
        for (IAtom a : ac.atoms()) {
            if (!a.getID().equals(atom.getID())) continue;
            return a;
        }
        return null;
    }
}

