/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.CircularFingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.Isomorphism;
import org.openscience.smsd.Substructure;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.interfaces.Algorithm;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.mapping.cache.ThreadSafeCache;
import uk.ac.ebi.reactionblast.mapping.graph.MCSSolution;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;

public class MCSThread
implements Callable<MCSSolution> {
    private static final boolean DEBUG1 = false;
    private static final boolean DEBUG2 = false;
    private static final boolean DEBUG3 = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSThread.class);
    private final SmilesGenerator smiles = new SmilesGenerator(1812);
    static final String NEW_LINE = System.getProperty("line.separator");
    protected final IAtomContainer compound1;
    protected final IAtomContainer compound2;
    protected final int queryPosition;
    protected final int targetPosition;
    protected final IMappingAlgorithm theory;
    long startTime;
    private boolean hasRings;
    private int numberOfCyclesEduct;
    private int numberOfCyclesProduct;

    MCSThread(IMappingAlgorithm theory, int queryPosition, int targetPosition, IAtomContainer educt, IAtomContainer product) throws CloneNotSupportedException, CDKException {
        this.compound1 = this.getNewContainerWithIDs(educt);
        this.compound2 = this.getNewContainerWithIDs(product);
        this.queryPosition = queryPosition;
        this.targetPosition = targetPosition;
        this.theory = theory;
        this.numberOfCyclesEduct = 0;
        this.numberOfCyclesProduct = 0;
    }

    synchronized void printMatch(BaseMapping isomorphism) {
        int overlap = isomorphism.getFirstAtomMapping().isEmpty() ? 0 : isomorphism.getFirstAtomMapping().getCount();
        try {
            System.out.println("Q: " + isomorphism.getQuery().getID() + " T: " + isomorphism.getTarget().getID() + " atoms: " + isomorphism.getQuery().getAtomCount() + " atoms: " + isomorphism.getTarget().getAtomCount() + " overlaps: " + overlap + " mcs " + isomorphism.getFirstAtomMapping().getCommonFragmentAsSMILES());
        }
        catch (CloneNotSupportedException | CDKException ex) {
            LOGGER.error(Level.SEVERE, "Print MCS ", ex.getMessage());
        }
    }

    @Override
    public synchronized MCSSolution call() throws Exception {
        boolean ringFlag = this.numberOfCyclesEduct > 0 && this.numberOfCyclesProduct > 0;
        try {
            Substructure substructure;
            BondMatcher bm;
            AtomMatcher am;
            IAtomContainer ac2;
            IAtomContainer ac1;
            boolean moleculeConnected = this.isMoleculeConnected(this.getCompound1(), this.getCompound2());
            boolean possibleVFmatch12 = this.isPossibleSubgraphMatch(this.getCompound1(), this.getCompound2());
            boolean possibleVFmatch21 = this.isPossibleSubgraphMatch(this.getCompound2(), this.getCompound1());
            if (moleculeConnected && possibleVFmatch12) {
                ac1 = this.duplicate(this.getCompound1());
                substructure = new Substructure(ac1, ac2 = this.duplicate(this.getCompound2()), am = AtomBondMatcher.atomMatcher(true, this.isHasPerfectRings()), bm = AtomBondMatcher.bondMatcher(false, this.isHasPerfectRings()), true);
                if (!substructure.isSubgraph() && !this.theory.equals((Object)IMappingAlgorithm.RINGS)) {
                    am = AtomBondMatcher.atomMatcher(false, ringFlag);
                    bm = AtomBondMatcher.bondMatcher(false, this.isHasPerfectRings());
                    substructure = new Substructure(ac1, ac2, am, bm, true);
                } else if (moleculeConnected && !substructure.isSubgraph()) {
                    am = AtomBondMatcher.atomMatcher(false, false);
                    bm = AtomBondMatcher.bondMatcher(false, this.isHasPerfectRings());
                    substructure = new Substructure(ac1, ac2, am, bm, true);
                }
                substructure.setChemFilters(true, true, true);
                if (substructure.isSubgraph() && substructure.getFirstAtomMapping().getCount() == ac1.getAtomCount()) {
                    MCSSolution mcs = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), substructure.getQuery(), substructure.getTarget(), substructure.getFirstAtomMapping());
                    mcs.setEnergy(substructure.getEnergyScore(0));
                    mcs.setFragmentSize(substructure.getFragmentSize(0));
                    mcs.setStereoScore(substructure.getStereoScore(0));
                    return mcs;
                }
            }
            if (moleculeConnected && !possibleVFmatch12 && possibleVFmatch21) {
                ac1 = this.duplicate(this.getCompound1());
                ac2 = this.duplicate(this.getCompound2());
                substructure = new Substructure(ac2, ac1, am = AtomBondMatcher.atomMatcher(true, this.isHasPerfectRings()), bm = AtomBondMatcher.bondMatcher(false, this.isHasPerfectRings()), true);
                if (!substructure.isSubgraph() && !this.theory.equals((Object)IMappingAlgorithm.RINGS)) {
                    am = AtomBondMatcher.atomMatcher(false, ringFlag);
                    bm = AtomBondMatcher.bondMatcher(false, this.isHasPerfectRings());
                    substructure = new Substructure(ac2, ac1, am, bm, true);
                } else if (moleculeConnected && !substructure.isSubgraph()) {
                    am = AtomBondMatcher.atomMatcher(false, false);
                    bm = AtomBondMatcher.bondMatcher(false, this.isHasPerfectRings());
                    substructure = new Substructure(ac2, ac1, am, bm, true);
                }
                substructure.setChemFilters(true, true, true);
                if (substructure.isSubgraph() && substructure.getFirstAtomMapping().getCount() == ac2.getAtomCount()) {
                    AtomAtomMapping aam = new AtomAtomMapping(substructure.getTarget(), substructure.getQuery());
                    Map<IAtom, IAtom> mappings = substructure.getFirstAtomMapping().getMappingsByAtoms();
                    mappings.keySet().stream().forEach(atom1 -> {
                        IAtom atom2 = (IAtom)mappings.get(atom1);
                        aam.put(atom2, (IAtom)atom1);
                    });
                    MCSSolution mcs = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), substructure.getTarget(), substructure.getQuery(), aam);
                    mcs.setEnergy(substructure.getEnergyScore(0));
                    mcs.setFragmentSize(substructure.getFragmentSize(0));
                    mcs.setStereoScore(substructure.getStereoScore(0));
                    return mcs;
                }
            }
            MCSSolution mcs = this.mcs();
            return mcs;
        }
        catch (CloneNotSupportedException | CDKException ex) {
            LOGGER.error(Level.SEVERE, "Error in generating MCS Solution: ", ex.getMessage());
            return null;
        }
    }

    private synchronized IAtomContainer getNewContainerWithIDs(IAtomContainer mol) throws CDKException, CloneNotSupportedException {
        if (mol != null && mol.getAtomCount() > 0) {
            IAtomContainer ac = ExtAtomContainerManipulator.cloneWithIDs(mol);
            Aromaticity aromaticity = new Aromaticity(ElectronDonation.daylight(), Cycles.or(Cycles.all(), Cycles.or(Cycles.relevant(), Cycles.essential())));
            aromaticity.apply(ac);
            try {
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
                MoleculeInitializer.initializeMolecule(ac);
            }
            catch (Exception ex) {
                LOGGER.error(Level.SEVERE, "WARNING: Error in Config. r.mol: ", ex.getMessage());
            }
            for (int i = 0; i < ac.getAtomCount(); ++i) {
                String atomID = mol.getAtom(i).getID() == null ? String.valueOf(i) : mol.getAtom(i).getID();
                ac.getAtom(i).setID(atomID);
            }
            String containerID = mol.getID() == null ? String.valueOf(System.nanoTime()) : mol.getID();
            ac.setID(containerID);
            return ac;
        }
        return mol;
    }

    private synchronized boolean isPossibleSubgraphMatch(IAtomContainer q, IAtomContainer t) {
        int counter;
        TreeMap<String, Integer> atomUniqueCounter1 = new TreeMap<String, Integer>();
        TreeMap<String, Integer> atomUniqueCounter2 = new TreeMap<String, Integer>();
        for (IAtom a : q.atoms()) {
            if (!atomUniqueCounter1.containsKey(a.getSymbol())) {
                atomUniqueCounter1.put(a.getSymbol(), 1);
                continue;
            }
            counter = (Integer)atomUniqueCounter1.get(a.getSymbol()) + 1;
            atomUniqueCounter1.put(a.getSymbol(), counter);
        }
        for (IAtom b : t.atoms()) {
            if (!atomUniqueCounter2.containsKey(b.getSymbol())) {
                atomUniqueCounter2.put(b.getSymbol(), 1);
                continue;
            }
            counter = (Integer)atomUniqueCounter2.get(b.getSymbol()) + 1;
            atomUniqueCounter2.put(b.getSymbol(), counter);
        }
        if (atomUniqueCounter1.size() > atomUniqueCounter2.size()) {
            return false;
        }
        LinkedList difference = new LinkedList(atomUniqueCounter1.keySet());
        difference.removeAll(atomUniqueCounter2.keySet());
        if (difference.isEmpty() && !atomUniqueCounter1.keySet().stream().noneMatch(k -> (Integer)atomUniqueCounter1.get(k) > (Integer)atomUniqueCounter2.get(k))) {
            return false;
        }
        return difference.isEmpty();
    }

    private synchronized int expectedMaxGraphmatch(IAtomContainer q, IAtomContainer t) {
        String hyb;
        ArrayList<String> atomUniqueCounter1 = new ArrayList<String>();
        ArrayList<String> atomUniqueCounter2 = new ArrayList<String>();
        for (IAtom a : q.atoms()) {
            hyb = a.getHybridization() == CDKConstants.UNSET ? a.getSymbol() : a.getAtomTypeName();
            atomUniqueCounter1.add(hyb);
        }
        for (IAtom b : t.atoms()) {
            hyb = b.getHybridization() == CDKConstants.UNSET ? b.getSymbol() : b.getAtomTypeName();
            atomUniqueCounter2.add(hyb);
        }
        Collections.sort(atomUniqueCounter1);
        Collections.sort(atomUniqueCounter2);
        if (atomUniqueCounter1.isEmpty()) {
            return 0;
        }
        LinkedList common = new LinkedList(atomUniqueCounter1);
        common.retainAll(atomUniqueCounter2);
        atomUniqueCounter1.clear();
        atomUniqueCounter2.clear();
        return common.size();
    }

    synchronized MCSSolution mcs() throws CDKException, CloneNotSupportedException {
        MCSSolution mcs;
        boolean ringSizeMatch;
        boolean ringMatch;
        boolean bondMatch;
        boolean atomType;
        IAtomContainer ac1 = this.duplicate(this.getCompound1());
        IAtomContainer ac2 = this.duplicate(this.getCompound2());
        int expectedMaxGraphmatch = this.expectedMaxGraphmatch(ac1, ac2);
        boolean ringFlag = this.numberOfCyclesEduct > 0 && this.numberOfCyclesProduct > 0;
        switch (this.theory) {
            case RINGS: {
                atomType = false;
                bondMatch = false;
                ringMatch = ringFlag;
                ringSizeMatch = this.isHasPerfectRings();
                break;
            }
            case MIN: {
                atomType = false;
                bondMatch = false;
                ringMatch = this.isHasPerfectRings();
                ringSizeMatch = false;
                break;
            }
            case MAX: {
                atomType = false;
                bondMatch = true;
                ringMatch = this.isHasPerfectRings();
                ringSizeMatch = false;
                break;
            }
            default: {
                atomType = false;
                bondMatch = false;
                ringMatch = this.isHasPerfectRings();
                ringSizeMatch = false;
            }
        }
        AtomMatcher am = AtomBondMatcher.atomMatcher(atomType, ringSizeMatch);
        BondMatcher bm = AtomBondMatcher.bondMatcher(bondMatch, ringMatch);
        String key = this.generateUniqueKey(this.getCompound1().getID(), this.getCompound2().getID(), this.compound1.getAtomCount(), this.compound2.getAtomCount(), this.compound1.getBondCount(), this.compound2.getBondCount(), atomType, bondMatch, ringMatch, ringSizeMatch, this.numberOfCyclesEduct, this.numberOfCyclesProduct);
        if (ThreadSafeCache.getInstance().containsKey(key)) {
            MCSSolution solution = (MCSSolution)ThreadSafeCache.getInstance().get(key);
            mcs = this.copyOldSolutionToNew(this.getQueryPosition(), this.getTargetPosition(), this.getCompound1(), this.getCompound2(), solution);
        } else {
            Isomorphism isomorphism = new Isomorphism(ac1, ac2, Algorithm.VFLibMCS, am, bm);
            mcs = this.addMCSSolution(key, ThreadSafeCache.getInstance(), isomorphism);
        }
        return mcs;
    }

    private synchronized IAtomContainer duplicate(IAtomContainer ac) throws CloneNotSupportedException {
        IAtomContainer a = ac.clone();
        a.setID(ac.getID());
        for (int i = 0; i < a.getAtomCount(); ++i) {
            a.getAtom(i).setID(ac.getAtom(i).getID());
        }
        ac.setProperties(ac.getProperties());
        ac.setFlags(ac.getFlags());
        ac.setID(ac.getID());
        ac.notifyChanged();
        return a;
    }

    synchronized IAtomContainer getCompound1() {
        return this.compound1;
    }

    synchronized IAtomContainer getCompound2() {
        return this.compound2;
    }

    synchronized int getQueryPosition() {
        return this.queryPosition;
    }

    synchronized int getTargetPosition() {
        return this.targetPosition;
    }

    synchronized void setHasPerfectRings(boolean ring) {
        this.hasRings = ring;
    }

    synchronized boolean isHasPerfectRings() {
        return this.hasRings;
    }

    private synchronized boolean isMoleculeConnected(IAtomContainer compound1, IAtomContainer compound2) {
        boolean connected1 = true;
        IAtomContainerSet partitionIntoMolecules = ConnectivityChecker.partitionIntoMolecules(compound1);
        if (partitionIntoMolecules.getAtomContainerCount() > 1) {
            connected1 = false;
        }
        boolean connected2 = true;
        partitionIntoMolecules = ConnectivityChecker.partitionIntoMolecules(compound2);
        if (partitionIntoMolecules.getAtomContainerCount() > 1) {
            connected2 = false;
        }
        return connected1 & connected2;
    }

    synchronized void setEductRingCount(int numberOfCyclesEduct) {
        this.numberOfCyclesEduct = numberOfCyclesEduct;
    }

    synchronized void setProductRingCount(int numberOfCyclesProduct) {
        this.numberOfCyclesProduct = numberOfCyclesProduct;
    }

    synchronized String generateUniqueKey(String id1, String id2, int atomCount1, int atomCount2, int bondCount1, int bondCount2, boolean atomtypeMatcher, boolean bondMatcher, boolean ringMatcher, boolean hasPerfectRings, int numberOfCyclesEduct, int numberOfCyclesProduct) {
        StringBuilder key = new StringBuilder();
        key.append(id1).append(id2).append(atomCount1).append(atomCount2).append(bondCount1).append(bondCount2).append(atomtypeMatcher).append(bondMatcher).append(ringMatcher).append(hasPerfectRings).append(numberOfCyclesEduct).append(numberOfCyclesProduct);
        try {
            try {
                int[] sm1 = this.getCircularFP(this.compound1);
                int[] sm2 = this.getCircularFP(this.compound2);
                key.append(Arrays.toString(sm1));
                key.append(Arrays.toString(sm2));
            }
            catch (Exception ex) {
                LOGGER.error(Level.SEVERE, "Error in Generating Circular FP: ", ex);
            }
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, "Error in generating Unique Key: ", ex.getMessage());
        }
        return key.toString();
    }

    private synchronized int[] getCircularFP(IAtomContainer mol) throws CDKException {
        CircularFingerprinter circularFingerprinter = new CircularFingerprinter(6, 1024);
        circularFingerprinter.setPerceiveStereo(true);
        IBitFingerprint bitFingerprint = circularFingerprinter.getBitFingerprint(mol);
        return bitFingerprint.getSetbits();
    }

    synchronized MCSSolution copyOldSolutionToNew(int queryPosition, int targetPosition, IAtomContainer compound1, IAtomContainer compound2, MCSSolution oldSolution) {
        AtomAtomMapping atomAtomMapping = oldSolution.getAtomAtomMapping();
        Map<Integer, Integer> mappingsByIndex = atomAtomMapping.getMappingsByIndex();
        AtomAtomMapping atomAtomMappingNew = new AtomAtomMapping(compound1, compound2);
        mappingsByIndex.entrySet().forEach(m -> atomAtomMappingNew.put(compound1.getAtom((Integer)m.getKey()), compound2.getAtom((Integer)m.getValue())));
        MCSSolution mcsSolution = new MCSSolution(queryPosition, targetPosition, compound1, compound2, atomAtomMappingNew);
        mcsSolution.setEnergy(oldSolution.getEnergy());
        mcsSolution.setFragmentSize(oldSolution.getFragmentSize());
        mcsSolution.setStereoScore(oldSolution.getStereoScore());
        return mcsSolution;
    }

    synchronized MCSSolution addMCSSolution(String key, ThreadSafeCache<String, MCSSolution> mappingcache, Isomorphism isomorphism) {
        isomorphism.setChemFilters(true, true, true);
        MCSSolution mcs = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), isomorphism.getQuery(), isomorphism.getTarget(), isomorphism.getFirstAtomMapping());
        mcs.setEnergy(isomorphism.getEnergyScore(0));
        mcs.setFragmentSize(isomorphism.getFragmentSize(0));
        mcs.setStereoScore(isomorphism.getStereoScore(0));
        if (!mappingcache.containsKey(key)) {
            mappingcache.put(key, mcs);
        }
        return mcs;
    }
}

