/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.helper;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.Isomorphism;
import org.openscience.smsd.interfaces.IAtomMapping;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.ChooseWinner;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.tools.BasicDebugger;
import uk.ac.ebi.reactionblast.tools.CDKSMILES;
import uk.ac.ebi.reactionblast.tools.EBIMatrix;
import uk.ac.ebi.reactionblast.tools.ImageGenerator;

public abstract class Debugger
extends BasicDebugger {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Debugger.class);

    protected void printMatrixAtomContainer(Holder mh, List<String> EdMap, List<String> PdMap) {
        try {
            CDKSMILES sm;
            int i;
            ReactionContainer _rSTMap = mh.getReactionContainer();
            System.out.println("<--------Atom Size in the Container-------->");
            for (i = 0; i < EdMap.size(); ++i) {
                System.out.println("Educt " + EdMap.get(i) + " : " + _rSTMap.getEduct(i).getAtomCount());
                if (!_rSTMap.getEduct(i).isEmpty()) {
                    sm = new CDKSMILES(_rSTMap.getEduct(i), true, false);
                    System.out.println("SMILES: " + sm.getCanonicalSMILES());
                }
                Debugger.printAtoms(_rSTMap.getEduct(i));
            }
            System.out.println();
            for (i = 0; i < PdMap.size(); ++i) {
                System.out.println("Product " + PdMap.get(i) + " : " + _rSTMap.getProduct(i).getAtomCount());
                if (!_rSTMap.getProduct(i).isEmpty()) {
                    sm = new CDKSMILES(_rSTMap.getProduct(i), true, false);
                    System.out.println("SMILES: " + sm.getCanonicalSMILES());
                }
                Debugger.printAtoms(_rSTMap.getProduct(i));
            }
            System.out.println();
        }
        catch (IOException | CloneNotSupportedException | CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    protected void printCliqueMatrix(Holder mh, List<String> EdMap, List<String> PdMap) {
        ReactionContainer reactionStructureInformationContainer = mh.getReactionContainer();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Clique Matrix");
            System.out.print("\t\t");
            for (int j = 0; j < PdMap.size(); ++j) {
                System.out.print(" " + PdMap.get(j) + ":(" + reactionStructureInformationContainer.getProduct(j).getAtomCount() + ")");
            }
            System.out.println();
            for (int i = 0; i < EdMap.size(); ++i) {
                System.out.print(" " + EdMap.get(i) + ":(" + reactionStructureInformationContainer.getEduct(i).getAtomCount() + ")");
                for (int j = 0; j < PdMap.size(); ++j) {
                    double val = mh.getCliqueMatrix().getValue(i, j);
                    String result = format.format(val);
                    System.out.print("   " + result);
                }
                System.out.println();
            }
        }
        catch (IOException | CDKException e) {
            LOGGER.debug("Parser Error" + e);
        }
        System.out.println();
    }

    protected void printSimMatrix(Holder mh, List<String> EdMap, List<String> PdMap) {
        ReactionContainer reactionStructureInformationContainer = mh.getReactionContainer();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Similarity Matrix");
            System.out.print("\t\t");
            for (int j = 0; j < PdMap.size(); ++j) {
                System.out.print(" " + PdMap.get(j) + ":(" + reactionStructureInformationContainer.getProduct(j).getAtomCount() + ")");
            }
            System.out.println();
            for (int i = 0; i < EdMap.size(); ++i) {
                System.out.print(" " + EdMap.get(i) + ":(" + reactionStructureInformationContainer.getEduct(i).getAtomCount() + ")");
                for (int j = 0; j < PdMap.size(); ++j) {
                    double val = mh.getGraphSimilarityMatrix().getValue(i, j);
                    String result = format.format(val);
                    System.out.print("   " + result);
                }
                System.out.println();
            }
        }
        catch (IOException | CDKException e) {
            LOGGER.debug("Parser Error" + e);
        }
        System.out.println();
    }

    protected void printFlagMatrix(ChooseWinner winner, List<String> EdMap, List<String> PdMap) {
        System.out.println();
        System.out.println("********* MATRIX **********");
        boolean[][] FlagMatrix = winner.getFlagMatrix();
        System.out.println("Flag Matrix");
        System.out.print("\t\t");
        PdMap.forEach(PdMap1 -> System.out.print("  " + PdMap1 + " "));
        System.out.println();
        for (int i = 0; i < EdMap.size(); ++i) {
            System.out.print(" " + EdMap.get(i));
            for (int j = 0; j < PdMap.size(); ++j) {
                if (FlagMatrix[i][j]) {
                    System.out.print("      1  ");
                    continue;
                }
                System.out.print("      0  ");
            }
            System.out.println();
        }
    }

    protected void printStereoMatrix(Holder mh, List<String> EdMap, List<String> PdMap) {
        EBIMatrix StereoMatrix = mh.getStereoMatrix();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Stereo Matrix");
            System.out.print("\t\t");
            PdMap.forEach(PdMap1 -> System.out.print(" " + PdMap1));
            System.out.println();
            for (int i = 0; i < EdMap.size(); ++i) {
                System.out.print(" " + EdMap.get(i));
                for (int j = 0; j < PdMap.size(); ++j) {
                    double val = StereoMatrix.getValue(i, j);
                    String result = format.format(val);
                    System.out.print("   " + result);
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Parser Error" + e);
        }
        System.out.println();
    }

    protected void printFragmentMatrix(Holder mh, List<String> EdMap, List<String> PdMap) {
        EBIMatrix fragmentMatrix = mh.getFragmentMatrix();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Fragment Matrix");
            System.out.print("\t\t");
            PdMap.forEach(PdMap1 -> System.out.print(" " + PdMap1));
            System.out.println();
            for (int i = 0; i < EdMap.size(); ++i) {
                System.out.print(" " + EdMap.get(i));
                for (int j = 0; j < PdMap.size(); ++j) {
                    double val = fragmentMatrix.getValue(i, j);
                    String result = format.format(val);
                    System.out.print("   " + result);
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Parser Error" + e);
        }
        System.out.println();
    }

    protected void printCarbonMatrix(Holder mh, List<String> EdMap, List<String> PdMap) {
        EBIMatrix carbonMatrix = mh.getCarbonOverlapMatrix();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Fragment Matrix");
            System.out.print("\t\t");
            PdMap.forEach(PdMap1 -> System.out.print(" " + PdMap1));
            System.out.println();
            for (int i = 0; i < EdMap.size(); ++i) {
                System.out.print(" " + EdMap.get(i));
                for (int j = 0; j < PdMap.size(); ++j) {
                    double val = carbonMatrix.getValue(i, j);
                    String result = format.format(val);
                    System.out.print("   " + result);
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Parser Error" + e);
        }
        System.out.println();
    }

    protected void printEnergyMatrix(Holder mh, List<String> EdMap, List<String> PdMap) {
        EBIMatrix energyMatrixProfile = mh.getEnergyMatrix();
        System.out.println();
        System.out.println("********* MATRIX **********");
        try {
            DecimalFormat format = new DecimalFormat("0.00");
            System.out.println("Energy Matrix");
            System.out.print("\t\t");
            PdMap.forEach(PdMap1 -> System.out.print("\t" + PdMap1));
            System.out.println();
            for (int i = 0; i < EdMap.size(); ++i) {
                System.out.print("\t" + EdMap.get(i));
                for (int j = 0; j < PdMap.size(); ++j) {
                    double val = energyMatrixProfile.getValue(i, j);
                    String result = format.format(val);
                    System.out.print("\t" + result);
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Parser Error" + e);
        }
        System.out.println();
    }

    protected void printGraphMatching(IAtomMapping comparison, IAtomContainer mol1, IAtomContainer mol2) {
        int count_final_sol = 0;
        System.out.println("Output of the final Mappings: ");
        System.out.println("Mol1: " + mol1.getID());
        System.out.println("Mol2: " + mol2.getID());
        try {
            if (comparison.getMappingCount() > 0) {
                for (AtomAtomMapping final_solution : comparison.getAllAtomMapping()) {
                    int final_solution_size = final_solution.getCount();
                    System.out.println("Final mapping Nr. " + ++count_final_sol + " Size:" + final_solution_size);
                    final_solution.getMappingsByAtoms().entrySet().forEach(mapping -> {
                        IAtom eAtom = (IAtom)mapping.getKey();
                        IAtom pAtom = (IAtom)mapping.getValue();
                        System.out.println(mol1.indexOf(eAtom) + 1 + " " + (mol2.indexOf(pAtom) + 1));
                        System.out.println(eAtom.getSymbol() + " " + pAtom.getSymbol());
                    });
                    System.out.println("");
                    System.out.println("Stereo Match: " + comparison.getStereoScore(count_final_sol - 1));
                    System.out.println("Stereo different: " + comparison.isStereoMisMatch());
                    System.out.println("Fragment Size: " + comparison.getFragmentSize(count_final_sol - 1));
                }
                System.out.println("");
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Parser Error" + ex);
        }
    }

    protected void generateImage(String outPutFileName, IAtomContainer query2, IAtomContainer target, Isomorphism smsd) {
        ImageGenerator imageGenerator = new ImageGenerator();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        System.out.println("Output of the final Mappings: ");
        int counter = 1;
        for (AtomAtomMapping mapping : smsd.getAllAtomMapping()) {
            String tanimoto = nf.format(smsd.getTanimotoSimilarity());
            String stereo = "NA";
            if (smsd.getStereoScore(counter - 1) != null) {
                stereo = nf.format(smsd.getStereoScore(counter - 1));
            }
            String label = "Scores [Tanimoto: " + tanimoto + ", Stereo: " + stereo + "]";
            try {
                imageGenerator.addImages(query2, target, label, mapping);
            }
            catch (Exception ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            ++counter;
        }
        String filePNG = System.getProperty("user.dir") + File.separator + outPutFileName;
        imageGenerator.createImage(filePNG, "Query", "Target");
    }

    protected void printSMILES(Holder mh, int substrateIndex, int productIndex) throws CloneNotSupportedException, IOException, CDKException {
        ReactionContainer reactionStructureInformation = mh.getReactionContainer();
        String cdkSmilesE = new CDKSMILES(reactionStructureInformation.getEduct(substrateIndex), false, false).getCanonicalSMILES();
        String cdkSmilesP = new CDKSMILES(reactionStructureInformation.getProduct(productIndex), false, false).getCanonicalSMILES();
        System.out.println("A: " + reactionStructureInformation.getEduct(substrateIndex).getID() + " " + cdkSmilesE + " B: " + reactionStructureInformation.getProduct(productIndex).getID() + " " + cdkSmilesP);
        System.out.println("A: " + reactionStructureInformation.getEduct(substrateIndex).getAtomCount() + " B: " + reactionStructureInformation.getProduct(productIndex).getAtomCount());
        System.out.println(" GetValue: " + mh.getGraphSimilarityMatrix().getValue(substrateIndex, productIndex) + ", " + mh.getStereoMatrix().getValue(substrateIndex, productIndex));
    }
}

