/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.helper;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;

public class IOReaction {
    static final String NEW_LINE = System.getProperty("line.separator");

    private static void printReaction(IReaction reaction) {
        IAtomContainer M;
        int j;
        IAtomContainerSet Educt = reaction.getReactants();
        IAtomContainerSet Product2 = reaction.getProducts();
        System.out.println("*******************************");
        System.out.println("Educt Mol Count: " + Educt.getAtomContainerCount());
        System.out.println("*******************************");
        for (j = 0; j < Educt.getAtomContainerCount(); ++j) {
            M = Educt.getAtomContainer(j);
            System.out.println("Mol ID: " + M.getID());
            System.out.println("Stoic: " + reaction.getReactantCoefficient(M));
            System.out.println("Split Mol Atom Count: " + M.getAtomCount());
            IOReaction.printAtoms(M);
        }
        System.out.println("*******************************");
        System.out.println("Product Mol Count: " + Product2.getAtomContainerCount());
        System.out.println("*******************************");
        for (j = 0; j < Product2.getAtomContainerCount(); ++j) {
            M = Product2.getAtomContainer(j);
            System.out.println("Mol ID: " + M.getID());
            System.out.println("Stoic: " + reaction.getProductCoefficient(M));
            System.out.println("Split Mol Atom Count: " + M.getAtomCount());
            IOReaction.printAtoms(M);
        }
        System.out.println(NEW_LINE + "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" + NEW_LINE + NEW_LINE);
    }

    private static void printAtoms(IAtomContainer mol) {
        System.out.print("Atom: ");
        for (IAtom a : mol.atoms()) {
            System.out.print(a.getSymbol());
        }
        System.out.println();
        System.out.println();
    }

    private IOReaction() {
    }
}

