/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockPair;
import uk.ac.ebi.reactionblast.mapping.blocks.MappingGraph;
import uk.ac.ebi.reactionblast.mechanism.interfaces.ECBLAST_BOND_CHANGE_FLAGS;
import uk.ac.ebi.reactionblast.mechanism.interfaces.ECBLAST_FLAGS;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;

public class RBlastReaction {
    private IReaction reaction;
    private List<BlockPair> blockPairs;
    private List<IBond> bondsCleavedInReactant;
    private List<IBond> bondsFormedInProduct;
    private List<IBond> bondsOrderChangedInProduct;
    private List<IBond> bondsOrderChangedInReactant;
    private List<IBond> bondsStereoChangedInProduct;
    private List<IBond> bondsStereoChangedInReactant;
    private Map<IAtom, IStereoAndConformation> atomStereoProductMap;
    private Map<IAtom, IStereoAndConformation> atomStereoReactantMap;

    public RBlastReaction(IReaction reaction, boolean useMappingGraph) {
        this.reaction = reaction;
        if (useMappingGraph) {
            MappingGraph mappingGraph = new MappingGraph(reaction);
            this.blockPairs = mappingGraph.createBlockPairs(reaction);
        } else {
            this.blockPairs = new ArrayList<BlockPair>();
        }
        this.setupBondChangeLists(reaction);
    }

    public RBlastReaction(IReaction reaction, BlockPair pair2) {
        this.reaction = reaction;
        this.blockPairs = new ArrayList<BlockPair>();
        this.blockPairs.add(pair2);
        this.setupBondChangeLists(reaction);
    }

    public RBlastReaction(IReaction reaction, List<BlockPair> pairs) {
        this.reaction = reaction;
        this.blockPairs = new ArrayList<BlockPair>();
        this.blockPairs.addAll(pairs);
        this.setupBondChangeLists(reaction);
    }

    private void setupBondChangeLists(IReaction reaction) {
        this.bondsCleavedInReactant = new ArrayList<IBond>();
        this.bondsFormedInProduct = new ArrayList<IBond>();
        this.bondsOrderChangedInReactant = new ArrayList<IBond>();
        this.bondsOrderChangedInProduct = new ArrayList<IBond>();
        this.bondsStereoChangedInReactant = new ArrayList<IBond>();
        this.bondsStereoChangedInProduct = new ArrayList<IBond>();
        this.atomStereoProductMap = new HashMap<IAtom, IStereoAndConformation>();
        this.atomStereoReactantMap = new HashMap<IAtom, IStereoAndConformation>();
        this.setupBondChangeLists(reaction.getReactants(), true);
        this.setupBondChangeLists(reaction.getProducts(), false);
        this.setupAtomChangeLists(reaction.getReactants(), this.atomStereoProductMap);
        this.setupAtomChangeLists(reaction.getProducts(), this.atomStereoReactantMap);
    }

    private void setupAtomChangeLists(IAtomContainerSet molSet, Map<IAtom, IStereoAndConformation> mapToAddTo) {
        for (IAtomContainer atomContainer : molSet.atomContainers()) {
            for (IAtom atom : atomContainer.atoms()) {
                if (atom.getProperty((Object)ECBLAST_FLAGS.ATOM_STEREO_CHANGE_INFORMATION) == null) continue;
                IStereoAndConformation flag = (IStereoAndConformation)atom.getProperty((Object)ECBLAST_FLAGS.ATOM_STEREO_CHANGE_INFORMATION);
                if (flag == IStereoAndConformation.R) {
                    mapToAddTo.put(atom, IStereoAndConformation.R);
                } else if (flag == IStereoAndConformation.S) {
                    mapToAddTo.put(atom, IStereoAndConformation.S);
                }
                if (flag == IStereoAndConformation.Z) {
                    mapToAddTo.put(atom, IStereoAndConformation.Z);
                    continue;
                }
                if (flag != IStereoAndConformation.E) continue;
                mapToAddTo.put(atom, IStereoAndConformation.E);
            }
            for (IBond bond : atomContainer.bonds()) {
                for (IAtom atom : bond.atoms()) {
                    if (atom.getProperty((Object)ECBLAST_FLAGS.ATOM_STEREO_CHANGE_INFORMATION) == null) continue;
                    IStereoAndConformation flag = (IStereoAndConformation)atom.getProperty((Object)ECBLAST_FLAGS.ATOM_STEREO_CHANGE_INFORMATION);
                    if (flag == IStereoAndConformation.R) {
                        mapToAddTo.put(atom, IStereoAndConformation.R);
                    } else if (flag == IStereoAndConformation.S) {
                        mapToAddTo.put(atom, IStereoAndConformation.S);
                    }
                    if (flag == IStereoAndConformation.Z) {
                        mapToAddTo.put(atom, IStereoAndConformation.Z);
                        continue;
                    }
                    if (flag != IStereoAndConformation.E) continue;
                    mapToAddTo.put(atom, IStereoAndConformation.E);
                }
            }
        }
    }

    private void setupBondChangeLists(IAtomContainerSet molSet, boolean isReactant) {
        for (IAtomContainer atomContainer : molSet.atomContainers()) {
            this.setupBondChangeLists(atomContainer, isReactant);
        }
    }

    private void setupBondChangeLists(IAtomContainer atomContainer, boolean isReactant) {
        for (IBond bond : atomContainer.bonds()) {
            ECBLAST_BOND_CHANGE_FLAGS bondChangeType;
            if (bond.getProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION) == null || null == (bondChangeType = (ECBLAST_BOND_CHANGE_FLAGS)((Object)bond.getProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION)))) continue;
            switch (bondChangeType) {
                case BOND_CLEAVED: {
                    this.bondsCleavedInReactant.add(bond);
                    break;
                }
                case BOND_FORMED: {
                    this.bondsFormedInProduct.add(bond);
                    break;
                }
                case BOND_ORDER: {
                    if (isReactant) {
                        this.bondsOrderChangedInReactant.add(bond);
                        break;
                    }
                    this.bondsOrderChangedInProduct.add(bond);
                    break;
                }
                case BOND_STEREO: {
                    if (isReactant) {
                        this.bondsStereoChangedInReactant.add(bond);
                        break;
                    }
                    this.bondsStereoChangedInProduct.add(bond);
                    break;
                }
                case BOND_FORMED_OR_CLEAVED: {
                    if (isReactant) {
                        this.bondsCleavedInReactant.add(bond);
                        break;
                    }
                    this.bondsFormedInProduct.add(bond);
                    break;
                }
            }
        }
    }

    public List<IBond> getBondsStereoChangedInProduct() {
        return Collections.unmodifiableList(this.bondsStereoChangedInProduct);
    }

    public List<IBond> getBondsStereoChangedInReactant() {
        return Collections.unmodifiableList(this.bondsStereoChangedInReactant);
    }

    public IReaction getReaction() {
        return this.reaction;
    }

    public void setReaction(IReaction reaction) {
        this.reaction = reaction;
    }

    public List<BlockPair> getMappedSubgraphs() {
        return Collections.unmodifiableList(this.blockPairs);
    }

    public List<IBond> getBondsCleavedInReactant() {
        return Collections.unmodifiableList(this.bondsCleavedInReactant);
    }

    public List<IBond> getBondsFormedInProduct() {
        return Collections.unmodifiableList(this.bondsFormedInProduct);
    }

    public List<IBond> getBondsOrderChangedInProduct() {
        return Collections.unmodifiableList(this.bondsOrderChangedInProduct);
    }

    public List<IBond> getBondsOrderChangedInReactant() {
        return Collections.unmodifiableList(this.bondsOrderChangedInReactant);
    }

    public Map<IAtom, IStereoAndConformation> getAtomStereoProductMap() {
        return Collections.unmodifiableMap(this.atomStereoProductMap);
    }

    public Map<IAtom, IStereoAndConformation> getAtomStereoReactantMap() {
        return Collections.unmodifiableMap(this.atomStereoReactantMap);
    }
}

