/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.EBIMatrix;
import uk.ac.ebi.reactionblast.tools.ValencyCalculator;

public class BEMatrix
extends EBIMatrix
implements Serializable {
    private static final long serialVersionUID = -1420740601548197863L;
    private IAtomContainerSet myMoleculeSet = null;
    private List<IBond> bonds = null;
    private List<IAtom> atomArray = null;
    private final boolean withoutH;
    private final Map<IAtom, IAtom> mappings;

    public BEMatrix(boolean skipHydrogen, IAtomContainerSet molSet, List<IBond> bonds, Map<IAtom, IAtom> mappings) {
        super(0, 0);
        this.withoutH = skipHydrogen;
        this.atomArray = new LinkedList<IAtom>();
        this.myMoleculeSet = molSet;
        this.bonds = bonds;
        this.mappings = mappings;
    }

    void setMatrixAtoms() throws CDKException {
        this.initMatrix(0.0);
        this.atomArray.clear();
        for (IAtomContainer container : this.myMoleculeSet.atomContainers()) {
            for (IAtom atom : container.atoms()) {
                if (this.withoutH && atom.getSymbol().matches("H") || !this.mappings.containsKey(atom) && !this.mappings.containsValue(atom)) continue;
                this.atomArray.add(atom);
            }
        }
        this.setMatrix();
    }

    public int getOrder(IAtom a1, IAtom a2) {
        return (int)this.getValue(this.getIndexOfAtomID(a1.getID()), this.getIndexOfAtomID(a2.getID()));
    }

    private void setMatrix() throws CDKException {
        int i;
        this.reSizeMatrix(this.atomArray.size() + 1, this.atomArray.size() + 1);
        for (i = 0; i < this.atomArray.size(); ++i) {
            this.setValue(i, i, this.getFreeValenceElectrons(this.atomArray.get(i)));
        }
        for (i = 0; i < this.atomArray.size(); ++i) {
            for (int j = 0; j < this.atomArray.size(); ++j) {
                if (i == j) continue;
                this.setValue(i, j, this.getBondOrder(this.atomArray.get(i), this.atomArray.get(j)));
                this.setValue(j, i, this.getBondOrder(this.atomArray.get(i), this.atomArray.get(j)));
            }
        }
        for (i = 0; i < this.atomArray.size(); ++i) {
            this.setValue(this.atomArray.size(), i, 100.0);
            this.setValue(i, this.atomArray.size(), 100.0);
        }
        this.setValue(this.atomArray.size(), this.atomArray.size(), 200.0);
    }

    public int[] orderAtomArray(List<IAtom> orderedAtomArray) throws CDKException {
        int[] canonicalIndex = new int[orderedAtomArray.size()];
        if (orderedAtomArray.size() != this.atomArray.size()) {
            throw new CDKException("The matrix has not been ordered: " + this.atomArray.size() + " !=" + orderedAtomArray.size());
        }
        for (IAtom orderedAtom : orderedAtomArray) {
            if (this.getIndexOfAtomID(orderedAtom.getID()) != -1) continue;
            throw new CDKException("The matrix has not been ordered");
        }
        for (int i = 0; i < orderedAtomArray.size(); ++i) {
            int di = this.getIndexOfAtomID(orderedAtomArray.get(i).getID());
            if (di != i) {
                this.pivot(di, i);
            }
            canonicalIndex[i] = di;
        }
        return canonicalIndex;
    }

    private int getIndexOfAtomID(String atomID) {
        int ind = -1;
        for (int i = 0; i < this.atomArray.size(); ++i) {
            if (!this.atomArray.get(i).getID().equals(atomID)) continue;
            ind = i;
        }
        return ind;
    }

    @Override
    public void pivot(int i1, int i2) {
        int i;
        IAtom appA = this.atomArray.get(i1);
        this.atomArray.set(i1, this.atomArray.get(i2));
        this.atomArray.set(i2, appA);
        double appD = 0.0;
        for (i = 0; i < this.getRowDimension(); ++i) {
            appD = this.getValue(i, i1);
            this.setValue(i, i1, this.getValue(i, i2));
            this.setValue(i, i2, appD);
        }
        for (i = 0; i < this.getColumnDimension(); ++i) {
            appD = this.getValue(i1, i);
            this.setValue(i1, i, this.getValue(i2, i));
            this.setValue(i2, i, appD);
        }
    }

    private double getFreeValenceElectrons(IAtom a) throws CDKException {
        double freeValEle = 0.0;
        for (int i = 0; i < this.myMoleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer mol = this.myMoleculeSet.getAtomContainer(i);
            if (!mol.contains(a)) continue;
            freeValEle = ValencyCalculator.getFreeValenceElectrons(mol, a, this.withoutH).intValue();
        }
        return freeValEle;
    }

    public double getBondOrder(IAtom a, IAtom b) throws CDKException {
        double bondOrder = 0.0;
        for (int i = 0; i < this.myMoleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer m = this.myMoleculeSet.getAtomContainer(i);
            IBond bond = m.getBond(a, b);
            if (bond == null) continue;
            return this.convertBondOrder(bond);
        }
        return bondOrder;
    }

    public int getBondStereo(IAtom a, IAtom b) throws CDKException {
        int bondOrder = 0;
        IBond bond = this.getBond(a, b);
        if (bond != null) {
            return this.convertBondStereo(bond);
        }
        return bondOrder;
    }

    public void setAromaticBond() throws CDKException, CDKException {
        for (int i = 0; i < this.myMoleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer m = this.myMoleculeSet.getAtomContainer(i);
            ExtAtomContainerManipulator.aromatizeMolecule(m);
        }
    }

    public List<IAtom> getAtoms() {
        return Collections.unmodifiableList(this.atomArray);
    }

    public IAtom getAtom(int pos) throws CDKException {
        if (pos >= this.atomArray.size()) {
            throw new CDKException("Passed index out of range");
        }
        return this.atomArray.get(pos);
    }

    public IBond getBond(IAtom a, IAtom b) {
        IBond bond = null;
        for (IBond localBond : this.bonds) {
            if (!localBond.contains(a) || !localBond.contains(b)) continue;
            bond = localBond;
        }
        return bond;
    }

    public IAtomContainer getAtomContainer(IAtom at) {
        IAtomContainer retMol = null;
        for (int i = 0; i < this.myMoleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer mol = this.myMoleculeSet.getAtomContainer(i);
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                IAtom ma = mol.getAtom(j);
                if (!ma.getID().equals(at.getID())) continue;
                retMol = mol;
                break;
            }
            if (retMol != null) break;
        }
        return retMol;
    }

    public double convertBondOrder(IBond bond) {
        double value;
        switch (bond.getOrder()) {
            case QUADRUPLE: {
                value = 4.0;
                break;
            }
            case TRIPLE: {
                value = 3.0;
                break;
            }
            case DOUBLE: {
                value = 2.0;
                break;
            }
            case SINGLE: {
                value = 1.0;
                break;
            }
            default: {
                value = 1.0;
            }
        }
        return value;
    }

    public int convertBondStereo(IBond bond) {
        int value;
        switch (bond.getStereo()) {
            case UP: {
                value = 1;
                break;
            }
            case UP_INVERTED: {
                value = 1;
                break;
            }
            case DOWN: {
                value = 6;
                break;
            }
            case DOWN_INVERTED: {
                value = 6;
                break;
            }
            case UP_OR_DOWN: {
                value = 4;
                break;
            }
            case UP_OR_DOWN_INVERTED: {
                value = 4;
                break;
            }
            case E_OR_Z: {
                value = 3;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    public IBond.Stereo convertStereo(int stereoValue) {
        IBond.Stereo stereo = IBond.Stereo.NONE;
        switch (stereoValue) {
            case 1: {
                stereo = IBond.Stereo.UP;
                break;
            }
            case 6: {
                stereo = IBond.Stereo.DOWN;
                break;
            }
            case 0: {
                stereo = IBond.Stereo.NONE;
                break;
            }
            case 4: {
                stereo = IBond.Stereo.UP_OR_DOWN;
                break;
            }
            case 3: {
                stereo = IBond.Stereo.E_OR_Z;
                break;
            }
        }
        return stereo;
    }

    public List<IBond> getBonds() {
        return Collections.unmodifiableList(this.bonds);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(this.atomArray.size()).append(NEW_LINE);
        this.atomArray.stream().forEach(atom -> result.append(atom.getSymbol()).append(atom.getID()).append("\t"));
        result.append(NEW_LINE);
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                result.append(this.getValue(i, j)).append("\t");
            }
            result.append(NEW_LINE);
        }
        return result.toString();
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

