/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.Bond;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.mechanism.BEMatrix;
import uk.ac.ebi.reactionblast.mechanism.DUModel;
import uk.ac.ebi.reactionblast.mechanism.RMatrix;
import uk.ac.ebi.reactionblast.mechanism.StereoChange;
import uk.ac.ebi.reactionblast.mechanism.helper.AtomAtomMappingContainer;
import uk.ac.ebi.reactionblast.mechanism.helper.AtomStereoChangeInformation;
import uk.ac.ebi.reactionblast.mechanism.helper.BondChange;
import uk.ac.ebi.reactionblast.mechanism.interfaces.ECBLAST_BOND_CHANGE_FLAGS;
import uk.ac.ebi.reactionblast.mechanism.interfaces.ECBLAST_FLAGS;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;

public final class BondChangeAnnotator
extends DUModel {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final long serialVersionUID = 988987678877861L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(BondChangeAnnotator.class);
    private static final boolean DEBUG = false;

    protected BondChangeAnnotator(IReaction reaction, boolean withoutHydrogen, boolean generate2D, boolean generate3D) throws Exception {
        super(reaction, withoutHydrogen, generate2D, generate3D);
    }

    @Override
    public synchronized AtomAtomMappingContainer getMappingContainer() {
        return this.mapping;
    }

    @Override
    public synchronized BEMatrix getEductBEMatrix() {
        return this.reactantBE;
    }

    @Override
    public synchronized List<BondChange> getBondChangeList() {
        return this.bondChangeList;
    }

    @Override
    public synchronized Collection<IAtom> getReactionCenterSet() {
        return this.reactionCenterList;
    }

    @Override
    public synchronized List<AtomStereoChangeInformation> getStereoChangeList() {
        return this.stereoChangeList;
    }

    @Override
    public synchronized BEMatrix getProductBEMatrix() {
        return this.productBE;
    }

    @Override
    public synchronized Map<IAtom, IAtom> getMappingMap() {
        return Collections.synchronizedMap(this.mappingMap);
    }

    @Override
    public synchronized RMatrix getRMatrix() {
        return this.reactionMatrix;
    }

    @Override
    public synchronized boolean hasRMatrix() {
        return this.reactionMatrix != null;
    }

    @Override
    public synchronized void printBMatrix() {
        BondChangeAnnotator.printBEMatrix(this.reactantBE);
    }

    public List<AtomStereoChangeInformation> getConformationChangeList() {
        return this.conformationChangeList;
    }

    @Override
    public synchronized void writeBMatrix(File outputFile) {
        try {
            BondChangeAnnotator.writeBEMatrix(outputFile, this.reactantBE);
        }
        catch (IOException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    @Override
    public synchronized void printEMatrix() {
        BondChangeAnnotator.printBEMatrix(this.productBE);
    }

    @Override
    public synchronized void writeEMatrix(File outputFile) {
        try {
            BondChangeAnnotator.writeBEMatrix(outputFile, this.productBE);
        }
        catch (IOException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    @Override
    public synchronized void printRMatrix() {
        BondChangeAnnotator.printReactionMatrix(this.reactionMatrix);
    }

    @Override
    public synchronized void writeRMatrix(File outputFile) {
        try {
            BondChangeAnnotator.writeReactionMatrix(outputFile, this.reactionMatrix);
        }
        catch (IOException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    protected synchronized void markBondChanges() throws Exception {
        Cycles cycles;
        CycleFinder cf;
        BEMatrix substrateBEMatrix = this.reactantBE;
        BEMatrix productBEMatrix = this.productBE;
        for (IAtomContainer atomContainerQ : this.reactantSet.atomContainers()) {
            try {
                BondChangeAnnotator.initializeMolecule(atomContainerQ);
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            cf = Cycles.mcb();
            cycles = cf.find(atomContainerQ);
            IRingSet singleRingsQ = cycles.toRingSet();
            this.queryRingSet.add(singleRingsQ);
        }
        for (IAtomContainer atomContainerT : this.productSet.atomContainers()) {
            try {
                BondChangeAnnotator.initializeMolecule(atomContainerT);
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            cf = Cycles.mcb();
            cycles = cf.find(atomContainerT);
            IRingSet singleRingsT = cycles.toRingSet();
            this.targetRingSet.add(singleRingsT);
        }
        for (StereoChange sc : this.stereogenicCenters) {
            IAtom atomE = sc.getReactantAtom();
            IAtom atomP = sc.getProductAtom();
            IStereoAndConformation rsb = sc.getReactantAtomStereo();
            IStereoAndConformation psb = sc.getProductAtomStereo();
            if (atomE == null || atomP == null) continue;
            if (atomE.getSymbol().equals("P") || atomP.getSymbol().equals("P")) {
                LOGGER.warn(NEW_LINE + "WARNING: The stereo change " + atomE.getSymbol() + " not supported");
                continue;
            }
            atomE.setProperty((Object)ECBLAST_FLAGS.ATOM_STEREO_CHANGE_INFORMATION, rsb);
            atomP.setProperty((Object)ECBLAST_FLAGS.ATOM_STEREO_CHANGE_INFORMATION, psb);
            atomE.setFlag(1024, true);
            atomP.setFlag(1024, true);
            this.getReactionCenterSet().add(atomE);
            this.getReactionCenterSet().add(atomP);
            if (sc.getReactantAtomStereo().equals(IStereoAndConformation.E) || sc.getProductAtomStereo().equals(IStereoAndConformation.Z) || sc.getReactantAtomStereo().equals(IStereoAndConformation.Z) || sc.getProductAtomStereo().equals(IStereoAndConformation.E)) {
                this.getConformationChangeList().add(new AtomStereoChangeInformation(atomE, atomP, sc.getReactantAtomStereo(), sc.getProductAtomStereo()));
                continue;
            }
            if (!sc.getReactantAtomStereo().equals(IStereoAndConformation.R) && !sc.getProductAtomStereo().equals(IStereoAndConformation.S) && !sc.getReactantAtomStereo().equals(IStereoAndConformation.S) && !sc.getProductAtomStereo().equals(IStereoAndConformation.R)) continue;
            this.getStereoChangeList().add(new AtomStereoChangeInformation(atomE, atomP, sc.getReactantAtomStereo(), sc.getProductAtomStereo()));
        }
        int sizeQ = this.reactionMatrix.getReactantsAtomArray().size();
        int sizeT = this.reactionMatrix.getProductsAtomArray().size();
        for (int i = 0; i < this.reactionMatrix.getRowDimension(); ++i) {
            for (int j = i; j < this.reactionMatrix.getColumnDimension(); ++j) {
                ECBLAST_BOND_CHANGE_FLAGS bondChangeInformation;
                IBond affectedBondProducts;
                IBond affectedBondReactants;
                if (i != j && this.reactionMatrix.getValue(i, j) == 0.0) {
                    affectedBondReactants = null;
                    affectedBondProducts = null;
                    try {
                        if (i < sizeQ && j < sizeQ) {
                            affectedBondReactants = this.getBondOfReactantsByRMatrix(this.reactionMatrix.getReactantAtom(i), this.reactionMatrix.getReactantAtom(j));
                        }
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                    try {
                        if (i < sizeT && j < sizeT) {
                            affectedBondProducts = this.getBondOfProductsByRMatrix(this.reactionMatrix.getProductAtom(i), this.reactionMatrix.getProductAtom(j));
                        }
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                    if (affectedBondReactants == null && affectedBondProducts == null) continue;
                    int kekuleEffect = 0;
                    kekuleEffect = this.isAlternateKekuleChange(affectedBondReactants, affectedBondProducts);
                    if (kekuleEffect == 0) {
                        bondChangeInformation = ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER;
                        if (affectedBondReactants != null) {
                            affectedBondReactants.getAtom(0).setFlag(1024, true);
                            affectedBondReactants.getAtom(1).setFlag(1024, true);
                            this.getReactionCenterSet().add(affectedBondReactants.getAtom(0));
                            this.getReactionCenterSet().add(affectedBondReactants.getAtom(1));
                            affectedBondReactants.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)bondChangeInformation);
                        }
                        if (affectedBondProducts != null) {
                            affectedBondProducts.getAtom(0).setFlag(1024, true);
                            affectedBondProducts.getAtom(1).setFlag(1024, true);
                            this.getReactionCenterSet().add(affectedBondProducts.getAtom(0));
                            this.getReactionCenterSet().add(affectedBondProducts.getAtom(1));
                            affectedBondProducts.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)bondChangeInformation);
                        }
                        this.getBondChangeList().add(new BondChange(affectedBondReactants, affectedBondProducts));
                    }
                }
                if (this.reactionMatrix.getValue(i, j) == 0.0) continue;
                if (i == j) {
                    try {
                        IAtom reactantAtom = this.reactionMatrix.getReactantAtom(i);
                        if (reactantAtom != null) {
                            reactantAtom.setFlag(1024, true);
                            this.getReactionCenterSet().add(reactantAtom);
                        }
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                    try {
                        IAtom productAtom = this.reactionMatrix.getProductAtom(j);
                        if (productAtom != null) {
                            productAtom.setFlag(1024, true);
                            this.getReactionCenterSet().add(productAtom);
                        }
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                }
                try {
                    int kekuleEffect;
                    affectedBondReactants = this.getBondOfReactantsByRMatrix(this.reactionMatrix.getReactantAtom(i), this.reactionMatrix.getReactantAtom(j));
                    affectedBondProducts = this.getBondOfProductsByRMatrix(this.reactionMatrix.getProductAtom(i), this.reactionMatrix.getProductAtom(j));
                    if (affectedBondReactants == null && affectedBondProducts == null || affectedBondReactants != null && affectedBondProducts != null && affectedBondReactants.getProperties().containsKey((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION) && affectedBondProducts.getProperties().containsKey((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION) || (kekuleEffect = this.isKekuleEffect(affectedBondReactants, affectedBondProducts)) == 1) continue;
                    if (this.reactionMatrix.getValue(i, j) < 0.0) {
                        bondChangeInformation = productBEMatrix.getValue(i, j) == 0.0 && affectedBondProducts == null ? ECBLAST_BOND_CHANGE_FLAGS.BOND_CLEAVED : ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER;
                        if (affectedBondReactants != null) {
                            affectedBondReactants.getAtom(0).setFlag(1024, true);
                            affectedBondReactants.getAtom(1).setFlag(1024, true);
                            this.getReactionCenterSet().add(affectedBondReactants.getAtom(0));
                            this.getReactionCenterSet().add(affectedBondReactants.getAtom(1));
                            affectedBondReactants.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)bondChangeInformation);
                        }
                        if (affectedBondProducts != null) {
                            affectedBondProducts.getAtom(0).setFlag(1024, true);
                            affectedBondProducts.getAtom(1).setFlag(1024, true);
                            this.getReactionCenterSet().add(affectedBondProducts.getAtom(0));
                            this.getReactionCenterSet().add(affectedBondProducts.getAtom(1));
                            affectedBondProducts.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)bondChangeInformation);
                        }
                    } else if (this.reactionMatrix.getValue(i, j) > 0.0) {
                        bondChangeInformation = substrateBEMatrix.getValue(i, j) == 0.0 && affectedBondReactants == null ? ECBLAST_BOND_CHANGE_FLAGS.BOND_FORMED : ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER;
                        if (affectedBondReactants != null) {
                            affectedBondReactants.getAtom(0).setFlag(1024, true);
                            affectedBondReactants.getAtom(1).setFlag(1024, true);
                            this.getReactionCenterSet().add(affectedBondReactants.getAtom(0));
                            this.getReactionCenterSet().add(affectedBondReactants.getAtom(1));
                            affectedBondReactants.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)bondChangeInformation);
                        }
                        if (affectedBondProducts != null) {
                            affectedBondProducts.getAtom(0).setFlag(1024, true);
                            affectedBondProducts.getAtom(1).setFlag(1024, true);
                            this.getReactionCenterSet().add(affectedBondProducts.getAtom(0));
                            this.getReactionCenterSet().add(affectedBondProducts.getAtom(1));
                            affectedBondProducts.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)bondChangeInformation);
                        }
                    }
                    this.getBondChangeList().add(new BondChange(affectedBondReactants, affectedBondProducts));
                    continue;
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
        }
        this.markHydrogenDisplacementBondChanges();
        this.markUnMappedAtoms();
    }

    private synchronized void markHydrogenDisplacementBondChanges() {
        for (IAtom eductAtom : this.mappingMap.keySet()) {
            BondChange bondChange;
            IBond pBond;
            IAtom productAtom = (IAtom)this.mappingMap.get(eductAtom);
            IBond affectedBondReactants = null;
            IBond affectedBondProducts = null;
            IAtomContainer rMol = BondChangeAnnotator.getAtomContainer(eductAtom, this.reactantSet);
            IAtomContainer pMol = BondChangeAnnotator.getAtomContainer(productAtom, this.productSet);
            if (!eductAtom.getSymbol().equalsIgnoreCase("H") || !productAtom.getSymbol().equalsIgnoreCase("H")) continue;
            List<IBond> connectedEductBondsList = rMol.getConnectedBondsList(eductAtom);
            List<IBond> connectedProductBondsList = pMol.getConnectedBondsList(productAtom);
            if (rMol.getConnectedBondsCount(eductAtom) > 0 && pMol.getConnectedBondsCount(productAtom) > 0) {
                boolean isBondChange;
                for (IBond eBond : connectedEductBondsList) {
                    isBondChange = true;
                    String attachedEAtomID = eBond.getOther(eductAtom).getID();
                    for (IBond pBond2 : connectedProductBondsList) {
                        String attachedPAtomID = pBond2.getOther(productAtom).getID();
                        if (!attachedEAtomID.equalsIgnoreCase(attachedPAtomID)) continue;
                        isBondChange = false;
                        break;
                    }
                    if (!isBondChange) continue;
                    eBond.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_CLEAVED);
                    affectedBondReactants = eBond;
                }
                for (IBond pBond3 : connectedProductBondsList) {
                    isBondChange = true;
                    String attachedPAtomID = pBond3.getOther(productAtom).getID();
                    for (IBond eBond : connectedEductBondsList) {
                        String attachedEAtomID = eBond.getOther(eductAtom).getID();
                        if (!attachedPAtomID.equalsIgnoreCase(attachedEAtomID)) continue;
                        isBondChange = false;
                        break;
                    }
                    if (!isBondChange) continue;
                    pBond3.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_FORMED);
                    affectedBondProducts = pBond3;
                }
                if (affectedBondReactants == null || affectedBondProducts == null) continue;
                affectedBondReactants.getAtom(0).setFlag(1024, true);
                affectedBondReactants.getAtom(1).setFlag(1024, true);
                affectedBondProducts.getAtom(0).setFlag(1024, true);
                affectedBondProducts.getAtom(1).setFlag(1024, true);
                this.getReactionCenterSet().add(affectedBondReactants.getAtom(0));
                this.getReactionCenterSet().add(affectedBondReactants.getAtom(1));
                this.getReactionCenterSet().add(affectedBondProducts.getAtom(0));
                this.getReactionCenterSet().add(affectedBondProducts.getAtom(1));
                BondChange bondChange2 = new BondChange(affectedBondReactants, affectedBondProducts);
                this.getBondChangeList().add(bondChange2);
                continue;
            }
            if (rMol.getConnectedBondsCount(eductAtom) == 0 && pMol.getConnectedBondsCount(productAtom) > 0) {
                IBond eBond;
                PseudoAtom psudoAtom = new PseudoAtom("PsH");
                eBond = new Bond(psudoAtom, eductAtom, IBond.Order.SINGLE);
                pBond = connectedProductBondsList.iterator().next();
                eBond.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.PSEUDO_BOND);
                pBond.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_FORMED);
                affectedBondReactants = eBond;
                affectedBondProducts = pBond;
                affectedBondProducts.getAtom(0).setFlag(1024, true);
                affectedBondProducts.getAtom(1).setFlag(1024, true);
                this.getReactionCenterSet().add(affectedBondProducts.getAtom(0));
                this.getReactionCenterSet().add(affectedBondProducts.getAtom(1));
                bondChange = new BondChange(affectedBondReactants, affectedBondProducts);
                this.getBondChangeList().add(bondChange);
                continue;
            }
            if (rMol.getConnectedBondsCount(eductAtom) <= 0 || pMol.getConnectedBondsCount(productAtom) != 0) continue;
            IBond eBond = connectedEductBondsList.iterator().next();
            PseudoAtom psudoAtom = new PseudoAtom("PsH");
            pBond = new Bond(psudoAtom, productAtom, IBond.Order.SINGLE);
            eBond.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_CLEAVED);
            pBond.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.PSEUDO_BOND);
            affectedBondReactants = eBond;
            affectedBondProducts = pBond;
            affectedBondReactants.getAtom(0).setFlag(1024, true);
            affectedBondReactants.getAtom(1).setFlag(1024, true);
            this.getReactionCenterSet().add(affectedBondReactants.getAtom(0));
            this.getReactionCenterSet().add(affectedBondReactants.getAtom(1));
            bondChange = new BondChange(affectedBondReactants, affectedBondProducts);
            this.getBondChangeList().add(bondChange);
        }
    }

    private synchronized void markUnMappedAtoms() {
        BondChange bondChange;
        boolean isNotMapped;
        for (IAtomContainer acE : this.reactantSet.atomContainers()) {
            for (IBond affectedBondReactants : acE.bonds()) {
                isNotMapped = false;
                if (!this.mappingMap.containsKey(affectedBondReactants.getAtom(0)) && this.mappingMap.containsKey(affectedBondReactants.getAtom(1)) || this.mappingMap.containsKey(affectedBondReactants.getAtom(0)) && !this.mappingMap.containsKey(affectedBondReactants.getAtom(1))) {
                    isNotMapped = true;
                }
                IBond pBond = null;
                if (!isNotMapped) continue;
                affectedBondReactants.getAtom(0).setFlag(1024, true);
                affectedBondReactants.getAtom(1).setFlag(1024, true);
                this.getReactionCenterSet().add(affectedBondReactants.getAtom(0));
                this.getReactionCenterSet().add(affectedBondReactants.getAtom(1));
                affectedBondReactants.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_CLEAVED);
                bondChange = new BondChange(affectedBondReactants, pBond);
                this.getBondChangeList().add(bondChange);
            }
        }
        for (IAtomContainer acP : this.productSet.atomContainers()) {
            for (IBond affectedBondProducts : acP.bonds()) {
                isNotMapped = false;
                if (!this.mappingMap.containsValue(affectedBondProducts.getAtom(0)) && this.mappingMap.containsValue(affectedBondProducts.getAtom(1)) || this.mappingMap.containsValue(affectedBondProducts.getAtom(0)) && !this.mappingMap.containsValue(affectedBondProducts.getAtom(1))) {
                    isNotMapped = true;
                }
                IBond eBond = null;
                if (!isNotMapped) continue;
                affectedBondProducts.getAtom(0).setFlag(1024, true);
                affectedBondProducts.getAtom(1).setFlag(1024, true);
                this.getReactionCenterSet().add(affectedBondProducts.getAtom(0));
                this.getReactionCenterSet().add(affectedBondProducts.getAtom(1));
                affectedBondProducts.setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_FORMED);
                bondChange = new BondChange(eBond, affectedBondProducts);
                this.getBondChangeList().add(bondChange);
            }
        }
    }

    private synchronized IBond getBondOfReactantsByRMatrix(IAtom atom1, IAtom atom2) {
        for (int i = 0; i < this.reactantSet.getAtomContainerCount(); ++i) {
            if (this.reactantSet.getAtomContainer(i).getBond(atom1, atom2) == null) continue;
            return this.reactantSet.getAtomContainer(i).getBond(atom1, atom2);
        }
        return null;
    }

    private synchronized IBond getBondOfProductsByRMatrix(IAtom atom1, IAtom atom2) {
        for (int i = 0; i < this.productSet.getAtomContainerCount(); ++i) {
            if (this.productSet.getAtomContainer(i).getBond(atom1, atom2) == null) continue;
            return this.productSet.getAtomContainer(i).getBond(atom1, atom2);
        }
        return null;
    }

    public int isKekuleEffect(IBond affectedBondReactants, IBond affectedBondProducts) {
        if (affectedBondReactants != null && affectedBondProducts != null && affectedBondReactants.getFlag(2) == affectedBondProducts.getFlag(2) && (!affectedBondReactants.getFlag(32) && affectedBondProducts.getFlag(32) || affectedBondReactants.getFlag(32) && !affectedBondProducts.getFlag(32))) {
            IRingSet smallestRingSetR = BondChangeAnnotator.getSmallestRingSet(affectedBondReactants, this.queryRingSet);
            IRingSet smallestRingSetP = BondChangeAnnotator.getSmallestRingSet(affectedBondProducts, this.targetRingSet);
            int changeCounter = 0;
            for (IAtomContainer rRing : smallestRingSetR.atomContainers()) {
                for (IAtomContainer pRing : smallestRingSetP.atomContainers()) {
                    if (rRing.getAtomCount() != pRing.getAtomCount()) continue;
                    for (IBond rBond : rRing.bonds()) {
                        for (IBond pBond : pRing.bonds()) {
                            if (rBond.getAtom(0).getID().equals(pBond.getAtom(0).getID()) && rBond.getAtom(1).getID().equals(pBond.getAtom(1).getID()) && !rBond.getOrder().equals((Object)pBond.getOrder())) {
                                ++changeCounter;
                            }
                            if (!rBond.getAtom(0).getID().equals(pBond.getAtom(1).getID()) || !rBond.getAtom(1).getID().equals(pBond.getAtom(0).getID()) || rBond.getOrder().equals((Object)pBond.getOrder())) continue;
                            ++changeCounter;
                        }
                    }
                }
            }
            if (changeCounter == 1) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public int isAlternateKekuleChange(IBond affectedBondReactants, IBond affectedBondProducts) {
        if (affectedBondReactants != null && affectedBondProducts != null && affectedBondReactants.getFlag(2) == affectedBondProducts.getFlag(2) && (!affectedBondReactants.getFlag(32) && affectedBondProducts.getFlag(32) || affectedBondReactants.getFlag(32) && !affectedBondProducts.getFlag(32))) {
            IRingSet smallestRingSetR = BondChangeAnnotator.getSmallestRingSet(affectedBondReactants, this.queryRingSet);
            IRingSet smallestRingSetP = BondChangeAnnotator.getSmallestRingSet(affectedBondProducts, this.targetRingSet);
            int countR = BondChangeAnnotator.getNeighbourBondOrderCountFromRing(affectedBondReactants, smallestRingSetR);
            int countP = BondChangeAnnotator.getNeighbourBondOrderCountFromRing(affectedBondProducts, smallestRingSetP);
            int sizeR = smallestRingSetR.getAtomContainerCount() > 0 ? smallestRingSetR.atomContainers().iterator().next().getBondCount() : 0;
            int sizeP = smallestRingSetP.getAtomContainerCount() > 0 ? smallestRingSetP.atomContainers().iterator().next().getBondCount() : 0;
            IAtom atomR1 = affectedBondReactants.getAtom(0);
            IAtom atomR2 = affectedBondReactants.getAtom(1);
            IAtom atomP1 = affectedBondProducts.getAtom(0);
            IAtom atomP2 = affectedBondProducts.getAtom(1);
            if (atomR1.getID().equals(atomP1.getID()) && atomR2.getID().equals(atomP2.getID()) && atomR1.getHybridization() != null && atomR2.getHybridization() != null && atomP1.getHybridization() != null && atomP2.getHybridization() != null) {
                if (!atomR1.getHybridization().equals((Object)atomP1.getHybridization()) && !atomR2.getHybridization().equals((Object)atomP2.getHybridization())) {
                    if (countR == countP && sizeR == sizeP) {
                        return 1;
                    }
                    if (!affectedBondReactants.getOrder().equals((Object)affectedBondProducts.getOrder()) && Math.abs(countR - countP) <= 1 && sizeR == sizeP) {
                        return 1;
                    }
                    if (affectedBondReactants.getOrder().equals((Object)affectedBondProducts.getOrder()) && Math.abs(countR - countP) == 0 && sizeR == sizeP) {
                        return 0;
                    }
                } else if (atomR1.getHybridization().equals((Object)atomP1.getHybridization()) && atomR2.getHybridization().equals((Object)atomP2.getHybridization())) {
                    if (!affectedBondReactants.getOrder().equals((Object)affectedBondProducts.getOrder()) && Math.abs(countR - countP) <= 1 && sizeR == sizeP) {
                        return 0;
                    }
                    if (affectedBondReactants.getOrder().equals((Object)affectedBondProducts.getOrder()) && Math.abs(countR - countP) > 1 && sizeR == sizeP) {
                        return 0;
                    }
                }
            }
        }
        return -1;
    }
}

